

//Material------------------------------
	#define MATID_SKY 					0.0
	#define MATID_LAND 					1.0
	#define MATID_GRASS 				2.0
	#define MATID_LEAVES 				3.0
	#define MATID_HAND 					4.0 

	#define MATID_WATER 				6.0
	#define MATID_STAINEDGLASS 			7.0
	#define MATID_ICE 					8.0

	#define MATID_ENTITIES_PLAYER 		10.0
	#define MATID_ENTITIES_LIT_HIGH 	11.0
	#define MATID_ENTITIES_LIT_MEDIUM 	12.0
	#define MATID_ENTITIES_LIT_LOW 		13.0
	#define MATID_ENTITIES_SNOW 		14.0
	#define MATID_LIGHTNING 			15.0
	#define MATID_BEACON_BEAM 			16.0

	#define MATID_GLOWSTONE 			20.0
	#define MATID_TORCH 				21.0
	#define MATID_LAVA 					22.0
	#define MATID_FIRE 					23.0
	#define MATID_REDSTONE_TORCH 		24.0
	#define MATID_REDSTONE 				25.0
	#define MATID_SOULFIRE 				26.0
	#define MATID_AMETHYST 				27.0
	#define MATID_OXIDIZED_BULB 		28.0

	#define MATID_PARTICLE 				40.0
	#define MATID_PARTICLE_LIT 			41.0

	#define MATID_END_PORTAL 			50.0

	#define MATID_SELECTION 			200.0





//Light Source--------------------------
	#define SUNLIGHT_INTENSITY				1.0	// [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
	#define SKYLIGHT_INTENSITY 				1.0	// [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]

	#define NOLIGHT_BRIGHTNESS				0.000005 // [0.0 0.000001 0.000002 0.000003 0.000005 0.000007 0.00001 0.000015 0.00002 0.00003 0.00005 0.00007 0.0001 0.00015 0.0002 0.0003 0.0005 0.0007 0.001]
	#define NETHER_BRIGHTNESS 				1.0 // [0.1 0.15 0.2 0.3 0.5 0.7 1.0 1.5 2.0 3.0 5.0 7.0 10.0 15.0 20.0 30.0 50.0 70.0 100.0]
	#define TORCHLIGHT_BRIGHTNESS			1.0 // [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]

	#define TORCHLIGHT_COLOR_TEMPERATURE 	3000 // [2000 2500 3000 3500 4000 4500 5000 5500 6000 6500 7000 7500 8000 8500 9000 9500 10000 12000 15000]

  //#define DIRECTIONAL_BLOCKLIGHT
	#define DIRECTIONAL_BLOCKLIGHT_STRENGTH 0.5 // [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]

	#define NIGHT_BRIGHTNESS 				0.0003 // [0.0 0.0001 0.00015 0.0002 0.0003 0.0005 0.0007 0.001 0.0015 0.002 0.003 0.005 0.007 0.01 1.0]
	#define COLD_MOONLIGHT

//Held Light----------------------------
	#define HELDLIGHT_BRIGHTNESS 			1.0 // [0.0 0.1 0.15 0.2 0.3 0.5 0.7 1.0 1.5 2.0 3.0 5.0 7.0 10.0 15.0 20.0 30.0 50.0 70.0 100.0]
	#define HELDLIGHT_FALLOFF 				1.8 // [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.2 1.4 1.6 1.8 2.0]

	#define SPECULAR_HELDLIGHT
	#define HELDLIGHT_SHADOW

	#define HELDLIGHT_MODE 					0 // [0 1]

	#define FLASHLIGHT_POS_L_X 				-0.25 	// [-1.0 -0.9 -0.8 -0.7 -0.6 -0.5 -0.45 -0.4 -0.35 -0.3 -0.25 -0.2 -0.15 -0.1 -0.05 0.0 0.05 0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.6 0.7 0.8 0.9 1.0]
	#define FLASHLIGHT_POS_L_Y 				-0.15 	// [-1.5 -1.4 -1.3 -1.2 -1.1 -1.0 -1.0 -0.9 -0.8 -0.7 -0.6 -0.5 -0.45 -0.4 -0.35 -0.3 -0.25 -0.2 -0.15 -0.1 -0.05 0.0 0.05 0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.6 0.7 0.8 0.9 1.0]
	#define FLASHLIGHT_POS_R_X 				0.25 	// [-1.0 -0.9 -0.8 -0.7 -0.6 -0.5 -0.45 -0.4 -0.35 -0.3 -0.25 -0.2 -0.15 -0.1 -0.05 0.0 0.05 0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.6 0.7 0.8 0.9 1.0]
	#define FLASHLIGHT_POS_R_Y 				-0.15 	// [-1.5 -1.4 -1.3 -1.2 -1.1 -1.0 -1.0 -0.9 -0.8 -0.7 -0.6 -0.5 -0.45 -0.4 -0.35 -0.3 -0.25 -0.2 -0.15 -0.1 -0.05 0.0 0.05 0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.6 0.7 0.8 0.9 1.0]

  //#define FLASHLIGHT_HELDLIGHT
  	#define FLASHLIGHT_HELDLIGHT_FALLOFF 	1.0 // [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.2 1.4 1.6 1.8 2.0]
	#define FLASHLIGHT_FOV 					0.25 // [0.05 0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5]
	#define FLASHLIGHT_CAMERA_SMOOTH
	#define FLASHLIGHT_CAMERA_SMOOTH_TIME   10.0 // [5.0 7.0 10.0 15.0 20.0 30.0 50.0]

	#define FLASHLIGHT_COLOR_R 				1.0 // // [0.0 0.05 0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95 1.0]
	#define FLASHLIGHT_COLOR_G 				1.0 // // [0.0 0.05 0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95 1.0]
	#define FLASHLIGHT_COLOR_B 				1.0 // // [0.0 0.05 0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95 1.0]

//Shadow--------------------------------
	#define SHADOW_MAP_BIAS			0.9	// [0.0 0.1 0.7 0.75 0.8 0.85 0.9 0.92 0.94 0.96]

	#define VARIABLE_PENUMBRA_SHADOWS
	#define SHADOW_BASIC_BLUR 		1.0 // [0.0 0.25 0.5 0.75 1.0 1.25 1.5 1.75 2.0]
	#define VPS_QUALITY 			16  // [4 8 12 16 24 32 48 64 96 128]
	#define VPS_SPREAD 				0.1 // [0.02 0.03 0.05 0.07 0.1 0.15 0.2 0.3 0.5 0.7 1.0 1.5 2.0 3.0 5.0 7.0 10.0]
	#define COLORED_SHADOWS

	#define SCREEN_SPACE_SHADOWS

	#define CAUSTICS
	#define CAUSTICS_TEX_RESOLUTION 500.0

	#define SUNLIGHT_LEAK_FIX

//GI------------------------------------
	#define GI_RSM

	#define GI_QUALITY				16  // [4 8 12 16 24 32 48 64 96 128]
	#define GI_RADIUS				7.0 // [1.0 1.5 2.0 3.0 5.0 7.0 10.0 15.0 20.0 30.0 50.0 70.0 100.0]
	#define GI_BRIGHTNESS			1.0 // [0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.6 1.8 2.0 2.5 3.0 5.0 7.0 10.0 15.0 20.0 30.0 50.0 70.0 100.0]
	#define GI_RENDER_RESOLUTION	0.5	// [0.25 0.5]
	#define GI_FALLOFF 				1.1 // [1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]

	#define GI_SKYLIGHT_FALLOFF

//AO------------------------------------
	#define GTAO

	#define GTAO_QUALITY 		3 // [1 2 3 4 5 6 8 10 15 20]
	#define GTAO_SLICE_QUALITY 	3 // [1 2 3 4 5 6 8 10 15 20]

	#define GTAO_RADIUS_MODE 	0 //[0 1]
	#define GTAO_WORLD_RADIUS 	2.0 // [0.5 0.7 1.0 1.5 2.0 3.0 5.0 7.0 10.0 15.0 20.0]
	#define GTAO_SCREEN_RADIUS 	0.05 // [0.001 0.0015 0.002 0.003 0.005 0.007 0.01 0.015 0.02 0.03 0.05 0.07 0.1 0.15 0.2 0.3 0.5]
	#define GTAO_MAX_RADIUS 	0.1 // [0.01 0.015 0.02 0.03 0.05 0.07 0.1 0.15 0.2 0.3 0.5]

	#define GTAO_FALLOFF_START 	0.7 // [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]
  //#define GTAO_FALLOFF_Z_OFFSET

	#define GTAO_STRENGTH 		0.95 // [0.0 0.05 0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.525 0.55 0.575 0.6 0.625 0.65 0.675 0.7 0.725 0.75 0.775 0.8 0.85 0.9 0.95 1.0]

	#define GTAO_MULTIBOUNCE





//Texture-------------------------------
	#define TEXTURE_RESOLUTION 0 // [0 1 2 4 8 16 32 64 128 256 512 1024 2048 4096 8192]
	#define ENTITIES_TEXTURE_RESOLUTION 16 // [1 2 4 8 16 32 64 128 256 512 1024 2048 4096 8192]

	#define ANISOTROPIC_FILTERING_QUALITY 4 // [0 2 4 8 16]
  //#define ANISOTROPIC_FILTERING_NORMAL_SPECULAR

//POM-----------------------------------
  //#define PARALLAX
	#define ENTITIES_PARALLAX

	#define PARALLAX_MODE 				0 // [0 1 2]

	#define PARALLAX_QUALITY 			40 // [10 15 20 30 40 60 80 100 150 200 300 500]
	#define PARALLAX_MAX_REFINEMENTS 	12 // [0 2 4 6 8 12 16]

	#define PARALLAX_SHADOW
	#define PARALLAX_SHADOW_QUALITY 	20 // [10 15 20 30 40 60 80 100 150 200 300 500]

	#define PARALLAX_BASED_NORMAL 		1 // [0 1 2]
 	#define PARALLAX_DEPTH 				1.0 // [0.1 0.15 0.2 0.3 0.5 0.75 1.0 1.25 1.5 1.75 2.0 3.0 5.0 7.5 10.0]

	#define PARALLAX_FADE

//PBR------------------------------
	#define ENABLE_PBR
	#define TEXTURE_PBR_FORMAT 0 //[0 2]

	#define ROUGHNESS_CLAMP

  //#define TERRAIN_NORMAL_CLAMP
	#define HAND_NORMAL_CLAMP
	#define ENTITIES_NORMAL_CLAMP

	#define RAYTRACE_QUALITY 			16 //[8 12 16 24 32 64 128 256 512]
	#define RAYTRACE_REFINEMENT_STEPS 	5 //[2 3 4 5 6 7 8 9 10 12 14 16 18 20 22 24 26 28 30 32
	#define RAYTRACE_ZDIFF_THRESHOLD 	0.2 // [0.05 0.1 0.15 0.2 0.3 0.4 0.5]

	#define SKY_IMAGE_RESOLUTION 		64.0 // [32.0 48.0 64.0 96.0 128.0 192.0 256.0 384.0 512.0]

  //#define LANDSCATTERING_REFLECTION
	#define VFOG_REFLECTION
  //#define LANDSCATTERING_REFRACTION
  //#define VFOG_REFRACTION

	#define TEXTURE_EMISSIVENESS_MODE 	2 // [0 1 2]
	#define TEXTURE_BRIGHTNESS 			1.0 // [0.0 0.1 0.2 0.3 0.5 0.7 1.0 1.5 2.0 3.0 5.0 7.0 10.0 15.0 20.0 30.0 50.0 70.0 100.0]
	#define EMISSIVENESS_BRIGHTNESS 	1.0 // [0.0 0.1 0.2 0.3 0.5 0.7 1.0 1.5 2.0 3.0 5.0 7.0 10.0 15.0 20.0 30.0 50.0 70.0 100.0]
	#define EMISSIVENESS_GAMMA  		2.2 // [1.0 1.2 1.4 1.6 1.8 2.0 2.2 2.4 2.6 2.8 3.0 4.0 5.0 6.0 7.0 8.0 9.0 10.0]

  //#define TEXTURE_PBR_POROSITY
	#define TEXTURE_DEFAULT_POROSITY 	0.3 // [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]
	#define POROSITY_ABSORPTION 		0.7 // [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]
	#define SURFACE_WETNESS 			0.0 // [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]

	#define SSS_QUALITY 				6 // [2 3 4 6 8 12 16 24 32]
	#define SSS_STRENGTH 				1.0 // [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 3.0 5.0 7.0 10.0]
	#define SSS_STRENGTH_OFFSET 		0.0 // [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 3.0 5.0 7.0 10.0]
	#define SSS_BRIGHTNESS 				1.0 // [0.0 0.1 0.2 0.3 0.5 0.7 1.0 1.5 2.0 3.0 5.0 7.0 10.0 15.0 20.0 30.0 50.0 70.0 100.0]
  //#define SSS_NORMAL

//Water & Rain--------------------------
	#define WATER_PARALLAX
	#define WAVE_SCALE 				0.05 // [0.01 0.02 0.03 0.04 0.05 0.06 0.07 0.08 0.09 0.1 0.15 0.2 0.3 0.5 0.7 1.0]
	#define WAVE_HEIGHT 			1.2 // [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 3.0 5.0 7.0 10.0]

	#define WATER_REFRACT_IOR		1.2

  //#define DISABLE_LOCAL_PRECIPITATION

	#define RAIN_VISIBILITY			1.0 // [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 5.0]

	#define RAIN_SPLASH_EFFECT

	#define RAIN_WIND_X 			0.1  // [-1.0 -0.9 -0.8 -0.7 -0.6 -0.5 -0.45 -0.4 -0.35 -0.3 -0.25 -0.2 -0.175 -0.15 -0.125 -0.1 -0.075 -0.05 -0.025 0.0 0.025 0.05 0.075 0.1 0.125 0.15 0.175 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.6 0.7 0.8 0.9 1.0]
	#define RAIN_WIND_Z 			0.05 // [-1.0 -0.9 -0.8 -0.7 -0.6 -0.5 -0.45 -0.4 -0.35 -0.3 -0.25 -0.2 -0.175 -0.15 -0.125 -0.1 -0.075 -0.05 -0.025 0.0 0.025 0.05 0.075 0.1 0.125 0.15 0.175 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.6 0.7 0.8 0.9 1.0]
	#define RAIN_DISTURBANCE 		0.05 // [0.0 0.01  0.015 0.02 0.03 0.05 0.07 0.1 0.15 0.2]

	#define RAIN_SHADOW 			1.0 // [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]

//Sky Texture---------------------------
	#define STAR_TYPE 1 // [0 1 2]

	#define MOON_TEXTURE
  //#define SKYBOX_TEXTURE
  //#define BILINEAR_MOON_TEXTURE
  //#define BILINEAR_SKYBOX_TEXTURE

  	#define SKY_TEXTURE_BRIGHTNESS	1.0 // [0.0 0.05 0.1 0.15 0.2 0.3 0.5 0.7 1.0 1.5 2.0 3.0 5.0 7.0 10.0 15.0 20.0 30.0 50.0 70.0 100.0]

//End Sky-------------------------------
  //#define END_MANUAL_PLANET_CYCLE
	#define END_PLANET_CYCLE 		15.0 // [0.25 0.5 0.75 1.0 1.5 2.0 3.0 5.0 7.5 10.0 15.0 20.0 30.0 60.0]
	#define END_MANUAL_PLANET_ANGLE 0.0  // [0.0 1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0 9.0 10.0 11.0 12.0 13.0 14.0 15.0 16.0 17.0 18.0 19.0 20.0 21.0 22.0 23.0 24.0 25.0 26.0 27.0 28.0 29.0 30.0 31.0 32.0 33.0 34.0 35.0 36.0 37.0 38.0 39.0 40.0 41.0 42.0 43.0 44.0 45.0 46.0 47.0 48.0 49.0 50.0 51.0 52.0 53.0 54.0 55.0 56.0 57.0 58.0 59.0 60.0 61.0 62.0 63.0 64.0 65.0 66.0 67.0 68.0 69.0 70.0 71.0 72.0 73.0 74.0 75.0 76.0 77.0 78.0 79.0 80.0 81.0 82.0 83.0 84.0 85.0 86.0 87.0 88.0 89.0 90.0 91.0 92.0 93.0 94.0 95.0 96.0 97.0 98.0 99.0 100.0 101.0 102.0 103.0 104.0 105.0 106.0 107.0 108.0 109.0 110.0 111.0 112.0 113.0 114.0 115.0 116.0 117.0 118.0 119.0 120.0 121.0 122.0 123.0 124.0 125.0 126.0 127.0 128.0 129.0 130.0 131.0 132.0 133.0 134.0 135.0 136.0 137.0 138.0 139.0 140.0 141.0 142.0 143.0 144.0 145.0 146.0 147.0 148.0 149.0 150.0 151.0 152.0 153.0 154.0 155.0 156.0 157.0 158.0 159.0 160.0 161.0 162.0 163.0 164.0 165.0 166.0 167.0 168.0 169.0 170.0 171.0 172.0 173.0 174.0 175.0 176.0 177.0 178.0 179.0 180.0 181.0 182.0 183.0 184.0 185.0 186.0 187.0 188.0 189.0 190.0 191.0 192.0 193.0 194.0 195.0 196.0 197.0 198.0 199.0 200.0 201.0 202.0 203.0 204.0 205.0 206.0 207.0 208.0 209.0 210.0 211.0 212.0 213.0 214.0 215.0 216.0 217.0 218.0 219.0 220.0 221.0 222.0 223.0 224.0 225.0 226.0 227.0 228.0 229.0 230.0 231.0 232.0 233.0 234.0 235.0 236.0 237.0 238.0 239.0 240.0 241.0 242.0 243.0 244.0 245.0 246.0 247.0 248.0 249.0 250.0 251.0 252.0 253.0 254.0 255.0 256.0 257.0 258.0 259.0 260.0 261.0 262.0 263.0 264.0 265.0 266.0 267.0 268.0 269.0 270.0 271.0 272.0 273.0 274.0 275.0 276.0 277.0 278.0 279.0 280.0 281.0 282.0 283.0 284.0 285.0 286.0 287.0 288.0 289.0 290.0 291.0 292.0 293.0 294.0 295.0 296.0 297.0 298.0 299.0 300.0 301.0 302.0 303.0 304.0 305.0 306.0 307.0 308.0 309.0 310.0 311.0 312.0 313.0 314.0 315.0 316.0 317.0 318.0 319.0 320.0 321.0 322.0 323.0 324.0 325.0 326.0 327.0 328.0 329.0 330.0 331.0 332.0 333.0 334.0 335.0 336.0 337.0 338.0 339.0 340.0 341.0 342.0 343.0 344.0 345.0 346.0 347.0 348.0 349.0 350.0 351.0 352.0 353.0 354.0 355.0 356.0 357.0 358.0 359.0]

  //#define ACCRETIONDISC_DETAIL_ALONG_LONGTITUDE
	#define ACCRETIONDISC_DOPPLER_EFFECT

//Texture Misc--------------------------
	#define ENTITIES_STATUS_COLOR
	#define EYES_LIGHTING

	#define ENTITIES_VS_TBN
  //#define TERRAIN_VS_TBN

	#define HAND_FOV_MODE 	0 //[0 1 2]
	#define HAND_FOV 		70.0 //  [30.0 31.0 32.0 33.0 34.0 35.0 36.0 37.0 38.0 39.0 40.0 41.0 42.0 43.0 44.0 45.0 46.0 47.0 48.0 49.0 50.0 51.0 52.0 53.0 54.0 55.0 56.0 57.0 58.0 59.0 60.0 61.0 62.0 63.0 64.0 65.0 66.0 67.0 68.0 69.0 70.0 71.0 72.0 73.0 74.0 75.0 76.0 77.0 78.0 79.0 80.0 81.0 82.0 83.0 84.0 85.0 86.0 87.0 88.0 89.0 90.0 91.0 92.0 93.0 94.0 95.0 96.0 97.0 98.0 99.0 100.0 101.0 102.0 103.0 104.0 105.0 106.0 107.0 108.0 109.0 110.0 111.0 112.0 113.0 114.0 115.0 116.0 117.0 118.0 119.0 120.0]

 	#define CORRECT_PARTICLE_NORMAL
 
  //#define GENERAL_GRASS_FIX
  
	#define WAVING_PLANTS
  //#define SHADOW_WAVING_PLANTS
  	#define ANIMATION_SPEED 1.0

  //#define LINE_IMAGE_OUTPUT
	#define SELECTION_BOX_COLOR_R 0.2 // [0.0 0.05 0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95 1.0]
	#define SELECTION_BOX_COLOR_G 0.2 // [0.0 0.05 0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95 1.0]
	#define SELECTION_BOX_COLOR_B 0.2 // [0.0 0.05 0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95 1.0]





//Sky & Volumetric----------------------
  //#define INDOOR_FOG

	#define ATMO_MIN_ALTITUDE 500.0
	#define ATMO_SKYBOX_MIN_ALTITUDE 500.0 - wetness * 300.0

//Planar Clouds-------------------------
	#define PLANAR_CLOUDS
	#define PC_COVERAGE 	0.5 // [0.3 0.32 0.34 0.36 0.38 0.4 0.42 0.44 0.46 0.48 0.5 0.52 0.54 0.56 0.58 0.6 0.62 0.64 0.66 0.68 0.7 0.72 0.74 0.76 0.78 0.8 0.82 0.84 0.86 0.88 0.9]
	#define PC_NOISE_SCALE 	0.025 // [0.01 0.015 0.02 0.025 0.03 0.035 0.04 0.045 0.5]
	#define PC_ALTITUDE 	6000.0 // [2000.0 2500.0 3000.0 3500.0 4000.0 5000.0 6000.0 7000.0 8000.0 9000.0 10000.0]

//Volumtric Clouds----------------------
	#define VOLUMETRIC_CLOUDS
	#define CLOUD_QUALITY 					1.0 	// [0.4 0.6 0.8 1.0 1.2 1.4 1.6 1.8 2.0 2.5 3.0 5.0 7.0 10.0]

	#define CLOUD_CLEAR_ALTITUDE 			500.0 	// [300.0 350.0 400.0 450.0 500.0 550.0 600.0 650.0 700.0 750.0 800.0 850.0 900.0 950.0 1000.0 1100.0 1200.0 1300.0 1400.0 1500.0 1600.0 1700.0 1800.0 1900.0 2000.0 2250.0 2500.0 2750.0 3000.0 4000.0 5000.0]
	#define CLOUD_CLEAR_THICKNESS 			500.0 	// [100.0 150.0 200.0 250.0 300.0 350.0 400.0 450.0 500.0 550.0 600.0 650.0 700.0 750.0 800.0 850.0 900.0 950.0 1000.0 1100.0 1200.0 1300.0 1400.0 1500.0 1600.0 1700.0 1800.0 1900.0 2000.0 2250.0 2500.0 2750.0 3000.0 4000.0 5000.0]
	#define CLOUD_CLEAR_COVERY 				0.28 	// [0.1 0.12 0.14 0.16 0.18 0.2 0.22 0.24 0.26 0.28 0.3 0.32 0.34 0.36 0.38 0.4 0.42 0.44 0.46 0.48 0.5 0.52 0.54 0.56 0.58 0.6 0.62 0.64 0.66 0.68 0.7 0.72 0.74 0.76 0.78 0.8 0.82 0.84 0.86 0.88 0.9 0.92 0.94 0.96 0.98 1.0 1.1 1.2 1.3 1.4 1.5]
	#define CLOUD_CLEAR_DENSITY 			1.0 	// [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2.5 3.0 5.0]
	#define CLOUD_CLEAR_SUNLIGHTING			1.0		// [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2.5 3.0 5.0]
	#define CLOUD_CLEAR_SKYLIGHTING			1.0		// [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2.5 3.0 5.0]
	#define CLOUD_CLEAR_SCALE 				1.0 	// [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2.5 3.0 5.0]

	#define CLOUD_RAIN_ALTITUDE 			500.0 	// [300.0 350.0 400.0 450.0 500.0 550.0 600.0 650.0 700.0 750.0 800.0 850.0 900.0 950.0 1000.0 1100.0 1200.0 1300.0 1400.0 1500.0 1600.0 1700.0 1800.0 1900.0 2000.0 2250.0 2500.0 2750.0 3000.0 4000.0 5000.0]
	#define CLOUD_RAIN_THICKNESS 			800.0 	// [100.0 150.0 200.0 250.0 300.0 350.0 400.0 450.0 500.0 550.0 600.0 650.0 700.0 750.0 800.0 850.0 900.0 950.0 1000.0 1100.0 1200.0 1300.0 1400.0 1500.0 1600.0 1700.0 1800.0 1900.0 2000.0 2250.0 2500.0 2750.0 3000.0 4000.0 5000.0]
	#define CLOUD_RAIN_COVERY 				0.96 	// [0.1 0.12 0.14 0.16 0.18 0.2 0.22 0.24 0.26 0.28 0.3 0.32 0.34 0.36 0.38 0.4 0.42 0.44 0.46 0.48 0.5 0.52 0.54 0.56 0.58 0.6 0.62 0.64 0.66 0.68 0.7 0.72 0.74 0.76 0.78 0.8 0.82 0.84 0.86 0.88 0.9 0.92 0.94 0.96 0.98 1.0 1.1 1.2 1.3 1.4 1.5]
	#define CLOUD_RAIN_DENSITY 				1.0 	// [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2.5 3.0 5.0]
	#define CLOUD_RAIN_SUNLIGHTING			0.4 	// [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2.5 3.0 5.0]
	#define CLOUD_RAIN_SKYLIGHTING			0.8		// [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2.5 3.0 5.0]
	#define CLOUD_RAIN_SCALE 				1.0 	// [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2.5 3.0 5.0]

	#define CLOUD_DETAILED_NOISE_STRENGTH 	1.0 	// [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2.5 3.0 3.5 4.0]
	#define CLOUD_BASE_NOISE_SCALE 			0.0007 	// [0.0001 0.00015 0.0002 0.00025 0.0003 0.00035 0.0004 0.00045 0.0005 0.00055 0.0006 0.00065 0.0007 0.00075 0.0008 0.00085 0.0009 0.00095 0.001 0.0011 0.0012 0.0012 0.0014 0.0015 0.0016 0.0017 0.0018 0.0019 0.002]
	#define CLOUD_DETAILED_NOISE_SCALE 		0.007 	// [0.001 0.002 0.003 0.004 0.005 0.006 0.007 0.008 0.009 0.01 0.011 0.012 0.013 0.014 0.015 0.016 0.017 0.018 0.019 0.02]
	#define CLOUD_BOTTOM_BRIGHTNESS 		0.15 	// [0.01 0.02 0.03 0.05 0.07 0.1 0.15 0.2 0.3 0.5 0.7 1.0]
	#define CLOUD_OUTSCATTER_FACTOR 		1.3 	// [0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
	#define CLOUD_COVERAGE_NOISE_OFFSET 	0.68 	// [0.0 0.01 0.02 0.03 0.04 0.05 0.06 0.07 0.08 0.09 0.1 0.11 0.12 0.13 0.14 0.15 0.16 0.17 0.18 0.19 0.2 0.21 0.22 0.23 0.24 0.25 0.26 0.27 0.28 0.29 0.3 0.31 0.32 0.33 0.34 0.35 0.36 0.37 0.38 0.39 0.4 0.41 0.42 0.43 0.44 0.45 0.46 0.47 0.48 0.49 0.5 0.51 0.52 0.53 0.54 0.55 0.56 0.57 0.58 0.59 0.6 0.61 0.62 0.63 0.64 0.65 0.66 0.67 0.68 0.69 0.7 0.71 0.72 0.73 0.74 0.75 0.76 0.77 0.78 0.79 0.8 0.81 0.82 0.83 0.84 0.85 0.86 0.87 0.88 0.89 0.9 0.91 0.92 0.93 0.94 0.95 0.96 0.97 0.98 0.99]


	#define CLOUD_FADE

	#define CLOUD_SPEED 			1.0 	// [0.0 0.25 0.5 0.75 1.0 1.5 2.0 3.0 4.0 5.0 7.5 10.0 15.0 20.0 30.0 40.0 50.0 75.0 100.0]
	#define FTC_OFFSET 				0 		// [0 5 10 15 20 25 30 35 40 45 50 55 60 65 70 75 80 85 90 95 100 105 110 115 120 125 130 135 140 145 150 155 160 165 170 175 180 185 190 195 200 205 210 215 220 225 230 235 240 245 250 255 260 265 270 275 280 285 290 295 300 305 310 315 320 325 330 335 340 345 350 355]

	#define CLOUD_SHADOW
	#define CLOUD_SHADOW_FADE
	#define CLOUD_SHADOW_RANGE 		4096.0 	// [2048.0 3072.0 4096.0 6144.0 8192.0 12288.0 16384.0]
	#define CLOUD_SHADOWTEX_SIZE 	256.0 	// [128.0 192.0 256.0 384.0 512.0 768.0 1024.0]

//Volumetric Fog------------------------
	#define VFOG
	#define VFOG_NOISE_TYPE 	0 //[0 1]
	#define VFOG_QUALITY 		6 //[4 6 8 10 12 14 16 18 20 22 24 28 32 48 64 128]

	#define VFOG_DENSITY 		0.01 // [0.001 0.0015 0.002 0.003 0.005 0.007 0.01 0.015 0.02 0.03 0.05 0.07 0.1 0.15 0.2 0.3 0.5 0.7 1.0]
	#define VFOG_DENSITY_BASE 	1.0 // [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.2 1.4 1.6 1.8 2.0 3.0 5.0 7.0 10.0 15.0 20.0 30.0 50.0 70.0 100.0]

	#define VFOG_HEIGHT 		65.0 // [-100.0 -90.0 -80.0 -70.0 -60.0 -50.0 -40.0 -30.0 -20.0 -10.0 0.0 10.0 20.0 30.0 40.0 45.0 50.0 55.0 60.0 65.0 70.0 75.0 80.0 85.0 90.0 95.0 100.0 105.0 110.0 115.0 120.0 125.0 130.0 135.0 140.0 145.0 150.0 155.0 160.0 165.0 170.0 175.0 180.0 185.0 190.0 195.0 200.0 210.0 220.0 230.0 240.0 250.0 260.0 270.0 280.0 290.0 300.0 310.0 320.0 350.0 400.0 450.0 500.0 600.0 700.0 800.0 900.0 1000.0]
	#define VFOG_HEIGHT_2 		50.0 // [-100.0 -90.0 -80.0 -70.0 -60.0 -50.0 -40.0 -30.0 -20.0 -10.0 0.0 10.0 20.0 30.0 40.0 45.0 50.0 55.0 60.0 65.0 70.0 75.0 80.0 85.0 90.0 95.0 100.0 105.0 110.0 115.0 120.0 125.0 130.0 135.0 140.0 145.0 150.0 155.0 160.0 165.0 170.0 175.0 180.0 185.0 190.0 195.0 200.0 210.0 220.0 230.0 240.0 250.0 260.0 270.0 280.0 290.0 300.0 310.0 320.0 350.0 400.0 450.0 500.0 600.0 700.0 800.0 900.0 1000.0]
	#define VFOG_FALLOFF 		40.0 //[1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0 9.0 10.0 11.0 12.0 13.0 14.0 15.0 16.0 17.0 18.0 19.0 20.0 21.0 22.0 23.0 24.0 25.0 26.0 27.0 28.0 29.0 30.0 31.0 32.0 33.0 34.0 35.0 36.0 37.0 38.0 39.0 40.0 41.0 42.0 43.0 44.0 45.0 46.0 47.0 48.0 49.0 50.0 51.0 52.0 53.0 54.0 55.0 56.0 57.0 58.0 59.0 60.0 61.0 62.0 63.0 64.0 65.0 66.0 67.0 68.0 69.0 70.0 71.0 72.0 73.0 74.0 75.0 76.0 77.0 78.0 79.0 80.0 81.0 82.0 83.0 84.0 85.0 86.0 87.0 88.0 89.0 90.0 91.0 92.0 93.0 94.0 95.0 96.0 97.0 98.0 99.0 100.0]

  //#define VFOG_IGNORE_WORLDTIME
  //#define VFOG_STAINED
  //#define VFOG_CLOUD_SHADOW

	#define VFOG_SUNLIGHT_DENSITY 		1.0 // [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.2 1.4 1.6 1.8 2.0 3.0 5.0 7.0 10.0 15.0 20.0 30.0 50.0 70.0 100.0]
	#define VFOG_FOG_DENSITY 			1.0 // [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.2 1.4 1.6 1.8 2.0 3.0 5.0 7.0 10.0 15.0 20.0 30.0 50.0 70.0 100.0]

	#define VFOG_VOLUMETRIC_LIGHTING
	#define VFOG_SUNLIGHT_ABSORPTION 	1.0 // [0.1 0.15 0.2 0.3 0.5 0.7 1.0 1.5 2.0 3.0 5.0 7.0 10.0]
	#define VFOG_SUNLIGHT_STEPS 		4
	#define VFOG_SUNLIGHT_STEPLENGTH 	5.0

	#define VFOG_BLOOM

	#define UNDERWATER_VFOG
	#define UNDERWATER_VFOG_DENSITY 1.0 // [0.1 0.15 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.2 1.4 1.6 1.8 2.0 3.0 5.0 7.0 10.0 15.0 20.0 30.0 50.0 70.0 100.0]

//Land Scattering-----------------------
	#define LANDSCATTERING
	#define LANDSCATTERING_DISTANCE		0.003 // [0.001 0.002 0.003 0.005 0.007 0.01 0.15 0.2 0.3 0.5 0.7 1.0]
	#define LANDSCATTERING_STRENGTH     2.0 // [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.5 1.7 2.0 2.5 3.0 5.0 7.0 10.0 15.0 20.0 30.0 50.0 100.0]
  //#define LANDSCATTERING_SHADOW
	#define LANDSCATTERING_SHADOW_QUALITY 6 // [4 6 8 10 12 14 16 18 20 22 24 28 32 48 64 128]

//Sky Misc------------------------------
	#define UNDERWATER_FOG
	#define WATERFOG_DENSITY        1.0 // [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]

	#define NETHERFOG_DENSITY  1.0 // [0.0 0.1 0.15 0.2 0.3 0.5 0.7 1.0 1.5 2.0 3.0 5.0 7.0 10.0 15.0 20.0 30.0 50.0 70.0 100.0]

  //#define ATMO_HORIZON
	#define ATMO_REFLECTION_HORIZON





//TAA-----------------------------------
	#define TAA
	#define TAA_BLENDWEIGHT 	0.97 // [0.9 0.91 0.92 0.93 0.94 0.95 0.96 0.97 0.98 0.99]
	#define TAA_AGGRESSION 		2.0 // [1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2.1 2.2 2.3 2.4 2.5 2.6 2.7 2.8 2.9 3.0 3.5 4.0 4.5 5.0 6.0 7.0 8.0 9.0 10.0]
  //#define TAA_BICUBIC_CURRENT
	#define TAA_BICUBIC_PREVIOUS
	#define TAA_CLOSEST_DEPTH
  //#define TAA_CLIP_TO_CENTER
	#define TAA_DEPTH_COMPARE
	#define TAA_DEPTH_COMPARE_THRESHOLD 0.0007 // [0.00002 0.00003 0.00005 0.00007 0.0001 0.00015 0.0002 0.0003 0.0005 0.0007 0.001 0.0015 0.002 0.003 0.005 0.007 0.01 0.015 0.02 0.03 0.05 0.07 0.1]
	#define TAA_MICRO_BLUR

//DOF-----------------------------------
  //#define DOF

	#define DOF_QUALITY 				10 // [5 7 10 15 20 30 50 70 100]
	#define DOF_COCSPREAD_QUALITY 		10 // [5 7 10 15 20 30 50 70 100]
	#define DOF_BLUR 					0.01 // [0.001 0.0015 0.002 0.003 0.005 0.007 0.01 0.015 0.02 0.03 0.05 0.07 0.1 0.15 0.2 0.3 0.5 0.7 1.0 1.5 2.0 3.0 5.0]
	#define DOF_MAX_COC 				0.02 // [0.001 0.0015 0.002 0.003 0.005 0.007 0.01 0.015 0.02 0.03 0.05 0.07 0.1 0.15 0.2 0.3 0.5]

	#define CAMERA_FOCUS_MODE 			0 // [0 1]
	#define CAMERA_FOCAL_POINT 			10.0 // [0.2 0.3 0.4 0.6 0.8 1.0 1.25 1.5 1.75 2.0 2.5 3.0 3.5 4.0 5.0 6.0 8.0 10.0 12.5 15.0 17.5 20.0 15.0 30.0 40.0 50.0 60.0 80.0 100.0 150.0 200.0 250.0 300.0 400.0 500.0 600.0 800.0 1000.0]

  //#define DOF_CATSEYE
	#define DOF_CATSEYE_STRENGTH 		0.5 // [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
	#define DOF_CATSEYE_MIDPOINT 		0.3 // [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]

	#define DOF_DEPTH_SMMOOTH_HALFLIFE 	1.0 // [0.1 0.15 0.2 0.3 0.5 0.7 1.0 1.5 2.0 3.0 5.0 7.0 10.0]
	#define DOF_FOCUS_IGNORE_HAND_PARTICLE

//Exposure------------------------------
  //#define MANUAL_EXPOSURE
	#define EV_VALUE 	14.0 	// [0.0 0.33 0.67 1.0 1.33 1.67 2.0 2.33 2.67 3.0 3.33 3.67 4.0 4.33 4.67 5.0 5.33 5.67 6.0 6.33 6.67 7.0 7.33 7.67 8.0 8.33 8.67 9.0 9.33 9.67 10.0 10.33 10.67 11.0 11.33 11.67 12.0 12.33 12.67 13.0 13.33 13.67 14.0 14.33 14.67 15.0 15.33 15.67 16.0 16.33 16.67 17.0 17.33 17.67 18.0 18.33 18.67 19.0 19.33 19.67 20.0]
	#define AE_OFFSET 	0.0 	// [-5.0 -4.67 -4.33 -4.0 -3.67 -3.33 -3.0 -2.67 -2.33 -2.0 -1.67 -1.33 -1.0 -0.67 -0.33 0.0 0.33 0.67 1.0 1.33 1.67 2.0 2.33 2.67 3.0 3.33 3.67 4.0 4.33 4.67 5.0]
	#define AE_MODE 	0 		// [0 1 2 3]
	#define AE_CURVE 	0.7 	// [0.0 0.05 0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.525 0.55 0.575 0.6 0.625 0.65 0.675 0.7 0.725 0.75 0.775 0.8 0.85 0.9 0.95 1.0]
	#define AE_CLAMP
	#define LUMINANCE_WEIGHT_MODE 		1 	// [0 1 2 3 4]
	#define LUMINANCE_WEIGHT_STRENGTH 	0.7 // [0.5 0.7 1.0 1.5 2.0]

	#define SMOOTH_EXPOSURE
	#define EXPOSURE_TIME 	1.0 // [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.2 1.4 1.6 1.8 2.0]

//Motion Blur---------------------------
	#define MOTION_BLUR
	#define MOTION_BLUR_DITHER
	#define MOTION_BLUR_QUALITY 		3 // [2 3 5 10 20 30 50 100]
	#define MOTION_BLUR_SUTTER_ANGLE 	135.0 // [45.0 90.0 135.0 180.0 270.0 360.0]

//Vignette------------------------------
	#define VIGNETTE
	#define VIGNETTE_FALLOFF    0.4 // [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
	#define VIGNETTE_ROUNDNESS  0.0 // [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]
  //#define SNEAKING_VIGNETTE

//Bloom---------------------------------
	#define BLOOM
	#define BLOOM_AMOUNT 		0.13 // [0.01 0.02 0.03 0.04 0.05 0.06 0.07 0.08 0.09 0.1 0.11 0.12 0.13 0.14 0.15 0.16 0.17 0.18 0.19 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.6 0.7 0.8 0.9 1.0]
	#define NETHER_END_BLOOM_BOOST 	1.0 // [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]

	#define LENS_GLARE
  //#define LENS_FLARE
	#define GLARE_BRIGHTNESS 	1.0 // [0.1 0.2 0.3 0.5 0.7 1.0 1.5 2.0 3.0 5.0 7.0 10.0 15.0 20.0]
	#define FLARE_BRIGHTNESS 	1.0 // [0.1 0.2 0.3 0.5 0.7 1.0 1.5 2.0 3.0 5.0 7.0 10.0 15.0 20.0]
  //#define GLARE_FLARE_SHADOWBASED

//Color---------------------------------
	#define TONEMAP_OPERATOR AgX // [AgX ACES None]

	#define AGX_EV 				13.0 // [8.0 8.5 9.0 9.5 10.0 10.5 11.0 11.5 12.0 12.5 13.0 13.5 14.0 14.5 15.0 15.5 16.0 16.5 17.0 17.5 18.0 24.0 32.0]

	#define ABNEY_EFFECT_CORRECTION

  //#define ADVANCED_COLOR
	#define GAMMA 				1.0 // [0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95 1.0 1.05 1.1 1.15 1.2 1.25 1.3 1.35 1.4 1.45 1.5]
	#define LUMA_GAMMA 			1.0 // [0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95 1.0 1.05 1.1 1.15 1.2 1.25 1.3 1.35 1.4 1.45 1.5]
	#define SATURATION 			1.0 // [0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5]
	#define WHITE_CLIP 			0.0 // [0.0 0.05 0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5]

//FidelityFx----------------------------
	#define CAS_SHARPNESS 		2 //[0 1 2 3 4 5 6 7 8 9 10]
	#define CAS_DENOISE

  //#define FSR
	#define FSR_SHARPNESS 		5 //[1 2 3 4 5 6 7 8 9 10]
	#define FSR_DENOISE

//Post Misc-----------------------------
	#define SEREEN_RATIO 				0.0 // [0.0 1.333333 1.435052 1.5 1.6 1.777778 2.0 2.333333 2.39]

  //#define PURKINJE_EFFECT
	#define PURKINJE_EFFECT_THRESHOLD 	0.00003 // [0.00001 0.000015 0.00002 0.00003 0.00005 0.00007 0.0001 0.00015 0.0002 0.0003 0.0005 0.0007 0.001]
	#define PURKINJE_EFFECT_STRENGTH 	0.7 	// [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]





//Distant Horizons----------------------
  //#define DH_SHADOW
	#define DH_TEXTURE_NOISE
	#define DH_TEXTURE_NOISE_STEPS 		4.0 // [2.0 4.0 8.0 16.0 32.0]
	#define DH_TEXTURE_NOISE_STRENGTH 	0.07 // [0.01 0.015 0.02 0.03 0.05 0.07 0.1 0.15 0.2 0.3 0.5 0.7 1.0]

	#define DH_TERRAIN_CULLING
	#define DH_SHADOW_CULLING
	#define DH_SHADOW_FIX

	#define DH_LIMIT_VFOG_DIST

//TACZ----------------------------------
  //#define DISABLE_HAND_TAA
  //#define DISABLE_HAND_GI
  //#define DISABLE_HAND_GI_VELOCITY
  //#define DISABLE_HAND_SPECULAR

//YSM-----------------------------------
  //#define DISABLE_PLAYER_TAA_MOTION_BLUR
  //#define DISABLE_PLAYER_GI
  //#define DISABLE_PLAYER_GI_VELOCITY
  //#define DISABLE_PLAYER_SPECULAR
  //#define DISABLE_PLAYER_SCREEN_SPACE_SHADOWS


//Misc----------------------------------
	#define TITLE
  //#define CAVE_MODE

	#define MAIN_OUTPUT_FACTOR 2048.0
	#define EXPOSURE_OUTPUT_FACTOR 128.0





//DEBUG---------------------------------
  //#define WHITE_DEBUG_WORLD
  //#define DEBUG_COUNTER
  //#define DISABLE_NIGHTVISION
  //#define DISABLE_BLINDNESS_DARKNESS
  //#define SODIUM_TEMPFIX

