/*
 * Decompiled with CFR 0.152.
 */
package com.yukami.backpacktab.client.tabs;

import com.mojang.authlib.GameProfile;
import com.yukami.backpacktab.client.tabs.InventoryTab;
import com.yukami.backpacktab.client.util.CarriedItemUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundContainerClosePacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class PlayerTab
implements InventoryTab {
    private boolean active = false;

    @Override
    public ItemStack getTabIcon() {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player == null) {
            return ItemStack.EMPTY;
        }
        ItemStack playerHead = new ItemStack((ItemLike)Items.PLAYER_HEAD);
        GameProfile gameProfile = player.getGameProfile();
        if (gameProfile.getId() != null) {
            ResolvableProfile profile = new ResolvableProfile(gameProfile);
            playerHead.set(DataComponents.PROFILE, (Object)profile);
        }
        return playerHead;
    }

    @Override
    public Component getHoverText() {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player == null) {
            return Component.literal((String)"Player");
        }
        return Component.literal((String)player.getName().getString());
    }

    @Override
    public void open(Player player, Level world, AbstractContainerMenu handler, MultiPlayerGameMode gameMode) {
        if (player == null || gameMode == null || !(player instanceof LocalPlayer)) {
            return;
        }
        LocalPlayer localPlayer = (LocalPlayer)player;
        CarriedItemUtil.stashCarriedItem(localPlayer, gameMode, handler);
        if (handler != null && !(handler instanceof InventoryMenu) && localPlayer.connection != null) {
            localPlayer.connection.send((Packet)new ServerboundContainerClosePacket(handler.containerId));
        }
        if (gameMode.getPlayerMode() == GameType.SURVIVAL || gameMode.getPlayerMode() == GameType.ADVENTURE) {
            Minecraft.getInstance().setScreen((Screen)new InventoryScreen((Player)localPlayer));
        }
    }

    @Override
    public void close(Player player, Level world, AbstractContainerMenu handler, MultiPlayerGameMode gameMode) {
    }

    @Override
    public boolean matchesCurrentScreen(AbstractContainerScreen<?> screen) {
        return screen instanceof InventoryScreen;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public boolean isInstant() {
        return true;
    }
}

