/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.networking;

import com.b1n_ry.yigd.data.GraveStatus;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public record LightGraveData(int itemCount, BlockPos pos, int xpPoints, ResourceKey<Level> registryKey, Component deathMessage, UUID id, GraveStatus status) {
    public static LightGraveData fromNbt(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        if (nbt == null) {
            return new LightGraveData(0, BlockPos.ZERO, 0, (ResourceKey<Level>)Level.OVERWORLD, (Component)Component.empty(), UUID.randomUUID(), GraveStatus.CLAIMED);
        }
        int itemCount = nbt.getInt("itemCount");
        BlockPos pos = NbtUtils.readBlockPos((CompoundTag)nbt, (String)"pos").orElse(BlockPos.ZERO);
        int xpPoints = nbt.getInt("xpPoints");
        ResourceKey<Level> registryKey = LightGraveData.getRegistryKeyFromNbt(nbt.getCompound("worldKey"));
        MutableComponent deathMessage = Component.Serializer.fromJson((String)nbt.getString("deathMessage"), (HolderLookup.Provider)registryLookup);
        UUID id = nbt.getUUID("id");
        GraveStatus status = GraveStatus.valueOf(nbt.getString("status"));
        return new LightGraveData(itemCount, pos, xpPoints, registryKey, (Component)deathMessage, id, status);
    }

    public CompoundTag toNbt(HolderLookup.Provider registryLookup) {
        CompoundTag nbt = new CompoundTag();
        nbt.putInt("itemCount", this.itemCount);
        nbt.put("pos", NbtUtils.writeBlockPos((BlockPos)this.pos));
        nbt.putInt("xpPoints", this.xpPoints);
        nbt.put("worldKey", (Tag)this.getWorldRegistryKeyNbt(this.registryKey));
        nbt.putString("deathMessage", Component.Serializer.toJson((Component)this.deathMessage, (HolderLookup.Provider)registryLookup));
        nbt.putUUID("id", this.id);
        nbt.putString("status", this.status.toString());
        return nbt;
    }

    private CompoundTag getWorldRegistryKeyNbt(ResourceKey<?> key) {
        CompoundTag nbt = new CompoundTag();
        nbt.putString("registry", key.registry().toString());
        nbt.putString("value", key.location().toString());
        return nbt;
    }

    private static ResourceKey<Level> getRegistryKeyFromNbt(CompoundTag nbt) {
        String registry = nbt.getString("registry");
        String value = nbt.getString("value");
        ResourceKey r = ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.parse((String)registry));
        return ResourceKey.create((ResourceKey)r, (ResourceLocation)ResourceLocation.parse((String)value));
    }
}

