/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.data;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class GraveyardData {
    @SerializedName(value="point2point")
    public boolean point2point = false;
    @SerializedName(value="dimension")
    public ResourceLocation dimensionId = ResourceLocation.withDefaultNamespace((String)"overworld");
    @SerializedName(value="use_closest")
    public boolean useClosest = false;
    @SerializedName(value="coordinates")
    public List<GraveLocation> graveLocations = new ArrayList<GraveLocation>();

    public void handlePoint2Point() {
        if (!this.point2point || this.graveLocations.size() != 2) {
            return;
        }
        GraveLocation first = this.graveLocations.get(0);
        GraveLocation second = this.graveLocations.get(1);
        int minX = Math.min(first.x, second.x);
        int minY = Math.min(first.y, second.y);
        int minZ = Math.min(first.z, second.z);
        int maxX = Math.max(first.x, second.x);
        int maxY = Math.max(first.y, second.y);
        int maxZ = Math.max(first.z, second.z);
        this.graveLocations.clear();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    this.graveLocations.add(new GraveLocation(x, y, z));
                }
            }
        }
    }

    public static class GraveLocation {
        @SerializedName(value="x")
        public int x;
        @SerializedName(value="y")
        public int y;
        @SerializedName(value="z")
        public int z;
        @SerializedName(value="for_player")
        @Nullable
        public String forPlayer = null;
        @SerializedName(value="direction")
        @Nullable
        public Direction direction = null;

        public GraveLocation(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

