/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.client.gui;

import com.b1n_ry.yigd.networking.LightPlayerData;
import com.b1n_ry.yigd.networking.packets.GraveSelectionRequestC2SPacket;
import com.b1n_ry.yigd.networking.packets.PlayerSelectionS2CPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class PlayerSelectionScreen
extends Screen {
    private static final ResourceLocation WINDOW_BG = ResourceLocation.fromNamespaceAndPath((String)"yigd", (String)"window_bg");
    private static final ResourceLocation SLOT = ResourceLocation.fromNamespaceAndPath((String)"yigd", (String)"slot");
    private static final ResourceLocation SCROLL_BAR = ResourceLocation.fromNamespaceAndPath((String)"yigd", (String)"scroll_bar");
    private static final ResourceLocation SCROLL_BAR_PRESSED = ResourceLocation.fromNamespaceAndPath((String)"yigd", (String)"scroll_bar_pressed");
    private static final ResourceLocation CLAIMED_GRAVE = ResourceLocation.fromNamespaceAndPath((String)"yigd", (String)"claimed_grave");
    private static final ResourceLocation DESTROYED_GRAVE = ResourceLocation.fromNamespaceAndPath((String)"yigd", (String)"destroyed_grave");
    private static final ResourceLocation UNCLAIMED_GRAVE = ResourceLocation.fromNamespaceAndPath((String)"yigd", (String)"unclaimed_grave");
    private final List<LightPlayerData> data;
    private final Screen previousScreen;
    private FilterButtonValue activeFilter = FilterButtonValue.WITH_GRAVES;
    private final EditBox searchBox = new EditBox(FONT, 185, 20, (Component)Component.empty());
    private final Button changeViewButton = Button.builder((Component)Component.empty(), btn -> {
        this.activeFilter = FilterButtonValue.values()[(this.activeFilter.ordinal() + 1) % FilterButtonValue.values().length];
        btn.setTooltip(Tooltip.create((Component)this.getFilterTooltip()));
        this.reloadButtons();
    }).size(20, 20).tooltip(Tooltip.create((Component)this.getFilterTooltip())).build();
    private final List<Tuple<LightPlayerData, Button>> buttons = new ArrayList<Tuple<LightPlayerData, Button>>();
    private ImageWidget scrollBar = ImageWidget.sprite((int)6, (int)128, (ResourceLocation)SCROLL_BAR);
    private double scrollDistance;
    private int scrollContentHeight;
    private boolean scrolling = false;
    private static final int SCREEN_WIDTH = 226;
    private static final int SCREEN_HEIGHT = 187;
    private static final int SCROLL_MENU_HEIGHT = 128;
    private static final Font FONT = Minecraft.getInstance().font;

    public PlayerSelectionScreen(List<LightPlayerData> data, Screen previousScreen) {
        super((Component)Component.translatable((String)"text.yigd.gui.players_on_server"));
        this.data = data;
        this.previousScreen = previousScreen;
    }

    private void reloadButtons() {
        this.scrollDistance = 0.0;
        this.clearWidgets();
        this.buttons.clear();
        this.addWidget((GuiEventListener)this.changeViewButton);
        this.addWidget((GuiEventListener)this.searchBox);
        for (LightPlayerData playerData : this.data) {
            Optional name;
            String searchContent;
            boolean show;
            if (!(show = (switch (this.activeFilter.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    if (playerData.graveCount() > 0) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> {
                    if (playerData.graveCount() - playerData.destroyedCount() - playerData.unclaimedCount() > 0) {
                        yield true;
                    }
                    yield false;
                }
                case 3 -> {
                    if (playerData.destroyedCount() > 0) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> playerData.unclaimedCount() > 0;
            })) || !(searchContent = this.searchBox.getValue()).isEmpty() && ((name = playerData.playerProfile().name()).isEmpty() || !((String)name.get()).toLowerCase(Locale.ROOT).contains(searchContent.toLowerCase(Locale.ROOT)))) continue;
            Button button = Button.builder((Component)Component.empty(), btn -> PacketDistributor.sendToServer((CustomPacketPayload)new GraveSelectionRequestC2SPacket(playerData.playerProfile()), (CustomPacketPayload[])new CustomPacketPayload[0])).size(200, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"text.yigd.gui.unclaimed_count", (Object[])new Object[]{playerData.unclaimedCount()}).append("\n").append((Component)Component.translatable((String)"text.yigd.gui.destroyed_count", (Object[])new Object[]{playerData.destroyedCount()})).append("\n").append((Component)Component.translatable((String)"text.yigd.gui.total_count", (Object[])new Object[]{playerData.graveCount()})))).build();
            this.buttons.add((Tuple<LightPlayerData, Button>)new Tuple((Object)playerData, (Object)button));
            this.addWidget((GuiEventListener)button);
        }
        this.scrollContentHeight = this.buttons.size() * 20;
        float fraction = 128.0f / (float)this.scrollContentHeight;
        this.scrollBar.setHeight(Math.max(4, (int)(Math.min(1.0f, fraction) * 128.0f)));
    }

    private Component getFilterTooltip() {
        return switch (this.activeFilter.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Component.translatable((String)"button.yigd.gui.showing_with_data");
            case 2 -> Component.translatable((String)"button.yigd.gui.showing_with_unclaimed");
            case 1 -> Component.translatable((String)"button.yigd.gui.showing_with_claimed");
            case 3 -> Component.translatable((String)"button.yigd.gui.showing_with_destroyed");
        };
    }

    public void init() {
        this.searchBox.setResponder(s -> this.reloadButtons());
        this.reloadButtons();
        super.init();
    }

    private void setScrollDistance(double scrollDistance) {
        this.scrollDistance = Mth.clamp((double)scrollDistance, (double)0.0, (double)this.getMaxScrollAmount());
    }

    private int getMaxScrollAmount() {
        return Math.max(0, this.scrollContentHeight - 128);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 259 && this.minecraft != null && !this.searchBox.isFocused()) {
            this.minecraft.setScreen(this.previousScreen);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        this.setScrollDistance(this.scrollDistance - scrollY * 9.0);
        return true;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.clearFocus();
        if (this.scrollBar.isMouseOver(mouseX, mouseY)) {
            this.scrollBar = ImageWidget.sprite((int)this.scrollBar.getWidth(), (int)this.scrollBar.getHeight(), (ResourceLocation)SCROLL_BAR_PRESSED);
            this.scrolling = true;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.scrolling) {
            this.scrollBar = ImageWidget.sprite((int)this.scrollBar.getWidth(), (int)this.scrollBar.getHeight(), (ResourceLocation)SCROLL_BAR);
        }
        this.scrolling = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.scrolling) {
            int scrollBarHeight = this.scrollBar.getHeight();
            int holderTop = this.height / 2 - 93 + 8;
            if (mouseY < (double)holderTop) {
                this.setScrollDistance(0.0);
            } else if (mouseY > (double)(this.scrollBar.getY() + 128)) {
                this.setScrollDistance(this.getMaxScrollAmount());
            } else {
                float barMenuRatio = (float)this.getMaxScrollAmount() / (float)(128 - scrollBarHeight);
                this.setScrollDistance(this.scrollDistance + dragY * (double)barMenuRatio);
            }
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        int leftEdge = this.width / 2 - 113;
        int topEdge = this.height / 2 - 93;
        graphics.blitSprite(WINDOW_BG, leftEdge, topEdge, 226, 187);
        graphics.drawString(FONT, this.title, leftEdge + 8, topEdge + 8, 0x404040, false);
        this.searchBox.setPosition(leftEdge + 8, topEdge + 24);
        this.searchBox.render(graphics, mouseX, mouseY, partialTick);
        this.changeViewButton.setPosition(leftEdge + 198, topEdge + 24);
        this.changeViewButton.render(graphics, mouseX, mouseY, partialTick);
        switch (this.activeFilter.ordinal()) {
            case 0: {
                graphics.renderItem(Items.BARRIER.getDefaultInstance(), leftEdge + 200, topEdge + 26);
                break;
            }
            case 2: {
                graphics.blitSprite(CLAIMED_GRAVE, leftEdge + 200, topEdge + 26, 16, 16);
                break;
            }
            case 3: {
                graphics.blitSprite(DESTROYED_GRAVE, leftEdge + 200, topEdge + 26, 16, 16);
                break;
            }
            case 1: {
                graphics.blitSprite(UNCLAIMED_GRAVE, leftEdge + 200, topEdge + 26, 16, 16);
            }
        }
        this.renderScrollbar(graphics, mouseX, mouseY, partialTick, leftEdge + 8, topEdge + 49);
    }

    private void renderScrollbar(GuiGraphics graphics, int mouseX, int mouseY, float partialTick, int x, int y) {
        graphics.blitSprite(SLOT, x, y, 202, 130);
        graphics.blitSprite(SLOT, x + 202, y, 8, 130);
        int movedScrollBar = (int)(this.scrollDistance / (double)this.getMaxScrollAmount() * (double)(128 - this.scrollBar.getHeight()));
        this.scrollBar.setPosition(x + 203, y + 1 + movedScrollBar);
        this.scrollBar.render(graphics, mouseX, mouseY, partialTick);
        graphics.enableScissor(0, y + 1, this.width, y + 128 + 1);
        for (int i = 0; i < this.buttons.size(); ++i) {
            if ((double)((i + 1) * 20) < this.scrollDistance) continue;
            if ((double)(i * 20) - this.scrollDistance > 128.0) break;
            Tuple<LightPlayerData, Button> tuple = this.buttons.get(i);
            LightPlayerData playerData = (LightPlayerData)tuple.getA();
            Button button = (Button)tuple.getB();
            button.setPosition(x + 1, y + 1 + i * 20 - (int)this.scrollDistance);
            button.render(graphics, mouseX, mouseY, partialTick);
            ItemStack stack = Items.PLAYER_HEAD.getDefaultInstance();
            stack.set(DataComponents.PROFILE, (Object)playerData.playerProfile());
            String playerName = playerData.playerProfile().name().orElse("PLAYER_NOT_FOUND");
            graphics.renderItem(stack, x + 3, y + 3 + i * 20 - (int)this.scrollDistance);
            graphics.drawString(FONT, playerName, x + 21, y + 5 + i * 20 - (int)this.scrollDistance, 0xFFFFFF, false);
        }
        graphics.disableScissor();
    }

    public static void openScreen(PlayerSelectionS2CPacket payload) {
        Minecraft client = Minecraft.getInstance();
        client.execute(() -> client.setScreen((Screen)new PlayerSelectionScreen(payload.data(), client.screen)));
    }

    private static enum FilterButtonValue {
        WITH_GRAVES,
        WITH_CLAIMED,
        WITH_UNCLAIMED,
        WITH_DESTROYED;

    }
}

