/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.multiblock.producers;

import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.container.SimpleResourceFluidContainer;
import tv.soaryn.xycraft.core.container.SimpleResourceItemContainer;
import tv.soaryn.xycraft.core.container.resource.IResourceContainer;
import tv.soaryn.xycraft.core.container.resource.MutableResourceStack;
import tv.soaryn.xycraft.core.utils.handlers.HandlerIOBehavior;
import tv.soaryn.xycraft.core.utils.protocontainer.FluidResource;
import tv.soaryn.xycraft.core.utils.protocontainer.IResourceHandler;
import tv.soaryn.xycraft.core.utils.protocontainer.ItemResource;
import tv.soaryn.xycraft.core.utils.resources.FluidUtils;
import tv.soaryn.xycraft.machines.content.multiblock.producers.ProcessorFactories;

public class CentrifugeInventory {
    public static final Codec<CentrifugeInventory> CODEC = ProcessorFactories.Hybrid.producerCodec(CentrifugeInventory::new, data -> data._items, data -> data._fluids, data -> data._fluids.getCapacity(), data -> Optional.ofNullable(data.SelectedRecipe));
    @Nullable
    public ResourceLocation SelectedRecipe;
    private final SimpleResourceItemContainer _items;
    private final SimpleResourceFluidContainer _fluids;
    public final transient IResourceContainer<ItemResource> InputItem;
    public final transient IResourceContainer<ItemResource> OutputItemA;
    public final transient IResourceContainer<ItemResource> OutputItemB;
    public final transient IResourceContainer<FluidResource> InputFluid;
    public final transient IResourceContainer<FluidResource> OutputFluidA;
    public final transient IResourceContainer<FluidResource> OutputFluidB;
    public final transient IResourceHandler<ItemResource> InputItemHandler;
    public final transient IResourceHandler<ItemResource> OutputItemAHandler;
    public final transient IResourceHandler<ItemResource> OutputItemBHandler;
    public final transient IResourceHandler<FluidResource> InputFluidHandler;
    public final transient IResourceHandler<FluidResource> OutputFluidAHandler;
    public final transient IResourceHandler<FluidResource> OutputFluidBHandler;

    public static CentrifugeInventory create() {
        return new CentrifugeInventory((NonNullList<MutableResourceStack<ItemResource>>)MutableResourceStack.Empty.ITEM.nonNullListOfSize(7), (NonNullList<MutableResourceStack<FluidResource>>)MutableResourceStack.Empty.FLUID.nonNullListOfSize(3), FluidUtils.inBuckets((int)4), Optional.empty());
    }

    private CentrifugeInventory(NonNullList<MutableResourceStack<ItemResource>> items, NonNullList<MutableResourceStack<FluidResource>> fluids, int capacity, Optional<ResourceLocation> recipeId) {
        this._items = SimpleResourceItemContainer.from(items, this::onChanged);
        this._fluids = SimpleResourceFluidContainer.from(fluids, (int)capacity, this::onChanged);
        this.SelectedRecipe = recipeId.orElse(null);
        this.InputItem = this._items.slice(0, 1);
        this.OutputItemA = this._items.slice(1, 3);
        this.OutputItemB = this._items.slice(4, 3);
        this.InputFluid = this._fluids.slice(0, 1);
        this.OutputFluidA = this._fluids.slice(1, 1);
        this.OutputFluidB = this._fluids.slice(2, 1);
        this.InputItemHandler = this.InputItem.asHandler(HandlerIOBehavior.INSERT_ONLY);
        this.OutputItemAHandler = this.OutputItemA.asHandler(HandlerIOBehavior.EXTRACT_ONLY);
        this.OutputItemBHandler = this.OutputItemB.asHandler(HandlerIOBehavior.EXTRACT_ONLY);
        this.InputFluidHandler = this.InputFluid.asHandler(HandlerIOBehavior.INSERT_ONLY);
        this.OutputFluidAHandler = this.OutputFluidA.asHandler(HandlerIOBehavior.EXTRACT_ONLY);
        this.OutputFluidBHandler = this.OutputFluidB.asHandler(HandlerIOBehavior.EXTRACT_ONLY);
    }

    public void onChanged() {
    }
}

