/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.items.modular206;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.api.content.XyCraftColors;
import tv.soaryn.xycraft.api.content.capabilities.IColorable;
import tv.soaryn.xycraft.api.content.capabilities.modular.IEnergyConsumer;
import tv.soaryn.xycraft.core.content.attachments.accessors.ModifierKey;
import tv.soaryn.xycraft.core.content.attachments.accessors.PlayerPowerLookup;
import tv.soaryn.xycraft.core.content.attachments.memory.PlayerPowerItemLookupAttachment;
import tv.soaryn.xycraft.core.content.capabilities.ColorableCapability;
import tv.soaryn.xycraft.core.content.capabilities.CoreCapabilities;
import tv.soaryn.xycraft.core.utils.ColorUtils;
import tv.soaryn.xycraft.core.utils.handlers.EnergyHandlerUtils;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.content.items.modular.proto.ITool;
import tv.soaryn.xycraft.machines.content.items.modular206.VariableItem;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;

@EventBusSubscriber(modid="xycraft_machines", bus=EventBusSubscriber.Bus.MOD)
public class FlareRodItem
extends VariableItem
implements ITool {
    public FlareRodItem(Item.Properties properties) {
        super(properties.stacksTo(1).setNoRepair(), EquipmentSlotGroup.HAND);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        InteractionHand otherHand = hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        DyeColor dyeColor = DyeColor.getColor((ItemStack)player.getItemInHand(otherHand));
        IColorable cap = ColorableCapability.of((Entity)player);
        if (!ModifierKey.of((Player)player) || cap == null) {
            return super.use(level, player, hand);
        }
        if (!level.isClientSide()) {
            int color = dyeColor == null ? XyCraftColors.Blue.getColor() : ColorUtils.getColorFromDye((DyeColor)dyeColor);
            cap.setColor(0, color);
        }
        return InteractionResultHolder.sidedSuccess((Object)player.getItemInHand(hand), (boolean)level.isClientSide());
    }

    public void inventoryTick(ItemStack p_41404_, Level p_41405_, Entity p_41406_, int p_41407_, boolean p_41408_) {
        super.inventoryTick(p_41404_, p_41405_, p_41406_, p_41407_, p_41408_);
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return super.useOn(context);
        }
        PlayerPowerItemLookupAttachment lookup = PlayerPowerLookup.of((Player)player);
        lookup.invalidate(player.getInventory());
        IEnergyConsumer cap = (IEnergyConsumer)context.getItemInHand().getCapability(CoreCapabilities.EnergyConsumable.ITEM);
        if (cap == null) {
            return super.useOn(context);
        }
        long energyRequired = player.isCreative() ? 0L : (long)cap.amountRequired(player);
        long lookupResult = lookup.loop(energyRequired, EnergyHandlerUtils::simulateDrain);
        if (lookupResult < energyRequired) {
            return super.useOn(context);
        }
        InteractionResult interactionresult = this.place(new BlockPlaceContext(context));
        if (!interactionresult.consumesAction() && context.getItemInHand().has(DataComponents.FOOD)) {
            InteractionResult result = this.use(context.getLevel(), player, context.getHand()).getResult();
            return result == InteractionResult.CONSUME ? InteractionResult.CONSUME_PARTIAL : result;
        }
        if (interactionresult != InteractionResult.FAIL) {
            lookup.loop(energyRequired, EnergyHandlerUtils::executeDrain);
        }
        return interactionresult;
    }

    protected boolean placeBlock(@NotNull BlockPlaceContext context, BlockState state) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        return context.getLevel().setBlock(context.getClickedPos(), (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER)), 11);
    }

    @NotNull
    public InteractionResult place(@NotNull BlockPlaceContext context) {
        Block flareBlock = MachinesContent.Block.Flare.block();
        if (!(flareBlock.isEnabled(context.getLevel().enabledFeatures()) && context.canPlace() && this.placeBlock(context, flareBlock.defaultBlockState()))) {
            return InteractionResult.FAIL;
        }
        BlockPos blockpos = context.getClickedPos();
        Level level = context.getLevel();
        Player player = context.getPlayer();
        ItemStack itemstack = context.getItemInHand();
        BlockState stateAtPos = level.getBlockState(blockpos);
        if (stateAtPos.is(flareBlock)) {
            stateAtPos.getBlock().setPlacedBy(level, blockpos, stateAtPos, (LivingEntity)player, itemstack);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)player, blockpos, itemstack);
            }
        }
        if (level.isClientSide()) {
            SoundType soundtype = stateAtPos.getSoundType((LevelReader)level, blockpos, (Entity)context.getPlayer());
            level.playSound(player, blockpos, SoundEvents.AMETHYST_BLOCK_HIT, SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
        }
        level.gameEvent((Holder)GameEvent.BLOCK_PLACE, blockpos, GameEvent.Context.of((Entity)player, (BlockState)stateAtPos));
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerItem(CoreCapabilities.EnergyConsumable.ITEM, (stack, context) -> FlareRodItem.createEnergyConsumer(stack, context, XyMachines.ServerConfig.FlareRodEnergyCost), new ItemLike[]{MachinesContent.Item.FlareRod});
        event.registerItem(CoreCapabilities.ModuleContainer.ITEM, VariableItem::createBasicModularStorage, new ItemLike[]{MachinesContent.Item.FlareRod});
    }
}

