/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks.engineering;

import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.api.content.capabilities.IColorable;
import tv.soaryn.xycraft.core.container.item.ItemContainer;
import tv.soaryn.xycraft.core.content.attachments.accessors.FavoredColor;
import tv.soaryn.xycraft.core.content.blocks.IColoredBlock;
import tv.soaryn.xycraft.core.content.blocks.XyBlock;
import tv.soaryn.xycraft.core.content.blocks.XyBlockEntity;
import tv.soaryn.xycraft.core.content.capabilities.ColorableCapability;
import tv.soaryn.xycraft.core.content.capabilities.CoreCapabilities;
import tv.soaryn.xycraft.core.content.registries.CoreAttachments;
import tv.soaryn.xycraft.core.utils.ColorUtils;
import tv.soaryn.xycraft.core.utils.Utils;
import tv.soaryn.xycraft.machines.content.attachments.EngineeringTableAttachment;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;
import tv.soaryn.xycraft.machines.gui.EngineeringTableMenu;

@EventBusSubscriber(modid="xycraft_machines", bus=EventBusSubscriber.Bus.MOD)
public class EngineeringTableBlock
extends XyBlock.WithEntity
implements IColoredBlock {
    private static final VoxelShape Shape = Shapes.or((VoxelShape)Shapes.or((VoxelShape)EngineeringTableBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), (VoxelShape)EngineeringTableBlock.box((double)1.0, (double)8.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0)), (VoxelShape)EngineeringTableBlock.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));

    public EngineeringTableBlock(BlockBehaviour.Properties properties) {
        super(properties.noOcclusion().requiredFeatures((FeatureFlag[])Utils.EXPERIMENTAL_FLAG.get()), Entity::new);
    }

    public boolean useShapeForLightOcclusion(@NotNull BlockState state) {
        return true;
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        BlockEntity be = level.getBlockEntity(pos);
        if (!(be instanceof Entity)) {
            return super.useWithoutItem(state, level, pos, player, hitResult);
        }
        Entity entity = (Entity)be;
        if (!level.isClientSide() && !player.isFakePlayer()) {
            player.openMenu((MenuProvider)entity, be.getBlockPos());
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    public void setPlacedBy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity entity, @NotNull ItemStack stack) {
        super.setPlacedBy(level, pos, state, entity, stack);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        DyeColor dye = DyeColor.getColor((ItemStack)player.getOffhandItem());
        IColorable cap = (IColorable)level.getCapability(CoreCapabilities.Colorable.BLOCK, pos, null);
        if (cap == null) {
            return;
        }
        cap.setColor(0, dye == null ? FavoredColor.of((IAttachmentHolder)player) : ColorUtils.getColorFromDye((DyeColor)dye));
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Shape;
    }

    public int getColorOfBlock(BlockState state, BlockAndTintGetter level, BlockPos pos, int index) {
        if (index == 2) {
            return -30686;
        }
        if (level == null) {
            return super.getColorOfBlock(state, level, pos, index);
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity == null) {
            return super.getColorOfBlock(state, level, pos, index);
        }
        return FavoredColor.of((IAttachmentHolder)blockEntity);
    }

    public int getColorOfItem(ItemStack stack, int index) {
        if (index == 2) {
            return -30686;
        }
        return FavoredColor.of((IAttachmentHolder)Utils.getClientPlayer());
    }

    @SubscribeEvent
    private static void attachBlockEntity(RegisterCapabilitiesEvent event) {
        event.registerBlock(CoreCapabilities.Colorable.BLOCK, ColorableCapability::registerBlock, new Block[]{MachinesContent.Block.EngineeringTable.block()});
    }

    public static class Entity
    extends XyBlockEntity
    implements MenuProvider {
        public Entity(BlockPos pos, BlockState state) {
            super(MachinesContent.Block.EngineeringTable.entity(), pos, state, new AttachmentType[]{MachinesAttachments.Block.EngineeringTableData.get(), (AttachmentType)CoreAttachments.Color.get()});
        }

        @NotNull
        public Component getDisplayName() {
            return Component.translatable((String)"block.xycraft_machines.engineering_table");
        }

        @Nullable
        public AbstractContainerMenu createMenu(int windowId, @NotNull Inventory playerInventory, @NotNull Player playerEntity) {
            return new EngineeringTableMenu(windowId, playerInventory, (BlockEntity)this, (ItemContainer)((EngineeringTableAttachment)this.getData(MachinesAttachments.Block.EngineeringTableData)).Inventory);
        }
    }
}

