/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.attachments.level;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.utils.AttachmentUtils;
import tv.soaryn.xycraft.core.utils.serialization.CodecUtils;
import tv.soaryn.xycraft.machines.content.multiblock.tank.MultiTank;
import tv.soaryn.xycraft.machines.content.multiblock.tank.TankMultiBlock;

public class MultiTankLevelAttachment {
    private static final Codec<MultiTankLevelAttachment> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)CodecUtils.tupleOf((Codec)UUIDUtil.CODEC, MultiTank.CODEC, Object2ObjectOpenHashMap::new).fieldOf("tank_map").forGetter(data -> data.multiTankMap)).apply((Applicative)builder, MultiTankLevelAttachment::new));
    public static final AttachmentType.Builder<MultiTankLevelAttachment> BUILDER = AttachmentUtils.createBuilder(MultiTankLevelAttachment::new, CODEC, MultiTankLevelAttachment::setAttachmentHolder);
    private final Object2ObjectOpenHashMap<UUID, MultiTank> multiTankMap = new Object2ObjectOpenHashMap();

    public ObjectCollection<MultiTank> getTanks() {
        return this.multiTankMap.values();
    }

    private MultiTankLevelAttachment(IAttachmentHolder holder) {
        this.setAttachmentHolder(holder);
    }

    private MultiTankLevelAttachment(Object2ObjectOpenHashMap<UUID, MultiTank> tankMap) {
        this.multiTankMap.putAll(tankMap);
    }

    public void addTank(MultiTank tank) {
        this.multiTankMap.put((Object)tank.getId(), (Object)tank);
    }

    public void removeTank(UUID uuid) {
        this.multiTankMap.remove((Object)uuid);
    }

    public void setAttachmentHolder(IAttachmentHolder holder) {
        if (!(holder instanceof ServerLevel)) {
            throw new IllegalArgumentException("Tried to use LevelToMultiTankCache on a " + holder.getClass().getSimpleName());
        }
        ServerLevel serverLevel = (ServerLevel)holder;
        this.multiTankMap.values().forEach(multiTank -> multiTank.setup(serverLevel));
    }

    public MultiTank getMultiTank(UUID id) {
        return (MultiTank)this.multiTankMap.get((Object)id);
    }

    @Nullable
    public TankMultiBlock getTankMultiBlock(TankMultiBlock.IDPair idPair) {
        MultiTank multiTank = this.getMultiTank(idPair.uuid());
        return multiTank == null ? null : multiTank.getMember(idPair.id());
    }
}

