/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.compat.viewers.emi;

import dev.emi.emi.api.neoforge.NeoForgeEmiStack;
import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.XyCore;
import tv.soaryn.xycraft.core.ui.BaseMenuUI;
import tv.soaryn.xycraft.core.ui.widgets.drawable.DrawableBackground;
import tv.soaryn.xycraft.core.ui.widgets.drawable.DrawableCanvas;
import tv.soaryn.xycraft.core.ui.widgets.drawable.DrawableFluid;
import tv.soaryn.xycraft.core.ui.widgets.drawable.DrawableFrame;
import tv.soaryn.xycraft.core.ui.widgets.drawable.DrawableImage;
import tv.soaryn.xycraft.core.ui.widgets.drawable.DrawableItem;
import tv.soaryn.xycraft.core.ui.widgets.drawable.DrawableText;
import tv.soaryn.xycraft.core.utils.rules.IRule;
import tv.soaryn.xycraft.machines.compat.viewers.ExtractorViewerCommon;
import tv.soaryn.xycraft.machines.compat.viewers.emi.DrawableRecipeWidgetAdapter;
import tv.soaryn.xycraft.machines.compat.viewers.emi.EMIExtractorCategory;
import tv.soaryn.xycraft.machines.content.recipes.producers.extractor.ExtractorRecipe;

public class EMIExtractorRecipe
extends BasicEmiRecipe {
    public static final EmiRecipeCategory CATEGORY = new EMIExtractorCategory();
    private final ExtractorRecipe recipe;

    public EMIExtractorRecipe(RecipeHolder<ExtractorRecipe> holder) {
        super(CATEGORY, holder.id(), 140, 82);
        this.recipe = (ExtractorRecipe)holder.value();
        EMIExtractorRecipe.getEmiIngredientStream(this.recipe.target()).forEach(this.inputs::add);
        for (IRule adjacentRule : this.recipe.adjacentRules()) {
            EMIExtractorRecipe.getEmiIngredientStream(adjacentRule).forEach(this.inputs::add);
        }
        if (this.recipe.catalyst().isPresent()) {
            EMIExtractorRecipe.getEmiIngredientStream(this.recipe.catalyst().get()).forEach(this.inputs::add);
        }
        if (this.recipe.isFluidRecipe()) {
            FluidStack fluidOutput = this.recipe.getFluidOutput();
            this.outputs.add(EmiStack.of((Fluid)fluidOutput.getFluid(), (DataComponentPatch)fluidOutput.getComponentsPatch(), (long)fluidOutput.getAmount()));
        } else {
            this.outputs.add(EmiStack.of((ItemStack)this.recipe.getItemOutput()));
        }
    }

    @NotNull
    private static Stream<EmiIngredient> getEmiIngredientStream(IRule rule) {
        List<ItemStack> itemStacks = ExtractorViewerCommon.RuleToItems.get(rule);
        List<FluidStack> fluidStacks = ExtractorViewerCommon.RuleToFluids.get(rule);
        if (itemStacks == null && fluidStacks == null) {
            return Stream.empty();
        }
        if (itemStacks != null) {
            return itemStacks.stream().filter(Predicate.not(ItemStack::isEmpty)).map(EmiStack::of).distinct().map(stack -> stack.setRemainder(stack));
        }
        return fluidStacks.stream().map(FluidStack::getFluid).map(Fluid::defaultFluidState).distinct().map(FluidState::getType).map(xva$0 -> FluidIngredient.of((Fluid[])new Fluid[]{xva$0})).distinct().filter(Predicate.not(FluidIngredient::isEmpty)).map(ingredient -> EmiIngredient.of(Arrays.stream(ingredient.getStacks()).map(NeoForgeEmiStack::of).map(emiStack -> emiStack.setRemainder(emiStack)).toList())).map(emiIngredient -> emiIngredient.setAmount(1000L));
    }

    public List<EmiIngredient> getInputs() {
        return super.getInputs();
    }

    public List<EmiIngredient> getCatalysts() {
        return super.getCatalysts();
    }

    public void addWidgets(WidgetHolder widgets) {
        DrawableCanvas rootCanvas = (DrawableCanvas)DrawableCanvas.create().dimensions(-2.0f, -2.0f, (float)(widgets.getWidth() + 4), (float)(widgets.getHeight() + 4));
        rootCanvas.addChild(DrawableFrame::create, this::handleCanvas);
        widgets.add(new DrawableRecipeWidgetAdapter(rootCanvas));
        FluidStack fluidOutput = this.recipe.getFluidOutput();
        EmiStack emiStack = this.recipe.isFluidRecipe() ? EmiStack.of((Fluid)fluidOutput.getFluid(), (DataComponentPatch)fluidOutput.getComponentsPatch(), (long)fluidOutput.getAmount()) : EmiStack.of((ItemStack)this.recipe.getItemOutput());
        ((CustomSlotWidget)widgets.add((Widget)new CustomSlotWidget((EmiIngredient)emiStack, 21, 9))).drawBack(false).recipeContext((EmiRecipe)this);
    }

    public boolean supportsRecipeTree() {
        return true;
    }

    public boolean hideCraftable() {
        return this.recipe.hidden();
    }

    private void handleCanvas(DrawableFrame frame) {
        ((DrawableFrame)((DrawableFrame)((DrawableFrame)frame.fillParent()).addChild(DrawableBackground::create, BaseMenuUI::backgroundFillWithPlayerColor)).addChild(DrawableText::create, drawableText -> ((DrawableText)((DrawableText)((DrawableText)drawableText.dimensions(0.0f, 16.0f, 0.0f, 24.0f)).fillParentHorizontal()).move(12.0f, 16.0f)).text("EMI integration Work in progress."))).addChild(DrawableText::create, drawableText -> ((DrawableText)((DrawableText)((DrawableText)drawableText.dimensions(0.0f, 32.0f, 0.0f, 24.0f)).fillParentHorizontal()).move(12.0f, 24.0f)).text("Sorry for delays."));
        if (this.recipe.hidden()) {
            frame.addChild(DrawableImage::create, drawableImage -> ((DrawableImage)drawableImage.dimensions(12.0f, 12.0f, 8.0f, 8.0f)).texture(XyCore.resource((String)"textures/gui/lock.png")));
        }
        frame.addChild(DrawableCanvas::create, canvas -> {
            canvas.dimensions(24.0f, 12.0f, 16.0f, 16.0f);
            if (this.recipe.isFluidRecipe()) {
                canvas.addChild(DrawableFluid::create, drawableFluid -> ((DrawableFluid)drawableFluid.fillParent()).fluid(this.recipe.getFluidOutput()).showCapacity(false).showMarkers(false));
            } else {
                canvas.addChild(DrawableItem::create, drawableItem -> ((DrawableItem)drawableItem.fillParent()).item(this.recipe.getItemOutput()));
            }
        });
    }

    public static class CustomSlotWidget
    extends SlotWidget {
        public CustomSlotWidget(EmiIngredient stack, int x, int y) {
            super(stack, x, y);
        }

        public void render(GuiGraphics draw, int mouseX, int mouseY, float delta) {
            if (this.shouldDrawSlotHighlight(mouseX, mouseY)) {
                this.drawSlotHighlight(draw, this.getBounds());
            }
        }
    }
}

