/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.utils.serialization;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Function3;
import com.mojang.datafixers.util.Function4;
import com.mojang.datafixers.util.Function5;
import com.mojang.datafixers.util.Function6;
import com.mojang.datafixers.util.Function7;
import com.mojang.datafixers.util.Function8;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import org.apache.commons.lang3.NotImplementedException;
import tv.soaryn.xycraft.core.utils.serialization.BinaryReader;
import tv.soaryn.xycraft.core.utils.serialization.BinaryWriter;
import tv.soaryn.xycraft.core.utils.value.Reference;
import tv.soaryn.xycraft.core.utils.value.Value;

public interface BinarySerializer<T>
extends BinaryWriter<T>,
BinaryReader<T> {
    default public StreamCodec<RegistryFriendlyByteBuf, T> asStreamCodec() {
        return StreamCodec.of(this::serialize, this::deserialize);
    }

    default public <V> BinarySerializer<V> map(Function<V, T> encoder, Function<T, V> decoder) {
        return BinarySerializer.of((buf, val) -> this.serialize(buf, encoder.apply(val)), buf -> decoder.apply(this.deserialize(buf)));
    }

    default public BinarySerializer<T> nullable() {
        return BinarySerializer.of((buf, val) -> {
            buf.writeBoolean(val != null);
            if (val != null) {
                this.serialize(buf, val);
            }
        }, buf -> buf.readBoolean() ? this.deserialize(buf) : null);
    }

    public static <T> BinarySerializer<T> placeholder() {
        return BinarySerializer.of((buf, val) -> {
            throw new NotImplementedException();
        }, buf -> {
            throw new NotImplementedException();
        });
    }

    public static <TSerializedType> BinarySerializer<TSerializedType> of(StreamCodec<RegistryFriendlyByteBuf, TSerializedType> streamCodec) {
        return BinarySerializer.of((arg_0, arg_1) -> streamCodec.encode(arg_0, arg_1), arg_0 -> streamCodec.decode(arg_0));
    }

    public static <T> BinarySerializer<T> of(final BinaryWriter<T> serializer, final BinaryReader<T> deserializer) {
        return new BinarySerializer<T>(){

            @Override
            public void serialize(RegistryFriendlyByteBuf buf, T value) {
                serializer.serialize(buf, value);
            }

            @Override
            public T deserialize(RegistryFriendlyByteBuf buf) {
                return deserializer.deserialize(buf);
            }
        };
    }

    public static <T extends Enum<T>> BinarySerializer<T> ofEnum(Class<T> type) {
        return BinarySerializer.of(FriendlyByteBuf::writeEnum, buf -> buf.readEnum(type));
    }

    public static <T> BinarySerializer<Optional<T>> optionalOf(BinarySerializer<T> serializer) {
        return BinarySerializer.of((buf, value) -> buf.writeOptional(value, (friendlyByteBuf, t) -> serializer.serialize((RegistryFriendlyByteBuf)friendlyByteBuf, t)), buf -> buf.readOptional(friendlyByteBuf -> serializer.deserialize((RegistryFriendlyByteBuf)friendlyByteBuf)));
    }

    public static <LEFT, RIGHT> BinarySerializer<Either<LEFT, RIGHT>> eitherOf(BinarySerializer<LEFT> left, BinarySerializer<RIGHT> right) {
        return BinarySerializer.of((buf, value) -> {
            value.ifLeft(leftValue -> {
                buf.writeBoolean(false);
                left.serialize(buf, leftValue);
            });
            value.ifRight(rightValue -> {
                buf.writeBoolean(true);
                right.serialize(buf, rightValue);
            });
        }, buf -> {
            if (buf.readBoolean()) {
                return Either.right(right.deserialize(buf));
            }
            return Either.left(left.deserialize(buf));
        });
    }

    public static <T> BinarySerializer<T[]> ofArray(IntFunction<T[]> factory, BinarySerializer<T> serializer) {
        return BinarySerializer.of((buf, val) -> {
            buf.writeVarInt(((Object[])val).length);
            for (Object v : val) {
                serializer.serialize(buf, v);
            }
        }, buf -> {
            Object[] array = (Object[])factory.apply(buf.readVarInt());
            for (int i = 0; i < array.length; ++i) {
                array[i] = serializer.deserialize(buf);
            }
            return array;
        });
    }

    public static <T extends Collection<V>, V> BinarySerializer<T> ofCollection(Supplier<T> factory, BinarySerializer<V> serializer) {
        return BinarySerializer.of((buf, val) -> {
            buf.writeVarInt(val.size());
            for (Object v : val) {
                serializer.serialize(buf, v);
            }
        }, buf -> {
            Collection collection = (Collection)factory.get();
            int size = buf.readVarInt();
            for (int i = 0; i < size; ++i) {
                collection.add(serializer.deserialize(buf));
            }
            return collection;
        });
    }

    public static <M extends Map<K, V>, K, V> BinarySerializer<M> ofMap(Supplier<M> factory, BinarySerializer<K> keySerializer, BinarySerializer<V> valueSerializer) {
        return BinarySerializer.of((buf, val) -> {
            buf.writeVarInt(val.size());
            val.forEach((k, v) -> {
                keySerializer.serialize(buf, k);
                valueSerializer.serialize(buf, v);
            });
        }, buf -> {
            Map map = (Map)factory.get();
            int size = buf.readVarInt();
            for (int i = 0; i < size; ++i) {
                map.put(keySerializer.deserialize(buf), valueSerializer.deserialize(buf));
            }
            return map;
        });
    }

    public static <T> BinarySerializer<? extends Reference<T>> ofReference(BinarySerializer<T> serializer) {
        return BinarySerializer.of((buf, val) -> serializer.serialize(buf, val.get()), buf -> new Value(serializer.deserialize(buf)));
    }

    public static <T> BinarySerializer<T> ofType(Supplier<T> constructor) {
        return BinarySerializer.of((buf, val) -> {}, buf -> constructor.get());
    }

    public static <T, T1> BinarySerializer<T> ofType(Function<T1, T> constructor, Function<T, T1> getter1, BinarySerializer<T1> serializer1) {
        return BinarySerializer.of((buf, val) -> serializer1.serialize(buf, getter1.apply(val)), buf -> constructor.apply(serializer1.deserialize(buf)));
    }

    public static <T, T1, T2> BinarySerializer<T> ofType(BiFunction<T1, T2, T> constructor, Function<T, T1> getter1, BinarySerializer<T1> serializer1, Function<T, T2> getter2, BinarySerializer<T2> serializer2) {
        return BinarySerializer.of((buf, val) -> {
            serializer1.serialize(buf, getter1.apply(val));
            serializer2.serialize(buf, getter2.apply(val));
        }, buf -> constructor.apply(serializer1.deserialize(buf), serializer2.deserialize(buf)));
    }

    public static <T, T1, T2, T3> BinarySerializer<T> ofType(Function3<T1, T2, T3, T> constructor, Function<T, T1> getter1, BinarySerializer<T1> serializer1, Function<T, T2> getter2, BinarySerializer<T2> serializer2, Function<T, T3> getter3, BinarySerializer<T3> serializer3) {
        return BinarySerializer.of((buf, val) -> {
            serializer1.serialize(buf, getter1.apply(val));
            serializer2.serialize(buf, getter2.apply(val));
            serializer3.serialize(buf, getter3.apply(val));
        }, buf -> constructor.apply(serializer1.deserialize(buf), serializer2.deserialize(buf), serializer3.deserialize(buf)));
    }

    public static <T, T1, T2, T3, T4> BinarySerializer<T> ofType(Function4<T1, T2, T3, T4, T> constructor, Function<T, T1> getter1, BinarySerializer<T1> serializer1, Function<T, T2> getter2, BinarySerializer<T2> serializer2, Function<T, T3> getter3, BinarySerializer<T3> serializer3, Function<T, T4> getter4, BinarySerializer<T4> serializer4) {
        return BinarySerializer.of((buf, val) -> {
            serializer1.serialize(buf, getter1.apply(val));
            serializer2.serialize(buf, getter2.apply(val));
            serializer3.serialize(buf, getter3.apply(val));
            serializer4.serialize(buf, getter4.apply(val));
        }, buf -> constructor.apply(serializer1.deserialize(buf), serializer2.deserialize(buf), serializer3.deserialize(buf), serializer4.deserialize(buf)));
    }

    public static <T, T1, T2, T3, T4, T5> BinarySerializer<T> ofType(Function5<T1, T2, T3, T4, T5, T> constructor, Function<T, T1> getter1, BinarySerializer<T1> serializer1, Function<T, T2> getter2, BinarySerializer<T2> serializer2, Function<T, T3> getter3, BinarySerializer<T3> serializer3, Function<T, T4> getter4, BinarySerializer<T4> serializer4, Function<T, T5> getter5, BinarySerializer<T5> serializer5) {
        return BinarySerializer.of((buf, val) -> {
            serializer1.serialize(buf, getter1.apply(val));
            serializer2.serialize(buf, getter2.apply(val));
            serializer3.serialize(buf, getter3.apply(val));
            serializer4.serialize(buf, getter4.apply(val));
            serializer5.serialize(buf, getter5.apply(val));
        }, buf -> constructor.apply(serializer1.deserialize(buf), serializer2.deserialize(buf), serializer3.deserialize(buf), serializer4.deserialize(buf), serializer5.deserialize(buf)));
    }

    public static <T, T1, T2, T3, T4, T5, T6> BinarySerializer<T> ofType(Function6<T1, T2, T3, T4, T5, T6, T> constructor, Function<T, T1> getter1, BinarySerializer<T1> serializer1, Function<T, T2> getter2, BinarySerializer<T2> serializer2, Function<T, T3> getter3, BinarySerializer<T3> serializer3, Function<T, T4> getter4, BinarySerializer<T4> serializer4, Function<T, T5> getter5, BinarySerializer<T5> serializer5, Function<T, T6> getter6, BinarySerializer<T6> serializer6) {
        return BinarySerializer.of((buf, val) -> {
            serializer1.serialize(buf, getter1.apply(val));
            serializer2.serialize(buf, getter2.apply(val));
            serializer3.serialize(buf, getter3.apply(val));
            serializer4.serialize(buf, getter4.apply(val));
            serializer5.serialize(buf, getter5.apply(val));
            serializer6.serialize(buf, getter6.apply(val));
        }, buf -> constructor.apply(serializer1.deserialize(buf), serializer2.deserialize(buf), serializer3.deserialize(buf), serializer4.deserialize(buf), serializer5.deserialize(buf), serializer6.deserialize(buf)));
    }

    public static <T, T1, T2, T3, T4, T5, T6, T7> BinarySerializer<T> ofType(Function7<T1, T2, T3, T4, T5, T6, T7, T> constructor, Function<T, T1> getter1, BinarySerializer<T1> serializer1, Function<T, T2> getter2, BinarySerializer<T2> serializer2, Function<T, T3> getter3, BinarySerializer<T3> serializer3, Function<T, T4> getter4, BinarySerializer<T4> serializer4, Function<T, T5> getter5, BinarySerializer<T5> serializer5, Function<T, T6> getter6, BinarySerializer<T6> serializer6, Function<T, T7> getter7, BinarySerializer<T7> serializer7) {
        return BinarySerializer.of((buf, val) -> {
            serializer1.serialize(buf, getter1.apply(val));
            serializer2.serialize(buf, getter2.apply(val));
            serializer3.serialize(buf, getter3.apply(val));
            serializer4.serialize(buf, getter4.apply(val));
            serializer5.serialize(buf, getter5.apply(val));
            serializer6.serialize(buf, getter6.apply(val));
            serializer7.serialize(buf, getter7.apply(val));
        }, buf -> constructor.apply(serializer1.deserialize(buf), serializer2.deserialize(buf), serializer3.deserialize(buf), serializer4.deserialize(buf), serializer5.deserialize(buf), serializer6.deserialize(buf), serializer7.deserialize(buf)));
    }

    public static <T, T1, T2, T3, T4, T5, T6, T7, T8> BinarySerializer<T> ofType(Function8<T1, T2, T3, T4, T5, T6, T7, T8, T> constructor, Function<T, T1> getter1, BinarySerializer<T1> serializer1, Function<T, T2> getter2, BinarySerializer<T2> serializer2, Function<T, T3> getter3, BinarySerializer<T3> serializer3, Function<T, T4> getter4, BinarySerializer<T4> serializer4, Function<T, T5> getter5, BinarySerializer<T5> serializer5, Function<T, T6> getter6, BinarySerializer<T6> serializer6, Function<T, T7> getter7, BinarySerializer<T7> serializer7, Function<T, T8> getter8, BinarySerializer<T8> serializer8) {
        return BinarySerializer.of((buf, val) -> {
            serializer1.serialize(buf, getter1.apply(val));
            serializer2.serialize(buf, getter2.apply(val));
            serializer3.serialize(buf, getter3.apply(val));
            serializer4.serialize(buf, getter4.apply(val));
            serializer5.serialize(buf, getter5.apply(val));
            serializer6.serialize(buf, getter6.apply(val));
            serializer7.serialize(buf, getter7.apply(val));
            serializer8.serialize(buf, getter8.apply(val));
        }, buf -> constructor.apply(serializer1.deserialize(buf), serializer2.deserialize(buf), serializer3.deserialize(buf), serializer4.deserialize(buf), serializer5.deserialize(buf), serializer6.deserialize(buf), serializer7.deserialize(buf), serializer8.deserialize(buf)));
    }
}

