/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.blocks;

import java.util.Arrays;
import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.content.attachments.accessors.ModifierKey;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.blocks.XyBlock;
import tv.soaryn.xycraft.core.content.blocks.XyBlockEntity;
import tv.soaryn.xycraft.core.utils.ShapeUtils;

public abstract class SidePartBlock
extends XyBlock
implements SimpleWaterloggedBlock {
    private final VoxelShape[] SHAPES = (VoxelShape[])Util.make((Object)new VoxelShape[6], array -> {
        VoxelShape downShape = this.getDownShapeForBaking();
        Arrays.setAll(array, i -> ShapeUtils.rotate(downShape, Direction.from3DDataValue((int)i)));
    });

    public static Direction directionOf(BlockState state) {
        return (Direction)state.getValue(CoreStateProperties.StateDirection);
    }

    public SidePartBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(CoreStateProperties.StateDirection, (Comparable)Direction.DOWN)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{CoreStateProperties.StateDirection});
        builder.add(new Property[]{BlockStateProperties.WATERLOGGED});
    }

    public static boolean isInaccessibleSide(Direction context, BlockState state) {
        return context != state.getValue(CoreStateProperties.StateDirection);
    }

    @NotNull
    public BlockState rotate(BlockState state, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull Rotation direction) {
        Direction orientation = (Direction)state.getValue(CoreStateProperties.StateDirection);
        if (orientation.getAxis() == Direction.Axis.Y) {
            return state;
        }
        return (BlockState)state.setValue(CoreStateProperties.StateDirection, (Comparable)direction.rotate(orientation));
    }

    public boolean canBeReplaced(@NotNull BlockState state, @NotNull BlockPlaceContext context) {
        return false;
    }

    public boolean canBeReplaced(@NotNull BlockState state, @NotNull Fluid fluid) {
        return false;
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        FluidState fluidstate = ctx.getLevel().getFluidState(ctx.getClickedPos());
        Direction direction = ctx.getClickedFace().getOpposite();
        if (ModifierKey.of(ctx.getPlayer())) {
            direction = direction.getOpposite();
        }
        return (BlockState)((BlockState)this.defaultBlockState().setValue(CoreStateProperties.StateDirection, (Comparable)direction)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
    }

    @NotNull
    public BlockState updateShape(BlockState state, @NotNull Direction direction, @NotNull BlockState other, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos otherPos) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, other, level, pos, otherPos);
    }

    public abstract VoxelShape getDownShapeForBaking();

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.SHAPES[((Direction)state.getValue(CoreStateProperties.StateDirection)).get3DDataValue()];
    }

    public static abstract class WithEntity
    extends SidePartBlock
    implements EntityBlock {
        final BiFunction<BlockPos, BlockState, XyBlockEntity> entityType;

        public WithEntity(BlockBehaviour.Properties properties, BiFunction<BlockPos, BlockState, XyBlockEntity> entity) {
            super(properties);
            this.entityType = entity;
        }

        @Nullable
        public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
            return this.entityType.apply(pos, state);
        }
    }
}

