/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.blocks;

import java.util.EnumMap;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.attachments.accessors.ModifierKey;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.blocks.DyeableBlock;
import tv.soaryn.xycraft.core.utils.DyeColors;

public class DyeablePillarBlock
extends DyeableBlock {
    public DyeablePillarBlock(DyeColors color, BlockBehaviour.Properties properties, EnumMap<DyeColors, BlockContent> map) {
        super(color, properties, map);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(CoreStateProperties.Axis, (Comparable)Direction.Axis.Y));
    }

    @NotNull
    public BlockState rotate(@NotNull BlockState state, @NotNull Rotation rotation) {
        return DyeablePillarBlock.rotatePillar(state, rotation);
    }

    public static BlockState rotatePillar(BlockState state, Rotation rotation) {
        return switch (rotation) {
            case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> {
                switch ((Direction.Axis)state.getValue(CoreStateProperties.Axis)) {
                    case X: {
                        yield (BlockState)state.setValue(CoreStateProperties.Axis, (Comparable)Direction.Axis.Z);
                    }
                    case Z: {
                        yield (BlockState)state.setValue(CoreStateProperties.Axis, (Comparable)Direction.Axis.X);
                    }
                }
                yield state;
            }
            default -> state;
        };
    }

    @Override
    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> stateBuilder) {
        super.createBlockStateDefinition(stateBuilder);
        stateBuilder.add(new Property[]{CoreStateProperties.Axis});
    }

    @Override
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        Direction.Axis axis = ModifierKey.of(context.getPlayer()) ? Direction.Axis.Y : context.getClickedFace().getAxis();
        BlockState state = super.getStateForPlacement(context);
        if (state == null) {
            state = this.defaultBlockState();
        }
        return (BlockState)state.setValue(CoreStateProperties.Axis, (Comparable)axis);
    }
}

