/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.attachments.memory;

import it.unimi.dsi.fastutil.objects.Reference2BooleanMap;
import it.unimi.dsi.fastutil.objects.Reference2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.lang.ref.WeakReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;

public class CapabilityCacheAttachment<T> {
    private final WeakReference<BlockEntity> _blockEntity;
    private final BlockCapability<T, Void> _cap;
    private final Reference2ObjectMap<Direction, BlockCapabilityCache<T, Void>> _caches = new Reference2ObjectOpenHashMap();
    public final Reference2BooleanMap<Direction> DirtySides = new Reference2BooleanOpenHashMap();
    public boolean IsDirty = false;

    public CapabilityCacheAttachment(IAttachmentHolder holder, BlockCapability<T, Void> cap) {
        if (!(holder instanceof BlockEntity)) {
            throw new IllegalStateException("Holder was not a block entity for Capability Cache: " + String.valueOf(holder.getClass()));
        }
        BlockEntity entity = (BlockEntity)holder;
        this._blockEntity = new WeakReference<BlockEntity>(entity);
        this._cap = cap;
    }

    public T getCap(Direction direction) {
        BlockEntity be = (BlockEntity)this._blockEntity.get();
        if (be == null) {
            return null;
        }
        Level level = be.getLevel();
        if (level == null) {
            return null;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return (T)((BlockCapabilityCache)this._caches.computeIfAbsent((Object)direction, d -> BlockCapabilityCache.create(this._cap, (ServerLevel)serverLevel, (BlockPos)be.getBlockPos().relative(d), null, () -> this._blockEntity.get() != null, () -> {
                BlockEntity blockEntity = (BlockEntity)this._blockEntity.get();
                if (blockEntity == null || blockEntity.isRemoved()) {
                    return;
                }
                this.DirtySides.put(d, true);
                this.IsDirty = true;
            }))).getCapability();
        }
        return (T)level.getCapability(this._cap, be.getBlockPos().relative(direction), null);
    }
}

