/*
 * Decompiled with CFR 0.152.
 */
package dev.alinco8.xmxw;

import dev.alinco8.xmxw.XMXWClientKt;
import dev.alinco8.xmxw.config.XMXWConfig;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.BalmEvents;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.event.WaystoneUpdateReceivedEvent;
import net.blay09.mods.waystones.api.event.WaystonesListReceivedEvent;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.waypoint.WaypointColor;
import xaero.hud.minimap.world.MinimapWorldManager;
import xaero.hud.module.HudModule;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001)B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0007J!\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0014\"\u00020\u0015H\u0007\u00a2\u0006\u0002\u0010\u0016J\u0006\u0010\u0017\u001a\u00020\u0012J\u000e\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020%J\u000e\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u000fJ\u000e\u0010(\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\b\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00050\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR#\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u001a0\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\rR\u0019\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006*"}, d2={"Ldev/alinco8/xmxw/XMXWClient;", "", "<init>", "()V", "MOD_ID", "", "LOGGER", "Lorg/slf4j/Logger;", "replacers", "", "Lkotlin/Function1;", "Ldev/alinco8/xmxw/XMXWClient$WaystoneData;", "getReplacers", "()Ljava/util/Map;", "loc", "Lnet/minecraft/resources/ResourceLocation;", "path", "displayMessage", "", "component", "", "Lnet/minecraft/network/chat/Component;", "([Lnet/minecraft/network/chat/Component;)V", "initialize", "waystones", "", "", "getWaystones", "waypoints", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "Lxaero/common/minimap/waypoints/Waypoint;", "getWaypoints", "()Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "onWaystonesListReceived", "event", "Lnet/blay09/mods/waystones/api/event/WaystonesListReceivedEvent;", "onWaystoneUpdateReceived", "Lnet/blay09/mods/waystones/api/event/WaystoneUpdateReceivedEvent;", "onDimensionChange", "dimKey", "updateWaystoneWaypoints", "WaystoneData", "xmxw"})
@SourceDebugExtension(value={"SMAP\nXMXWClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XMXWClient.kt\ndev/alinco8/xmxw/XMXWClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,229:1\n1#2:230\n1915#3,2:231\n1924#3,2:233\n1926#3:242\n540#4:235\n525#4,6:236\n*S KotlinDebug\n*F\n+ 1 XMXWClient.kt\ndev/alinco8/xmxw/XMXWClient\n*L\n117#1:231,2\n194#1:233,2\n194#1:242\n200#1:235\n200#1:236,6\n*E\n"})
public final class XMXWClient {
    @NotNull
    public static final XMXWClient INSTANCE = new XMXWClient();
    @NotNull
    public static final String MOD_ID = "xmxw";
    @JvmField
    @NotNull
    public static final Logger LOGGER;
    @NotNull
    private static final Map<String, Function1<WaystoneData, String>> replacers;
    @NotNull
    private static final Map<ResourceLocation, List<WaystoneData>> waystones;

    private XMXWClient() {
    }

    @NotNull
    public final Map<String, Function1<WaystoneData, String>> getReplacers() {
        return replacers;
    }

    @JvmStatic
    @NotNull
    public static final ResourceLocation loc(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"fromNamespaceAndPath(...)");
        return resourceLocation;
    }

    @JvmStatic
    public static final void displayMessage(Component ... component) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            MutableComponent message = Component.empty().append((Component)Component.literal((String)"[XMXW] ").withStyle(ChatFormatting.GREEN));
            for (Component part : component) {
                message.append(part);
            }
            LocalPlayer localPlayer = Minecraft.getInstance().player;
            if (localPlayer == null) break block1;
            localPlayer.displayClientMessage((Component)message, false);
        }
    }

    public final void initialize() {
        BalmEvents balmEvents;
        LOGGER.debug("Initializing XMXW Client");
        XMXWConfig.Companion.getHANDLER().load();
        BalmEvents $this$initialize_u24lambda_u240 = balmEvents = Balm.getEvents();
        boolean bl = false;
        $this$initialize_u24lambda_u240.onEvent(WaystonesListReceivedEvent.class, INSTANCE::onWaystonesListReceived);
        $this$initialize_u24lambda_u240.onEvent(WaystoneUpdateReceivedEvent.class, INSTANCE::onWaystoneUpdateReceived);
    }

    @NotNull
    public final Map<ResourceLocation, List<WaystoneData>> getWaystones() {
        return waystones;
    }

    @Nullable
    public final Int2ObjectMap<Waypoint> getWaypoints() {
        MinimapWorldManager minimapWorldManager;
        MinimapSession minimapSession;
        HudModule hudModule = BuiltInHudModules.MINIMAP;
        return hudModule != null && (minimapSession = (MinimapSession)hudModule.getCurrentSession()) != null && (minimapWorldManager = minimapSession.getWorldManager()) != null ? minimapWorldManager.getCustomWaypoints(XMXWClient.loc("waypoints")) : null;
    }

    /*
     * WARNING - void declaration
     */
    public final void onWaystonesListReceived(@NotNull WaystonesListReceivedEvent event) {
        void var16_16;
        void entry;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Map receivedWaystones = MapsKt.mapOf((Pair)TuplesKt.to((Object)event.getWaystoneType(), (Object)event.getWaystones()));
        Iterable iterable = receivedWaystones.values();
        Integer n2 = receivedWaystones.size();
        String string = "Received waystones list with {} waystone types and total of {} waystones";
        Logger logger = LOGGER;
        boolean n3 = false;
        Iterator iterator = iterable.iterator();
        while (iterator.hasNext()) {
            void it;
            Object t = iterator.next();
            List list = (List)t;
            var16_16 = entry;
            boolean bl = false;
            int n = it.size();
            entry = var16_16 + n;
        }
        var16_16 = entry;
        logger.debug(string, (Object)n2, (Object)((int)var16_16));
        if (receivedWaystones.isEmpty()) {
            waystones.clear();
            ClientLevel clientLevel = Minecraft.getInstance().level;
            if (clientLevel == null || (clientLevel = clientLevel.dimension()) == null || (clientLevel = XMXWClientKt.loc(clientLevel)) == null) {
                return;
            }
            this.updateWaystoneWaypoints((ResourceLocation)clientLevel);
        }
        for (Map.Entry entry2 : receivedWaystones.entrySet()) {
            ResourceLocation waystoneType = (ResourceLocation)entry2.getKey();
            List receivedWaystones2 = (List)entry2.getValue();
            LOGGER.debug("Processing {} waystones of type {}", (Object)receivedWaystones2.size(), (Object)waystoneType);
            if (!Intrinsics.areEqual((Object)waystoneType.toString(), (Object)"waystones:waystone")) continue;
            Iterable $this$forEach$iv = waystones.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                List waystones = (List)element$iv;
                boolean bl = false;
                waystones.removeIf(arg_0 -> XMXWClient.onWaystonesListReceived$lambda$1$1(arg_0 -> XMXWClient.onWaystonesListReceived$lambda$1$0(waystoneType, arg_0), arg_0));
            }
            waystones.values().removeIf(arg_0 -> XMXWClient.onWaystonesListReceived$lambda$3(XMXWClient::onWaystonesListReceived$lambda$2, arg_0));
            for (Waystone waystone : receivedWaystones2) {
                LOGGER.debug("Processing waystone {} at {}", (Object)waystone.getName(), (Object)waystone.getPos());
                if (!waystone.isValid()) continue;
                ResourceKey resourceKey = waystone.getDimension();
                Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"getDimension(...)");
                ResourceLocation dimKey = XMXWClientKt.loc(resourceKey);
                int n = waystone.getPos().getX();
                int n4 = waystone.getPos().getY();
                int n5 = waystone.getPos().getZ();
                String string2 = waystone.getName().getString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
                Intrinsics.checkNotNull((Object)waystoneType);
                UUID uUID = waystone.getWaystoneUid();
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getWaystoneUid(...)");
                WaystoneData waystoneData = new WaystoneData(n, n4, n5, string2, waystoneType, uUID);
                waystones.computeIfAbsent(dimKey, arg_0 -> XMXWClient.onWaystonesListReceived$lambda$5(XMXWClient::onWaystonesListReceived$lambda$4, arg_0)).add(waystoneData);
            }
            ClientLevel clientLevel = Minecraft.getInstance().level;
            if (clientLevel == null || (clientLevel = clientLevel.dimension()) == null || (clientLevel = XMXWClientKt.loc(clientLevel)) == null) {
                return;
            }
            this.updateWaystoneWaypoints((ResourceLocation)clientLevel);
        }
    }

    public final void onWaystoneUpdateReceived(@NotNull WaystoneUpdateReceivedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LOGGER.debug("Received waystone update for waystone {} {}", (Object)event.getWaystone().getName(), (Object)event.getWaystone().getWaystoneUid());
        if (!event.getWaystone().isValid() || !Intrinsics.areEqual((Object)event.getWaystone().getWaystoneType().toString(), (Object)"waystones:waystone")) {
            return;
        }
        for (List<WaystoneData> waystonesList : waystones.values()) {
            waystonesList.removeIf(arg_0 -> XMXWClient.onWaystoneUpdateReceived$lambda$1(arg_0 -> XMXWClient.onWaystoneUpdateReceived$lambda$0(event, arg_0), arg_0));
        }
        waystones.values().removeIf(arg_0 -> XMXWClient.onWaystoneUpdateReceived$lambda$3(XMXWClient::onWaystoneUpdateReceived$lambda$2, arg_0));
        Waystone waystone = event.getWaystone();
        int n = waystone.getPos().getX();
        int n2 = waystone.getPos().getY();
        int n3 = waystone.getPos().getZ();
        String string = waystone.getName().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        ResourceLocation resourceLocation = waystone.getWaystoneType();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"getWaystoneType(...)");
        UUID uUID = waystone.getWaystoneUid();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getWaystoneUid(...)");
        WaystoneData waystoneData = new WaystoneData(n, n2, n3, string, resourceLocation, uUID);
        ResourceKey resourceKey = waystone.getDimension();
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"getDimension(...)");
        ResourceLocation dimKey = XMXWClientKt.loc(resourceKey);
        waystones.computeIfAbsent(dimKey, arg_0 -> XMXWClient.onWaystoneUpdateReceived$lambda$5(XMXWClient::onWaystoneUpdateReceived$lambda$4, arg_0)).add(waystoneData);
    }

    public final void onDimensionChange(@NotNull ResourceLocation dimKey) {
        Intrinsics.checkNotNullParameter((Object)dimKey, (String)"dimKey");
        LOGGER.debug("Dimension changed to {}", (Object)dimKey);
        this.updateWaystoneWaypoints(dimKey);
    }

    /*
     * WARNING - void declaration
     */
    public final void updateWaystoneWaypoints(@NotNull ResourceLocation dimKey) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)dimKey, (String)"dimKey");
            LOGGER.debug("Updating waypoints for dimension {}", (Object)dimKey);
            Int2ObjectMap<Waypoint> int2ObjectMap = this.getWaypoints();
            if (int2ObjectMap == null) break block5;
            Int2ObjectMap<Waypoint> waypoints = int2ObjectMap;
            boolean bl = false;
            waypoints.clear();
            XMXWConfig config = (XMXWConfig)XMXWConfig.Companion.getHANDLER().instance();
            List<WaystoneData> list = waystones.get(dimKey);
            if (list != null) {
                Iterable $this$forEachIndexed$iv = list;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    Waypoint waypoint;
                    void $this$filterTo$iv$iv;
                    void waystone;
                    Map<WaypointColor, Boolean> replacer;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    WaystoneData waystoneData = (WaystoneData)item$iv;
                    int index = n;
                    boolean bl2 = false;
                    String waypointName = config.getWaypointNameFormat();
                    for (Map.Entry<String, Function1<WaystoneData, String>> entry : replacers.entrySet()) {
                        String key = entry.getKey();
                        replacer = entry.getValue();
                        waypointName = StringsKt.replace$default((String)waypointName, (String)("{" + key + "}"), (String)((String)replacer.invoke(waystone)), (boolean)false, (int)4, null);
                    }
                    Map<WaypointColor, Boolean> $this$filter$iv = config.getWaypointColorCandidates();
                    boolean $i$f$filter = false;
                    replacer = $this$filter$iv;
                    Map destination$iv$iv = new LinkedHashMap();
                    boolean $i$f$filterTo = false;
                    Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry element$iv$iv;
                        Map.Entry it = element$iv$iv = iterator.next();
                        boolean bl3 = false;
                        if (!((Boolean)it.getValue()).booleanValue()) continue;
                        destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                    }
                    List validColors = CollectionsKt.toList((Iterable)destination$iv$iv.keySet());
                    WaypointColor waypointColor = !((Collection)validColors).isEmpty() ? (WaypointColor)validColors.get(Math.floorMod(waystone.getId().getMostSignificantBits(), validColors.size())) : WaypointColor.GRAY;
                    Map map = (Map)waypoints;
                    Integer n2 = index;
                    Waypoint it = waypoint = new Waypoint(waystone.getX() + config.getWaypointOffsetX(), waystone.getY() + config.getWaypointOffsetY(), waystone.getZ() + config.getWaypointOffsetZ(), waypointName, config.getWaypointTitle(), waypointColor);
                    boolean bl4 = false;
                    it.setVisibility(config.getWaypointVisibility());
                    map.put(n2, waypoint);
                }
            }
        }
    }

    private static final String replacers$lambda$0(WaystoneData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    private static final boolean onWaystonesListReceived$lambda$1$0(ResourceLocation $waystoneType, WaystoneData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getType(), (Object)$waystoneType);
    }

    private static final boolean onWaystonesListReceived$lambda$1$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean onWaystonesListReceived$lambda$2(List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isEmpty();
    }

    private static final boolean onWaystonesListReceived$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final List onWaystonesListReceived$lambda$4(ResourceLocation it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List onWaystonesListReceived$lambda$5(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final boolean onWaystoneUpdateReceived$lambda$0(WaystoneUpdateReceivedEvent $event, WaystoneData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getType(), (Object)$event.getWaystone().getWaystoneUid());
    }

    private static final boolean onWaystoneUpdateReceived$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean onWaystoneUpdateReceived$lambda$2(List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isEmpty();
    }

    private static final boolean onWaystoneUpdateReceived$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final List onWaystoneUpdateReceived$lambda$4(ResourceLocation it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List onWaystoneUpdateReceived$lambda$5(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    static {
        Logger logger = LoggerFactory.getLogger((String)MOD_ID);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
        replacers = MapsKt.mapOf((Pair)TuplesKt.to((Object)"name", XMXWClient::replacers$lambda$0));
        waystones = new LinkedHashMap();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u000bH\u00c6\u0003JE\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0014\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\"\u001a\u00020\u0003H\u00d6\u0081\u0004J\n\u0010#\u001a\u00020\u0007H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006$"}, d2={"Ldev/alinco8/xmxw/XMXWClient$WaystoneData;", "", "x", "", "y", "z", "name", "", "type", "Lnet/minecraft/resources/ResourceLocation;", "id", "Ljava/util/UUID;", "<init>", "(IIILjava/lang/String;Lnet/minecraft/resources/ResourceLocation;Ljava/util/UUID;)V", "getX", "()I", "getY", "getZ", "getName", "()Ljava/lang/String;", "getType", "()Lnet/minecraft/resources/ResourceLocation;", "getId", "()Ljava/util/UUID;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "xmxw"})
    public static final class WaystoneData {
        private final int x;
        private final int y;
        private final int z;
        @NotNull
        private final String name;
        @NotNull
        private final ResourceLocation type;
        @NotNull
        private final UUID id;

        public WaystoneData(int x, int y, int z, @NotNull String name, @NotNull ResourceLocation type, @NotNull UUID id) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.x = x;
            this.y = y;
            this.z = z;
            this.name = name;
            this.type = type;
            this.id = id;
        }

        public final int getX() {
            return this.x;
        }

        public final int getY() {
            return this.y;
        }

        public final int getZ() {
            return this.z;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final ResourceLocation getType() {
            return this.type;
        }

        @NotNull
        public final UUID getId() {
            return this.id;
        }

        public final int component1() {
            return this.x;
        }

        public final int component2() {
            return this.y;
        }

        public final int component3() {
            return this.z;
        }

        @NotNull
        public final String component4() {
            return this.name;
        }

        @NotNull
        public final ResourceLocation component5() {
            return this.type;
        }

        @NotNull
        public final UUID component6() {
            return this.id;
        }

        @NotNull
        public final WaystoneData copy(int x, int y, int z, @NotNull String name, @NotNull ResourceLocation type, @NotNull UUID id) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return new WaystoneData(x, y, z, name, type, id);
        }

        public static /* synthetic */ WaystoneData copy$default(WaystoneData waystoneData, int n, int n2, int n3, String string, ResourceLocation resourceLocation, UUID uUID, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = waystoneData.x;
            }
            if ((n4 & 2) != 0) {
                n2 = waystoneData.y;
            }
            if ((n4 & 4) != 0) {
                n3 = waystoneData.z;
            }
            if ((n4 & 8) != 0) {
                string = waystoneData.name;
            }
            if ((n4 & 0x10) != 0) {
                resourceLocation = waystoneData.type;
            }
            if ((n4 & 0x20) != 0) {
                uUID = waystoneData.id;
            }
            return waystoneData.copy(n, n2, n3, string, resourceLocation, uUID);
        }

        @NotNull
        public String toString() {
            return "WaystoneData(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", name=" + this.name + ", type=" + this.type + ", id=" + this.id + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.x);
            result = result * 31 + Integer.hashCode(this.y);
            result = result * 31 + Integer.hashCode(this.z);
            result = result * 31 + this.name.hashCode();
            result = result * 31 + this.type.hashCode();
            result = result * 31 + this.id.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WaystoneData)) {
                return false;
            }
            WaystoneData waystoneData = (WaystoneData)other;
            if (this.x != waystoneData.x) {
                return false;
            }
            if (this.y != waystoneData.y) {
                return false;
            }
            if (this.z != waystoneData.z) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)waystoneData.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.type, (Object)waystoneData.type)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.id, (Object)waystoneData.id);
        }
    }
}

