/*
 * Decompiled with CFR 0.152.
 */
package dev.alinco8.xmxw;

import com.google.gson.Gson;
import dev.alinco8.xmxw.XMXWClient;
import dev.alinco8.xmxw.config.XMXWConfig;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.SharedConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\rB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\n\u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ldev/alinco8/xmxw/UpdateChecker;", "", "<init>", "()V", "MODRINTH_ID", "", "client", "Ljava/net/http/HttpClient;", "gson", "Lcom/google/gson/Gson;", "fetchLatestVersion", "checkUpdate", "currentVersion", "URIBuilder", "xmxw"})
public final class UpdateChecker {
    @NotNull
    public static final UpdateChecker INSTANCE = new UpdateChecker();
    @NotNull
    public static final String MODRINTH_ID = "iv2jCzkP";
    @NotNull
    private static final HttpClient client;
    @NotNull
    private static final Gson gson;

    private UpdateChecker() {
    }

    private final String fetchLatestVersion() {
        URI uri = new URIBuilder().url("https://api.modrinth.com/v2/project/iv2jCzkP/version").query("loaders", CollectionsKt.listOf((Object)"neoforge")).query("game_versions", CollectionsKt.listOf((Object)SharedConstants.getCurrentVersion().getName())).build();
        HttpRequest request = HttpRequest.newBuilder(uri).GET().build();
        try {
            String string;
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            String body = response.body();
            Object[] json = (Object[])gson.fromJson(body, Object[].class);
            XMXWClient.LOGGER.debug("Modrinth version check response: " + body);
            Intrinsics.checkNotNull((Object)json);
            Object object = ArraysKt.firstOrNull((Object[])json);
            if (object != null) {
                Object it = object;
                boolean bl = false;
                string = gson.toJsonTree(it).getAsJsonObject().get("version_number").getAsString();
            } else {
                string = null;
            }
            return string;
        }
        catch (Exception e) {
            XMXWClient.LOGGER.error("Could not fetch latest version from Modrinth", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public final String checkUpdate(@NotNull String currentVersion) {
        Intrinsics.checkNotNullParameter((Object)currentVersion, (String)"currentVersion");
        if (((XMXWConfig)XMXWConfig.Companion.getHANDLER().instance()).getDisableUpdateCheck()) {
            return null;
        }
        String string = this.fetchLatestVersion();
        if (string != null) {
            String latestVersion = string;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)currentVersion, (Object)latestVersion)) {
                XMXWClient.LOGGER.info("New version available: " + latestVersion + " (current: " + currentVersion + ")");
                return latestVersion;
            }
        }
        XMXWClient.LOGGER.debug("No new version available (current: " + currentVersion + ")");
        return null;
    }

    static {
        HttpClient httpClient = HttpClient.newHttpClient();
        Intrinsics.checkNotNullExpressionValue((Object)httpClient, (String)"newHttpClient(...)");
        client = httpClient;
        gson = new Gson();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u0018\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u0001J\u0006\u0010\u000b\u001a\u00020\fR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ldev/alinco8/xmxw/UpdateChecker$URIBuilder;", "", "<init>", "()V", "url", "", "queries", "", "query", "key", "value", "build", "Ljava/net/URI;", "xmxw"})
    @SourceDebugExtension(value={"SMAP\nUpdateChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateChecker.kt\ndev/alinco8/xmxw/UpdateChecker$URIBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n1#2:113\n*E\n"})
    public static final class URIBuilder {
        @Nullable
        private String url;
        @NotNull
        private final Map<String, Object> queries = new LinkedHashMap();

        @NotNull
        public final URIBuilder url(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.url = url;
            return this;
        }

        @NotNull
        public final URIBuilder query(@NotNull String key, @Nullable Object value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.queries.put(key, value);
            return this;
        }

        @NotNull
        public final URI build() {
            boolean bl;
            boolean bl2 = bl = this.url != null;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "URL must be set before building URI";
                throw new AssertionError((Object)string);
            }
            String queryString = CollectionsKt.joinToString$default((Iterable)this.queries.entrySet(), (CharSequence)"&", (CharSequence)"?", null, (int)0, null, URIBuilder::build$lambda$1, (int)28, null);
            String string = this.url;
            Intrinsics.checkNotNull((Object)string);
            URI uRI = URI.create(string + queryString);
            Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
            return uRI;
        }

        private static final CharSequence build$lambda$1(Map.Entry it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getKey() + "=" + URLEncoder.encode(gson.toJson(it.getValue()), StandardCharsets.UTF_8);
        }
    }
}

