/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import xaero.lib.client.gui.widget.Tooltip;
import xaero.map.gui.TooltipButton;

public class GuiTexturedButton
extends TooltipButton {
    protected int textureX;
    protected int textureY;
    protected int textureW;
    protected int textureH;
    protected ResourceLocation texture;

    public GuiTexturedButton(int x, int y, int w, int h, int textureX, int textureY, int textureW, int textureH, ResourceLocation texture, Button.OnPress onPress, Supplier<Tooltip> tooltip) {
        super(x, y, w, h, (Component)Component.literal((String)""), onPress, tooltip);
        this.textureX = textureX;
        this.textureY = textureY;
        this.textureW = textureW;
        this.textureH = textureH;
        this.texture = texture;
    }

    public Component getMessage() {
        if (this.tooltipSupplier != null) {
            return Component.literal((String)((Tooltip)this.tooltipSupplier.get()).getPlainText());
        }
        return super.getMessage();
    }

    public void renderWidget(GuiGraphics guiGraphics, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
        int iconX = this.getX() + this.width / 2 - this.textureW / 2;
        int iconY = this.getY() + this.height / 2 - this.textureH / 2;
        if (this.active) {
            if (this.isHovered) {
                --iconY;
                RenderSystem.setShaderColor((float)0.9f, (float)0.9f, (float)0.9f, (float)1.0f);
            } else {
                RenderSystem.setShaderColor((float)0.9882f, (float)0.9882f, (float)0.9882f, (float)1.0f);
            }
        } else {
            RenderSystem.setShaderColor((float)0.25f, (float)0.25f, (float)0.25f, (float)1.0f);
        }
        if (this.isFocused()) {
            guiGraphics.fill(iconX, iconY, iconX + this.textureW, iconY + this.textureH, 0x55FFFFFF);
        }
        guiGraphics.blit(this.texture, iconX, iconY, this.textureX, this.textureY, this.textureW, this.textureH);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

