/*
 * Decompiled with CFR 0.152.
 */
package net.foxy.xaerotrainmap;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.compat.trainmap.TrainMapManager;
import com.simibubi.create.compat.trainmap.TrainMapSyncClient;
import com.simibubi.create.foundation.gui.RemovedGuiUtils;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.client.event.InputEvent;
import xaero.map.gui.GuiMap;

public class TrainMap {
    private static boolean requesting;

    public static void tick() {
        if (!((Boolean)AllConfigs.client().showTrainMapOverlay.get()).booleanValue() || !(Minecraft.getInstance().screen instanceof GuiMap)) {
            if (requesting) {
                TrainMapSyncClient.stopRequesting();
            }
            requesting = false;
            return;
        }
        TrainMapManager.tick();
        requesting = true;
        TrainMapSyncClient.requestData();
    }

    public static void mouseClick(InputEvent.MouseButton.Pre event) {
        Minecraft mc = Minecraft.getInstance();
        Screen screen = mc.screen;
        if (!(screen instanceof GuiMap)) {
            return;
        }
        GuiMap screen2 = (GuiMap)screen;
        Window window = mc.getWindow();
        double mX = mc.mouseHandler.xpos() * (double)window.getGuiScaledWidth() / (double)window.getScreenWidth();
        double mY = mc.mouseHandler.ypos() * (double)window.getGuiScaledHeight() / (double)window.getScreenHeight();
        if (TrainMapManager.handleToggleWidgetClick((int)Mth.floor((double)mX), (int)Mth.floor((double)mY), (int)3, (int)30)) {
            event.setCanceled(true);
        }
    }

    public static void onRender(Screen screen, GuiGraphics graphics, int mX, int mY, float pt, double mapScale, double x, double z, int mPosX, int mPosZ) {
        if (!((Boolean)AllConfigs.client().showTrainMapOverlay.get()).booleanValue()) {
            TrainMap.renderToggleWidgetAndTooltip(graphics, screen, mX, mY);
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        Window window = mc.getWindow();
        double guiScale = (double)window.getScreenWidth() / (double)window.getGuiScaledWidth();
        double scale = mapScale / guiScale;
        PoseStack pose = graphics.pose();
        pose.pushPose();
        pose.translate((float)screen.width / 2.0f, (float)screen.height / 2.0f, 0.0f);
        pose.scale((float)scale, (float)scale, 1.0f);
        pose.translate(-x, -z, 0.0);
        Rect2i bounds = new Rect2i(Mth.floor((double)((double)((float)(-screen.width) / 2.0f) / scale + x)), Mth.floor((double)((double)((float)(-screen.height) / 2.0f) / scale + z)), Mth.floor((double)((double)screen.width / scale)), Mth.floor((double)((double)screen.height / scale)));
        List tooltip = TrainMapManager.renderAndPick((GuiGraphics)graphics, (int)Mth.floor((float)mPosX), (int)Mth.floor((float)mPosZ), (boolean)false, (Rect2i)bounds);
        pose.popPose();
        if (!TrainMap.renderToggleWidgetAndTooltip(graphics, screen, mX, mY) && tooltip != null) {
            RemovedGuiUtils.drawHoveringText((GuiGraphics)graphics, (List)tooltip, (int)mX, (int)mY, (int)screen.width, (int)screen.height, (int)256, (Font)mc.font);
        }
    }

    private static boolean renderToggleWidgetAndTooltip(GuiGraphics graphics, Screen screen, int mouseX, int mouseY) {
        TrainMapManager.renderToggleWidget((GuiGraphics)graphics, (int)3, (int)30);
        if (!TrainMapManager.isToggleWidgetHovered((int)mouseX, (int)mouseY, (int)3, (int)30)) {
            return false;
        }
        RemovedGuiUtils.drawHoveringText((GuiGraphics)graphics, List.of(Component.translatable((String)"create.train_map.toggle")), (int)mouseX, (int)(mouseY + 20), (int)screen.width, (int)screen.height, (int)256, (Font)Minecraft.getInstance().font);
        return true;
    }
}

