/*
 * Decompiled with CFR 0.152.
 */
package net.velleagle.warfare_wings.entity.bullet;

import immersive_aircraft.config.Config;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WWFGBombUSEntity
extends PrimedTnt {
    private static final Logger LOGGER = LoggerFactory.getLogger(WWFGBombUSEntity.class);
    public static final float EXPLOSION_POWER = 10.0f;
    private static final int MAX_LIFETIME = 600;
    private static final double TORPEDO_SPEED = 1.0;
    private static final double DEPTH_FACTOR = 0.1;
    private boolean hasEnteredWater = false;
    private double dropHeight = 0.0;
    private double targetDepth = 0.0;
    private Vec3 torpedoDirection = Vec3.ZERO;
    private int tickCount = 0;
    private boolean initialized = false;
    private float targetYaw = 0.0f;
    private float targetPitch = 0.0f;
    private boolean rotationLocked = false;

    public WWFGBombUSEntity(EntityType entityType, Level level) {
        super(entityType, level);
    }

    public void tick() {
        this.baseTick();
        ++this.tickCount;
        if (!this.initialized) {
            this.dropHeight = this.getY();
            Vec3 motion = this.getDeltaMovement();
            this.torpedoDirection = new Vec3(motion.x, 0.0, motion.z).normalize();
            this.initialized = true;
        }
        if (this.tickCount > 600) {
            this.discard();
            if (!this.level().isClientSide) {
                LOGGER.info("Torpedo exploding due to timeout");
                this.boom();
            }
            return;
        }
        boolean wasInWater = this.hasEnteredWater;
        boolean inWater = this.isInWater();
        if (inWater && !wasInWater) {
            this.hasEnteredWater = true;
            double heightDifference = this.dropHeight - this.getY();
            this.targetDepth = this.getY() - heightDifference * 0.1;
            Vec3 motion = this.getDeltaMovement();
            if (!motion.equals((Object)Vec3.ZERO)) {
                this.targetYaw = (float)(Math.atan2(motion.z, motion.x) * 180.0 / Math.PI) - 90.0f;
                this.targetPitch = -10.0f;
                this.rotationLocked = true;
            }
            LOGGER.info("Torpedo entered water. Drop height: {}, Target depth: {}", (Object)this.dropHeight, (Object)this.targetDepth);
        }
        if (inWater && this.hasEnteredWater) {
            this.handleUnderwaterMovement();
        } else {
            this.handleAirMovement();
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        Vec3 motion = this.getDeltaMovement();
        if (!motion.equals((Object)Vec3.ZERO)) {
            if (inWater && this.hasEnteredWater && this.rotationLocked) {
                float yawDiff;
                if (this.getY() <= this.targetDepth) {
                    this.targetPitch = 0.0f;
                }
                float currentYaw = this.getYRot();
                float currentPitch = this.getXRot();
                for (yawDiff = this.targetYaw - currentYaw; yawDiff > 180.0f; yawDiff -= 360.0f) {
                }
                while (yawDiff < -180.0f) {
                    yawDiff += 360.0f;
                }
                float newYaw = currentYaw + yawDiff * 0.3f;
                float newPitch = currentPitch + (this.targetPitch - currentPitch) * 0.3f;
                this.setYRot(newYaw);
                this.setXRot(newPitch);
            } else {
                float yaw = (float)(Math.atan2(motion.z, motion.x) * 180.0 / Math.PI) - 90.0f;
                float pitch = (float)(-(Math.atan2(motion.y, Math.sqrt(motion.x * motion.x + motion.z * motion.z)) * 180.0 / Math.PI));
                this.setYRot(yaw);
                this.setXRot(pitch);
            }
        }
        if (this.horizontalCollision || this.verticalCollision) {
            this.discard();
            if (!this.level().isClientSide) {
                LOGGER.info("Torpedo exploding due to collision at {}, {}, {}", new Object[]{this.getX(), this.getY(), this.getZ()});
                this.boom();
            }
            return;
        }
        if (this.level().isClientSide && inWater) {
            for (int i = 0; i < 3; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, this.getX() + (this.random.nextDouble() - 0.5) * 0.5, this.getY() + (this.random.nextDouble() - 0.5) * 0.5, this.getZ() + (this.random.nextDouble() - 0.5) * 0.5, 0.0, 0.0, 0.0);
            }
        }
        if (this.level().isClientSide && !inWater) {
            this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY() + 0.5, this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    private void handleAirMovement() {
        Vec3 motion = this.getDeltaMovement();
        if (!this.isNoGravity()) {
            motion = motion.add(0.0, -0.08, 0.0);
            double maxFallSpeed = -1.2;
            if (motion.y < maxFallSpeed) {
                motion = new Vec3(motion.x, maxFallSpeed, motion.z);
            }
        }
        motion = motion.scale(0.98);
        this.setDeltaMovement(motion);
    }

    private void handleUnderwaterMovement() {
        double currentY = this.getY();
        double verticalSpeed = currentY > this.targetDepth ? -0.15 : 0.02;
        if (this.torpedoDirection.equals((Object)Vec3.ZERO)) {
            Vec3 currentMotion = this.getDeltaMovement();
            this.torpedoDirection = new Vec3(currentMotion.x, 0.0, currentMotion.z).normalize();
        }
        Vec3 newMotion = this.torpedoDirection.scale(1.0);
        newMotion = new Vec3(newMotion.x, verticalSpeed, newMotion.z);
        newMotion = newMotion.scale(0.98);
        this.setDeltaMovement(newMotion);
    }

    private void boom() {
        Level level;
        if (this.level().isClientSide) {
            LOGGER.warn("boom() called on client side - this should not happen!");
            return;
        }
        double x = this.getX();
        double y = this.getY(0.0625);
        double z = this.getZ();
        boolean isDestructive = Config.getInstance().weaponsAreDestructive;
        boolean isUnderwater = this.isInWater();
        LOGGER.info("Torpedo exploding at {}, {}, {}. Destructive: {}, Underwater: {}", new Object[]{x, y, z, isDestructive, isUnderwater});
        if (isUnderwater && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LOGGER.info("Attempting underwater explosion with water removal");
            int radius = 11;
            ArrayList<BlockPos> waterPositions = new ArrayList<BlockPos>();
            int waterCount = 0;
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dy = -radius; dy <= radius; ++dy) {
                    for (int dz = -radius; dz <= radius; ++dz) {
                        BlockPos pos = new BlockPos((int)Math.floor(x) + dx, (int)Math.floor(y) + dy, (int)Math.floor(z) + dz);
                        BlockState state = serverLevel.getBlockState(pos);
                        if (!state.is(Blocks.WATER) && !(state.getBlock() instanceof LiquidBlock)) continue;
                        waterPositions.add(pos.immutable());
                        serverLevel.setBlock(pos, Blocks.AIR.defaultBlockState(), 18);
                        ++waterCount;
                    }
                }
            }
            LOGGER.info("Removed {} water blocks", (Object)waterCount);
            Explosion explosion = serverLevel.explode((Entity)this, x, y, z, 10.0f, Level.ExplosionInteraction.TNT);
            LOGGER.info("Explosion created. Affected blocks: {}", (Object)(explosion != null ? explosion.getToBlow().size() : 0));
            this.spawnExplosionParticles(serverLevel, x, y, z, true);
            ArrayList finalWaterPositions = new ArrayList(waterPositions);
            serverLevel.getServer().execute(() -> {
                try {
                    Thread.sleep(1000L);
                    serverLevel.getServer().execute(() -> {
                        int restoredCount = 0;
                        for (BlockPos pos : finalWaterPositions) {
                            if (!serverLevel.getBlockState(pos).isAir()) continue;
                            serverLevel.setBlock(pos, Blocks.WATER.defaultBlockState(), 3);
                            ++restoredCount;
                        }
                        LOGGER.info("Restored {} water blocks", (Object)restoredCount);
                    });
                }
                catch (InterruptedException e) {
                    LOGGER.error("Water restoration interrupted", (Throwable)e);
                }
            });
        } else {
            LOGGER.info("Performing normal explosion");
            Explosion explosion = this.level().explode((Entity)this, x, y, z, 10.0f, isDestructive ? Level.ExplosionInteraction.TNT : Level.ExplosionInteraction.BLOCK);
            LOGGER.info("Normal explosion created. Affected blocks: {}", (Object)(explosion != null ? explosion.getToBlow().size() : 0));
            Level level2 = this.level();
            if (level2 instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level2;
                this.spawnExplosionParticles(serverLevel, x, y, z, isUnderwater);
            }
        }
    }

    private void spawnExplosionParticles(ServerLevel level, double x, double y, double z, boolean underwater) {
        double offsetZ;
        double offsetY;
        double offsetX;
        int i;
        LOGGER.info("Spawning explosion particles at {}, {}, {}. Underwater: {}", new Object[]{x, y, z, underwater});
        int baseCount = 50;
        for (i = 0; i < baseCount; ++i) {
            offsetX = (this.random.nextDouble() - 0.5) * 10.0;
            offsetY = this.random.nextDouble() * 5.0;
            offsetZ = (this.random.nextDouble() - 0.5) * 10.0;
            level.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, x + offsetX, y + offsetY, z + offsetZ, 5, 0.5, 0.5, 0.5, 0.0);
        }
        for (i = 0; i < baseCount * 3; ++i) {
            offsetX = (this.random.nextDouble() - 0.5) * 12.0;
            offsetY = this.random.nextDouble() * 6.0;
            offsetZ = (this.random.nextDouble() - 0.5) * 12.0;
            level.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, x + offsetX, y + offsetY, z + offsetZ, 10, 0.5, 0.5, 0.5, 0.1);
        }
        for (i = 0; i < baseCount * 2; ++i) {
            offsetX = (this.random.nextDouble() - 0.5) * 15.0;
            offsetY = this.random.nextDouble() * 7.0;
            offsetZ = (this.random.nextDouble() - 0.5) * 15.0;
            level.sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, x + offsetX, y + offsetY, z + offsetZ, 20, 0.3, 0.3, 0.3, 0.05);
        }
        for (i = 0; i < baseCount * 2; ++i) {
            offsetX = (this.random.nextDouble() - 0.5) * 8.0;
            offsetY = this.random.nextDouble() * 4.0;
            offsetZ = (this.random.nextDouble() - 0.5) * 8.0;
            level.sendParticles((ParticleOptions)ParticleTypes.FLAME, x + offsetX, y + offsetY, z + offsetZ, 10, 0.5, 0.5, 0.5, 0.1);
        }
        if (underwater) {
            for (i = 0; i < baseCount * 4; ++i) {
                offsetX = (this.random.nextDouble() - 0.5) * 12.0;
                offsetY = this.random.nextDouble() * 6.0;
                offsetZ = (this.random.nextDouble() - 0.5) * 12.0;
                level.sendParticles((ParticleOptions)ParticleTypes.BUBBLE, x + offsetX, y + offsetY, z + offsetZ, 20, 0.5, 0.5, 0.5, 0.2);
            }
            for (i = 0; i < baseCount; ++i) {
                offsetX = (this.random.nextDouble() - 0.5) * 10.0;
                offsetY = this.random.nextDouble() * 5.0;
                offsetZ = (this.random.nextDouble() - 0.5) * 10.0;
                level.sendParticles((ParticleOptions)ParticleTypes.BUBBLE_POP, x + offsetX, y + offsetY, z + offsetZ, 10, 0.5, 0.5, 0.5, 0.1);
            }
        }
        LOGGER.info("Explosion particles spawned");
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double renderDistance = 4096.0;
        return distance < renderDistance;
    }
}

