/*
 * Decompiled with CFR 0.152.
 */
package net.velleagle.warfare_wings.entity.bullet;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class WWFBulletEntity
extends AbstractHurtingProjectile {
    private float scale = 0.25f;
    private float damage = 20.0f;

    public WWFBulletEntity(EntityType<? extends WWFBulletEntity> entityType, Level level) {
        super(entityType, level);
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public float getDamage() {
        return this.damage;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    protected void onHitEntity(EntityHitResult result) {
        if (this.canHitEntity(result.getEntity())) {
            result.getEntity().hurt(this.level().damageSources().thrown((Entity)this, this.getOwner()), this.damage);
        }
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!this.level().isClientSide) {
            this.discard();
        }
    }

    public boolean isPickable() {
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        return false;
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double d;
        double d2 = this.getBoundingBox().getSize() * 10.0;
        if (Double.isNaN(d2)) {
            d2 = 10.0;
        }
        return distance < d * (d2 *= 64.0) * (double)this.scale;
    }

    protected boolean canHitEntity(Entity target) {
        if (target.isSpectator() || !target.isAlive() || !target.isPickable()) {
            return false;
        }
        Entity entity = this.getOwner();
        return entity == null || !entity.isPassengerOfSameVehicle(target);
    }

    public void tick() {
        Vec3 motion;
        super.tick();
        if (this.getDeltaMovement().lengthSqr() < 0.1) {
            this.discard();
        }
        if (!(motion = this.getDeltaMovement()).equals((Object)Vec3.ZERO)) {
            float yaw = (float)(Math.atan2(motion.z, motion.x) * 180.0 / Math.PI) - 90.0f;
            float pitch = (float)(-(Math.atan2(motion.y, Math.sqrt(motion.x * motion.x + motion.z * motion.z)) * 180.0 / Math.PI));
            this.setYRot(yaw);
            this.setXRot(pitch);
        }
    }
}

