/*
 * Decompiled with CFR 0.152.
 */
package net.velleagle.warfare_wings.entity.bullet;

import immersive_aircraft.config.Config;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class WWBombUSEntity
extends PrimedTnt {
    public static final float EXPLOSION_POWER = 6.0f;
    private boolean initVelocity = false;

    public WWBombUSEntity(EntityType<? extends PrimedTnt> entityType, Level level) {
        super(entityType, level);
    }

    public void tick() {
        Vec3 motion;
        super.tick();
        if (!this.initVelocity && this.getOwner() != null) {
            Vec3 look = this.getOwner().getLookAngle();
            Vec3 adjusted = new Vec3(look.x, Math.min(0.0, look.y), look.z).normalize();
            this.setDeltaMovement(adjusted.scale(0.3));
            this.initVelocity = true;
        }
        if (!this.isNoGravity()) {
            motion = this.getDeltaMovement();
            double maxFallSpeed = -1.2;
            motion = motion.y + -0.08 < maxFallSpeed ? new Vec3(motion.x, maxFallSpeed, motion.z) : motion.add(0.0, -0.08, 0.0);
            this.setDeltaMovement(motion);
        }
        if (!(motion = this.getDeltaMovement()).equals((Object)Vec3.ZERO)) {
            float yaw = (float)(Math.atan2(motion.z, motion.x) * 180.0 / Math.PI) - 90.0f;
            float pitch = (float)(-(Math.atan2(motion.y, Math.sqrt(motion.x * motion.x + motion.z * motion.z)) * 180.0 / Math.PI));
            this.setYRot(yaw);
            this.setXRot(pitch);
        }
        if (this.onGround()) {
            this.setFuse(0);
        }
        if (this.getFuse() <= 0) {
            this.discard();
            if (!this.level().isClientSide) {
                this.boom();
            }
        } else {
            this.updateInWaterStateAndDoFluidPushing();
            if (this.level().isClientSide) {
                this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY() + 0.5, this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }

    private void boom() {
        this.level().explode((Entity)this, this.getX(), this.getY(0.0625), this.getZ(), 6.0f, Config.getInstance().weaponsAreDestructive ? Level.ExplosionInteraction.TNT : Level.ExplosionInteraction.BLOCK);
        if (this.level().isClientSide) {
            int particleCount = 1500;
            for (int i = 0; i < particleCount; ++i) {
                double offsetX = (this.random.nextDouble() - 0.5) * 6.0;
                double offsetY = this.random.nextDouble() * 3.0;
                double offsetZ = (this.random.nextDouble() - 0.5) * 6.0;
                double speedX = (this.random.nextDouble() - 0.5) * 0.5;
                double speedY = this.random.nextDouble() * 0.5;
                double speedZ = (this.random.nextDouble() - 0.5) * 0.5;
                this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, this.getX() + offsetX, this.getY() + offsetY, this.getZ() + offsetZ, speedX, speedY, speedZ);
            }
        }
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double renderDistance = 4096.0;
        return distance < renderDistance;
    }
}

