/*
 * Decompiled with CFR 0.152.
 */
package net.velleagle.warfare_wings.entity;

import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.AirplaneEntity;
import immersive_aircraft.entity.misc.Trail;
import immersive_aircraft.resources.bbmodel.BBAnimationVariables;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.velleagle.warfare_wings.WarfareWings;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class KI84Scheme3Entity
extends AirplaneEntity {
    private float powerTime = 0.0f;
    private static final float POWER_THRESHOLD_TIME = 5.0f;
    private float GearState;
    private final List<Trail> trails = List.of(new Trail(40), new Trail(40));

    public KI84Scheme3Entity(EntityType<? extends AircraftEntity> entityType, Level world) {
        super(entityType, world, true);
    }

    public List<Trail> getTrails() {
        return this.trails;
    }

    protected void trail(Matrix4f transform, int index, float x, float y, float z) {
        Vector4f p0 = this.transformPosition(transform, x, y - 0.15f, z);
        Vector4f p1 = this.transformPosition(transform, x, y + 0.15f, z);
        float trailStrength = Math.max(0.0f, Math.min(1.0f, (float)(Math.sqrt(this.getDeltaMovement().length()) * (double)(0.5f + this.pressingInterpolatedX.getSmooth() * x * 0.025f) - 0.25)));
        this.getTrails().get(index).add(p0, p1, trailStrength);
    }

    public Item asItem() {
        return WarfareWings.KI84_SCHEME3_ITEM.get();
    }

    public void tick() {
        super.tick();
        float enginePower = this.getEnginePower();
        float powerThreshold = 0.7f;
        this.powerTime = enginePower > powerThreshold ? (this.powerTime += 0.05f) : 0.0f;
        this.GearState = this.powerTime >= 5.0f ? 0.0f : 1.0f;
        if (this.level().isClientSide) {
            if (this.isWithinParticleRange()) {
                Matrix4f transform = this.getVehicleTransform();
                Matrix3f normalTransform = this.getVehicleNormalTransform();
                this.trail(transform, 0, -5.03f, 1.7f, -0.7f);
                this.trail(transform, 1, 5.03f, 1.7f, -0.7f);
                float power = this.getEnginePower();
                if ((double)power > 0.05) {
                    int i = 0;
                    while ((float)i < 1.0f + this.engineSpinUpStrength * 4.0f) {
                        Vector4f p = this.transformPosition(transform, 0.64f * (this.tickCount % 2 == 0 ? -1.0f : 1.0f), 1.95f, 0.39f);
                        Vector3f vel = this.transformVector(normalTransform, 0.2f * (this.tickCount % 2 == 0 ? -1.0f : 1.0f), 0.0f, 0.0f);
                        Vec3 velocity = this.getDeltaMovement();
                        if ((double)this.random.nextFloat() < (double)this.engineSpinUpStrength * 0.1) {
                            vel.mul(0.5f);
                            this.level().addParticle((ParticleOptions)ParticleTypes.SMALL_FLAME, (double)p.x(), (double)p.y(), (double)p.z(), (double)vel.x() + velocity.x, (double)vel.y() + velocity.y, (double)vel.z() + velocity.z);
                        } else {
                            this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)p.x, (double)p.y, (double)p.z, (double)vel.x + velocity.x, (double)vel.y + velocity.y, (double)vel.z + velocity.z);
                        }
                        ++i;
                    }
                }
            } else {
                this.trails.get(0).add(new Vector4f(0.0f, 0.0f, 0.0f, 0.0f), new Vector4f(0.0f, 0.0f, 0.0f, 0.0f), 0.0f);
                this.trails.get(1).add(new Vector4f(0.0f, 0.0f, 0.0f, 0.0f), new Vector4f(0.0f, 0.0f, 0.0f, 0.0f), 0.0f);
            }
        }
    }

    public double getZoom() {
        return 8.5;
    }

    public void setAnimationVariables(float tickDelta) {
        super.setAnimationVariables(tickDelta);
        BBAnimationVariables.set((String)"gear_state", (float)this.GearState);
    }

    protected float getEngineReactionSpeed() {
        return 100.0f;
    }
}

