/*
 * Decompiled with CFR 0.152.
 */
package net.velleagle.warfare_wings.entity;

import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.AirplaneEntity;
import immersive_aircraft.entity.misc.Trail;
import immersive_aircraft.resources.bbmodel.BBAnimationVariables;
import java.util.List;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.velleagle.warfare_wings.WarfareWings;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector4f;

public class B29Scheme1Entity
extends AirplaneEntity {
    private float powerTime = 0.0f;
    private static final float POWER_THRESHOLD_TIME = 10.0f;
    private float GearState;
    private final List<Trail> trails = List.of(new Trail(40), new Trail(40));

    public B29Scheme1Entity(EntityType<? extends AircraftEntity> entityType, Level world) {
        super(entityType, world, true);
    }

    public List<Trail> getTrails() {
        return this.trails;
    }

    protected void trail(Matrix4f transform, int index, float x, float y, float z) {
        Vector4f p0 = this.transformPosition(transform, x, y - 0.15f, z);
        Vector4f p1 = this.transformPosition(transform, x, y + 0.15f, z);
        float trailStrength = Math.max(0.0f, Math.min(1.0f, (float)(Math.sqrt(this.getDeltaMovement().length()) * (double)(0.5f + this.pressingInterpolatedX.getSmooth() * x * 0.025f) - 0.25)));
        this.getTrails().get(index).add(p0, p1, trailStrength);
    }

    public Item asItem() {
        return WarfareWings.B29_SCHEME1_ITEM.get();
    }

    public void tick() {
        super.tick();
        float enginePower = this.getEnginePower();
        float powerThreshold = 0.7f;
        this.powerTime = enginePower > powerThreshold ? (this.powerTime += 0.05f) : 0.0f;
        this.GearState = this.powerTime >= 10.0f ? 0.0f : 1.0f;
        if (this.level().isClientSide && this.isWithinParticleRange()) {
            Matrix4f transform = this.getVehicleTransform();
            Matrix3f normalTransform = this.getVehicleNormalTransform();
            this.trail(transform, 0, -16.6f, 2.84f, -8.74f);
            this.trail(transform, 1, 16.6f, 2.84f, -8.74f);
        }
    }

    public double getZoom() {
        return 25.5;
    }

    public boolean isWithinParticleRange() {
        return true;
    }

    public void setAnimationVariables(float tickDelta) {
        super.setAnimationVariables(tickDelta);
        BBAnimationVariables.set((String)"gear_state", (float)this.GearState);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        return super.hurt(source, amount);
    }

    protected float getEngineReactionSpeed() {
        return 150.0f;
    }
}

