/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.widgets;

import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.widgets.DebouncedSlider;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class MicAmplificationSlider
extends DebouncedSlider {
    public static final int GAIN_WARNING_THRESHOLD = 10;
    private static final Tooltip GAIN_WARNING = Tooltip.create((Component)Component.translatable((String)"message.voicechat.microphone_gain.warning", (Object[])new Object[]{10}).withStyle(ChatFormatting.RED));

    public MicAmplificationSlider(int xIn, int yIn, int widthIn, int heightIn) {
        super(xIn, yIn, widthIn, heightIn, (Component)Component.empty(), MicAmplificationSlider.gainToValue(VoicechatClient.CLIENT_CONFIG.microphoneGain.get()));
        this.updateMessage();
    }

    protected void updateMessage() {
        long gain = Math.round(MicAmplificationSlider.valueToGain(this.value));
        MutableComponent message = Component.translatable((String)"message.voicechat.microphone_gain", (Object[])new Object[]{gain});
        if (gain > 10L && this.active) {
            message.withStyle(ChatFormatting.RED);
            this.setTooltip(GAIN_WARNING);
        } else {
            this.setTooltip(null);
        }
        this.setMessage((Component)message);
    }

    public void setActive(boolean active) {
        this.active = active;
        this.updateMessage();
    }

    @Override
    public void applyDebounced() {
        VoicechatClient.CLIENT_CONFIG.microphoneGain.set(MicAmplificationSlider.valueToGain(this.value)).save();
    }

    private static double gainToValue(double gain) {
        return (gain - -40.0) / 64.0;
    }

    private static double valueToGain(double value) {
        return value * 64.0 + -40.0;
    }
}

