/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.usefulhats.item;

import de.cech12.usefulhats.CommonLoader;
import de.cech12.usefulhats.UsefulHatsUtils;
import de.cech12.usefulhats.item.AbstractHatItem;
import de.cech12.usefulhats.item.HatArmorMaterials;
import de.cech12.usefulhats.item.IEquipmentChangeListener;
import de.cech12.usefulhats.platform.Services;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class PostmanHatItem
extends AbstractHatItem
implements IEquipmentChangeListener {
    private static final int HUNGER_AMPLIFIER = 0;
    private static final int HUNGER_DURATION = 219;
    private static final int SPEED_DURATION = 219;

    public PostmanHatItem() {
        super(HatArmorMaterials.POSTMAN, PostmanHatItem.rawColorFromRGB(57, 99, 150), Services.CONFIG::getPostmanHatDurability, Services.CONFIG::isPostmanHatDamageEnabled);
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        int enchantmentLevel = CommonLoader.getEnchantmentLevel(stack, (ResourceKey<Enchantment>)Enchantments.EFFICIENCY) + 1;
        tooltip.add((Component)Component.translatable((String)"item.usefulhats.postman_hat.desc.speed", (Object[])new Object[]{UsefulHatsUtils.getRomanNumber(enchantmentLevel, false)}).withStyle(ChatFormatting.BLUE));
        if (Services.CONFIG.isPostmanHatHungerEnabled()) {
            tooltip.add((Component)Component.translatable((String)"item.usefulhats.postman_hat.desc.hunger").withStyle(ChatFormatting.RED));
        }
    }

    public void inventoryTick(@NotNull ItemStack stack, Level level, @NotNull Entity entity, int slot, boolean selectedIndex) {
        if (!level.isClientSide && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!Services.REGISTRY.getEquippedHatItemStacks(livingEntity).contains(stack)) {
                return;
            }
            int speedAmplifier = CommonLoader.getEnchantmentLevel(stack, (ResourceKey<Enchantment>)Enchantments.EFFICIENCY);
            if (this.isEffectCausedByOtherSource(livingEntity, (Holder<MobEffect>)MobEffects.MOVEMENT_SPEED, 219, speedAmplifier)) {
                return;
            }
            if (livingEntity.isSprinting()) {
                if (livingEntity.getEffect(MobEffects.MOVEMENT_SPEED) == null || livingEntity.tickCount % 19 == 0) {
                    this.addEffect(livingEntity, (Holder<MobEffect>)MobEffects.MOVEMENT_SPEED, 219, speedAmplifier);
                }
                if (Services.CONFIG.isPostmanHatHungerEnabled() && !this.isEffectCausedByOtherSource(livingEntity, (Holder<MobEffect>)MobEffects.HUNGER, 219, 0) && (livingEntity.getEffect(MobEffects.HUNGER) == null || livingEntity.tickCount % 19 == 0)) {
                    this.addEffect(livingEntity, (Holder<MobEffect>)MobEffects.HUNGER, 219, 0);
                }
                if (livingEntity.tickCount % 20 == 0) {
                    this.damageHatItemByOne(stack, livingEntity);
                }
            } else {
                this.removeEffect(livingEntity, (Holder<MobEffect>)MobEffects.MOVEMENT_SPEED, 219, speedAmplifier);
                if (Services.CONFIG.isPostmanHatHungerEnabled()) {
                    this.removeEffect(livingEntity, (Holder<MobEffect>)MobEffects.HUNGER, 219, 0);
                }
            }
        }
    }

    @Override
    public void onUnequippedHatItem(LivingEntity entity, ItemStack oldStack) {
        int speedAmplifier = CommonLoader.getEnchantmentLevel(oldStack, (ResourceKey<Enchantment>)Enchantments.EFFICIENCY);
        this.removeEffect(entity, (Holder<MobEffect>)MobEffects.MOVEMENT_SPEED, 219, speedAmplifier);
        if (Services.CONFIG.isPostmanHatHungerEnabled()) {
            this.removeEffect(entity, (Holder<MobEffect>)MobEffects.HUNGER, 219, 0);
        }
    }
}

