/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.registration.surface_rules;

import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import org.jetbrains.annotations.NotNull;
import twilightforest.init.TFBiomes;
import twilightforest.init.TFBlocks;

public class TFSurfaceRules {
    private static final SurfaceRules.RuleSource BEDROCK = TFSurfaceRules.makeStateRule(Blocks.BEDROCK);
    private static final SurfaceRules.RuleSource GRASS_BLOCK = TFSurfaceRules.makeStateRule(Blocks.GRASS_BLOCK);
    private static final SurfaceRules.RuleSource DIRT = TFSurfaceRules.makeStateRule(Blocks.DIRT);
    private static final SurfaceRules.RuleSource PODZOL = TFSurfaceRules.makeStateRule(Blocks.PODZOL);
    private static final SurfaceRules.RuleSource COARSE_DIRT = TFSurfaceRules.makeStateRule(Blocks.COARSE_DIRT);
    private static final SurfaceRules.RuleSource GRAVEL = TFSurfaceRules.makeStateRule(Blocks.GRAVEL);
    private static final SurfaceRules.RuleSource SAND = TFSurfaceRules.makeStateRule(Blocks.SAND);
    private static final SurfaceRules.RuleSource SANDSTONE = TFSurfaceRules.makeStateRule(Blocks.SANDSTONE);
    private static final SurfaceRules.RuleSource SNOW = TFSurfaceRules.makeStateRule(Blocks.SNOW_BLOCK);
    private static final SurfaceRules.RuleSource WEATHERED_DEADROCK = TFSurfaceRules.makeStateRule((Block)TFBlocks.WEATHERED_DEADROCK.get());
    private static final SurfaceRules.RuleSource CRACKED_DEADROCK = TFSurfaceRules.makeStateRule((Block)TFBlocks.CRACKED_DEADROCK.get());
    private static final SurfaceRules.RuleSource DEADROCK = TFSurfaceRules.makeStateRule((Block)TFBlocks.DEADROCK.get());

    private static SurfaceRules.RuleSource makeStateRule(Block block) {
        return SurfaceRules.state((BlockState)block.defaultBlockState());
    }

    public static SurfaceRules.RuleSource tfSurface() {
        SurfaceRules.RuleSource bedrockLayer = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.verticalGradient((String)"bedrock_floor", (VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.aboveBottom((int)5)), (SurfaceRules.RuleSource)BEDROCK);
        return SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{bedrockLayer, TFSurfaceRules.highlandsSurface(), TFSurfaceRules.deadrockSurface(), TFSurfaceRules.snowyForestSurface(), TFSurfaceRules.glacierSurface(), TFSurfaceRules.overworldLikeFloor()});
    }

    @NotNull
    private static SurfaceRules.RuleSource highlandsSurface() {
        SurfaceRules.RuleSource podzolFloor = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.waterBlockCheck((int)-1, (int)0), (SurfaceRules.RuleSource)PODZOL), DIRT});
        SurfaceRules.RuleSource highlandsSoil = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)TFSurfaceRules.surfaceNoiseAbove(2.25), (SurfaceRules.RuleSource)COARSE_DIRT), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)TFSurfaceRules.surfaceNoiseAbove(-2.25), (SurfaceRules.RuleSource)podzolFloor)}));
        return SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{TFBiomes.HIGHLANDS}), (SurfaceRules.RuleSource)highlandsSoil);
    }

    @NotNull
    private static SurfaceRules.RuleSource deadrockSurface() {
        SurfaceRules.RuleSource deadrockTerrain = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)WEATHERED_DEADROCK), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.waterStartCheck((int)-6, (int)-1), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_FLOOR, (SurfaceRules.RuleSource)CRACKED_DEADROCK)), DEADROCK});
        return SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{TFBiomes.THORNLANDS, TFBiomes.FINAL_PLATEAU}), (SurfaceRules.RuleSource)deadrockTerrain);
    }

    @NotNull
    private static SurfaceRules.RuleSource snowyForestSurface() {
        SurfaceRules.RuleSource snowFloor = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.waterBlockCheck((int)-1, (int)0), (SurfaceRules.RuleSource)SNOW), DIRT});
        SurfaceRules.RuleSource snowySoil = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)snowFloor), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.waterStartCheck((int)-6, (int)-1), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_FLOOR, (SurfaceRules.RuleSource)DIRT))});
        return SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{TFBiomes.SNOWY_FOREST}), (SurfaceRules.RuleSource)snowySoil);
    }

    @NotNull
    private static SurfaceRules.RuleSource glacierSurface() {
        SurfaceRules.RuleSource surfaceUnderPermafrost = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)GRAVEL), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.waterStartCheck((int)-6, (int)-1), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_FLOOR, (SurfaceRules.RuleSource)GRAVEL))});
        return SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{TFBiomes.GLACIER}), (SurfaceRules.RuleSource)surfaceUnderPermafrost);
    }

    @NotNull
    private static SurfaceRules.RuleSource overworldLikeFloor() {
        SurfaceRules.RuleSource riverLakeBeds = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{TFBiomes.LAKE, TFBiomes.STREAM}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_CEILING, (SurfaceRules.RuleSource)SANDSTONE), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.waterBlockCheck((int)-1, (int)0), (SurfaceRules.RuleSource)GRASS_BLOCK), SAND}));
        SurfaceRules.RuleSource swampBeds = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{TFBiomes.SWAMP, TFBiomes.FIRE_SWAMP}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.waterBlockCheck((int)-1, (int)0), (SurfaceRules.RuleSource)GRASS_BLOCK), DIRT}));
        SurfaceRules.RuleSource grassAboveSeaLevel = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.yStartCheck((VerticalAnchor)VerticalAnchor.absolute((int)-4), (int)1), (SurfaceRules.RuleSource)GRASS_BLOCK);
        SurfaceRules.RuleSource grassSurface = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.waterBlockCheck((int)-1, (int)0), (SurfaceRules.RuleSource)grassAboveSeaLevel);
        SurfaceRules.RuleSource underwaterSurface = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.yStartCheck((VerticalAnchor)VerticalAnchor.absolute((int)-4), (int)1)), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.waterBlockCheck((int)-1, (int)0)), (SurfaceRules.RuleSource)DIRT));
        SurfaceRules.RuleSource onFloor = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{riverLakeBeds, swampBeds, grassSurface, underwaterSurface}));
        SurfaceRules.RuleSource underFloor = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.waterStartCheck((int)-6, (int)-1), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.yStartCheck((VerticalAnchor)VerticalAnchor.absolute((int)-4), (int)1), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_FLOOR, (SurfaceRules.RuleSource)DIRT)));
        return SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{onFloor, underFloor});
    }

    private static SurfaceRules.ConditionSource surfaceNoiseAbove(double p_194809_) {
        return SurfaceRules.noiseCondition((ResourceKey)Noises.SURFACE, (double)(p_194809_ / 8.25), (double)Double.MAX_VALUE);
    }
}

