/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;

public interface DecorationClearance {
    public static final String CODEC_NAME = "decoration_clearance";

    public float chunkClearanceRadius();

    public boolean isSurfaceDecorationsAllowed();

    public boolean isUndergroundDecoAllowed();

    public boolean isGrassDecoAllowed();

    public boolean shouldAdjustToTerrain();

    default public int adjustForTerrain(Structure.GenerationContext context, int x, int z) {
        return this.shouldAdjustToTerrain() ? Mth.clamp((int)context.chunkGenerator().getFirstOccupiedHeight(x, z, Heightmap.Types.WORLD_SURFACE_WG, context.heightAccessor(), context.randomState()), (int)(context.chunkGenerator().getSeaLevel() + 1), (int)(context.chunkGenerator().getSeaLevel() + 7)) : context.chunkGenerator().getSeaLevel();
    }

    public record DecorationConfig(float chunkClearanceRadius, boolean surfaceDecorations, boolean undergroundDecorations, boolean vegetation, @Deprecated boolean adjustElevation) {
        public static final Codec<DecorationConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)8.0f).fieldOf("chunk_clearance_radius").orElse((Object)Float.valueOf(1.0f)).forGetter(DecorationConfig::chunkClearanceRadius), (App)Codec.BOOL.fieldOf("allow_biome_surface_decorations").forGetter(DecorationConfig::surfaceDecorations), (App)Codec.BOOL.fieldOf("allow_biome_underground_decorations").forGetter(DecorationConfig::undergroundDecorations), (App)Codec.BOOL.fieldOf("allow_biome_vegetation").forGetter(DecorationConfig::vegetation), (App)Codec.BOOL.fieldOf("adjust_structure_elevation").forGetter(DecorationConfig::adjustElevation)).apply((Applicative)instance, DecorationConfig::new));

        public DecorationConfig(float chunkClearanceRadius, boolean surfaceDecorations, boolean undergroundDecorations, @Deprecated boolean adjustElevation) {
            this(chunkClearanceRadius, surfaceDecorations, undergroundDecorations, true, adjustElevation);
        }
    }
}

