/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import org.jetbrains.annotations.Nullable;
import twilightforest.TFRegistries;
import twilightforest.TwilightForestMod;
import twilightforest.data.tags.BiomeTagGenerator;
import twilightforest.init.TFEntities;
import twilightforest.init.TFMapDecorations;
import twilightforest.init.TFStructureTypes;
import twilightforest.init.custom.StructureSpeleothemConfigs;
import twilightforest.world.components.chunkgenerators.FocusedDensityFunction;
import twilightforest.world.components.chunkgenerators.HollowHillFunction;
import twilightforest.world.components.structures.CustomDensitySource;
import twilightforest.world.components.structures.HydraLairComponent;
import twilightforest.world.components.structures.StructureSpeleothemConfig;
import twilightforest.world.components.structures.util.AdvancementLockedStructure;
import twilightforest.world.components.structures.util.DecorationClearance;
import twilightforest.world.components.structures.util.ProgressionStructure;
import twilightforest.world.components.structures.util.StructureHints;

public class HydraLairStructure
extends ProgressionStructure
implements CustomDensitySource {
    public static final MapCodec<HydraLairStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> HydraLairStructure.progressionCodec(instance).and((App)StructureSpeleothemConfigs.CODEC.fieldOf("speleothem_config").forGetter(s -> s.speleothemConfig)).apply((Applicative)instance, HydraLairStructure::new));
    private final Holder.Reference<StructureSpeleothemConfig> speleothemConfig;

    public HydraLairStructure(AdvancementLockedStructure.AdvancementLockConfig advancementLockConfig, Optional<StructureHints.HintConfig> hintConfig, Optional<DecorationClearance.DecorationConfig> decorationConfig, boolean centerInChunk, Optional<Holder<MapDecorationType>> structureIcon, Structure.StructureSettings structureSettings, Holder<StructureSpeleothemConfig> speleothemConfig) {
        super(advancementLockConfig, hintConfig, decorationConfig, centerInChunk, structureIcon, structureSettings);
        this.speleothemConfig = (Holder.Reference)speleothemConfig;
    }

    @Override
    @Nullable
    protected StructurePiece getFirstPiece(Structure.GenerationContext context, RandomSource random, ChunkPos chunkPos, int x, int y, int z) {
        return new HydraLairComponent(0, x - 7, y, z - 7, this.speleothemConfig);
    }

    public StructureType<?> type() {
        return (StructureType)TFStructureTypes.HYDRA_LAIR.get();
    }

    public static HydraLairStructure buildHydraLairConfig(BootstrapContext<Structure> context) {
        return new HydraLairStructure(new AdvancementLockedStructure.AdvancementLockConfig(List.of(TwilightForestMod.prefix("progress_labyrinth"))), Optional.of(new StructureHints.HintConfig(StructureHints.HintConfig.book("hydralair", 4), (EntityType<? extends Mob>)((EntityType)TFEntities.KOBOLD.get()))), Optional.of(new DecorationClearance.DecorationConfig(2.0f, false, false, false)), true, Optional.of(TFMapDecorations.HYDRA_LAIR), new Structure.StructureSettings((HolderSet)context.lookup(Registries.BIOME).getOrThrow(BiomeTagGenerator.VALID_HYDRA_LAIR_BIOMES), Arrays.stream(MobCategory.values()).collect(Collectors.toMap(category -> category, category -> new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.STRUCTURE, WeightedRandomList.create()))), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE), (Holder<StructureSpeleothemConfig>)context.lookup(TFRegistries.Keys.STRUCTURE_SPELEOTHEM_SETTINGS).getOrThrow(StructureSpeleothemConfigs.HYDRA_LAIR));
    }

    @Override
    public DensityFunction getStructureTerraformer(ChunkPos chunkSliceAt, StructureStart structurePieceSource) {
        int hillSize = 2;
        float radius = 70.4f;
        float radiusInner = 62.4f;
        BoundingBox structureBox = structurePieceSource.getBoundingBox();
        int width = Math.min(structureBox.getXSpan(), structureBox.getZSpan());
        int yCeilingFocus = structureBox.minY();
        BlockPos hillCenter = structureBox.getCenter();
        DensityFunction hillMound = HollowHillFunction.fromPos(hillCenter.atY(yCeilingFocus + 8), 70.4f, 0.7f).clamp(0.0, 1.0);
        DensityFunction innerFloor = DensityFunctions.yClampedGradient((int)-1, (int)0, (double)1.0, (double)-4.0);
        DensityFunction innerCeiling = DensityFunctions.mul((DensityFunction)DensityFunctions.constant((double)-1.0), (DensityFunction)HollowHillFunction.fromPos(hillCenter.atY(yCeilingFocus + 6), 62.4f, 0.675f));
        DensityFunction interior = DensityFunctions.max((DensityFunction)innerCeiling, (DensityFunction)innerFloor);
        FocusedDensityFunction interiorMask = FocusedDensityFunction.fromPos(hillCenter.atY(yCeilingFocus), 32.447998f, -62.4f, 1.0f);
        DensityFunction interiorMasked = DensityFunctions.max((DensityFunction)interiorMask, (DensityFunction)interior);
        DensityFunction hollowHill = DensityFunctions.min((DensityFunction)hillMound, (DensityFunction)interiorMasked);
        DensityFunction maskingSphere = FocusedDensityFunction.fromPos(hillCenter.below(Mth.ceil((double)7.040000152587891)), (float)width * 0.5f + 5.0f, (float)width * 0.25f, 0.0f).clamp(0.0, 1.0);
        DensityFunction cutout = FocusedDensityFunction.fromPos(hillCenter.offset(-16, 0, -16), 23.0f, -23.0f, 0.0f).clamp(-4.0, 0.0);
        DensityFunction hillMasked = DensityFunctions.mul((DensityFunction)maskingSphere, (DensityFunction)hollowHill);
        DensityFunction lair = DensityFunctions.add((DensityFunction)hillMasked, (DensityFunction)DensityFunctions.max((DensityFunction)cutout, (DensityFunction)innerFloor).clamp(-2.0, 0.0));
        return DensityFunctions.mul((DensityFunction)DensityFunctions.constant((double)8.0), (DensityFunction)lair);
    }
}

