/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.markerhandler;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import twilightforest.init.custom.TemplateMarkerHandlers;
import twilightforest.world.components.structures.markerhandler.TemplateMarkerHandler;
import twilightforest.world.components.structures.markerhandler.TemplateMarkerHandlerType;

public record BlockPlaceMarkerHandler(BlockStateProvider provider) implements TemplateMarkerHandler
{
    public static final MapCodec<BlockPlaceMarkerHandler> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockStateProvider.CODEC.fieldOf("block_state").forGetter(BlockPlaceMarkerHandler::provider)).apply((Applicative)instance, BlockPlaceMarkerHandler::new));

    @Override
    public boolean handleDataMarker(String label, BlockPos pos, WorldGenLevel level, RandomSource random, BoundingBox chunkBounds, ChunkGenerator chunkGen, Rotation rotation) {
        BlockState state = this.provider.getState(random, pos).rotate(rotation);
        return level.setBlock(pos, state, 3);
    }

    @Override
    public TemplateMarkerHandlerType getType() {
        return (TemplateMarkerHandlerType)TemplateMarkerHandlers.BLOCK_PLACEMENT.value();
    }
}

