/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import org.jetbrains.annotations.NotNull;
import twilightforest.TFRegistries;
import twilightforest.data.tags.CustomTagGenerator;
import twilightforest.util.woods.WoodPalette;
import twilightforest.world.components.processors.StateTransfiguringProcessor;
import twilightforest.world.components.processors.WoodPaletteSwizzle;

public record SwizzleConfig(HolderSet<WoodPalette> targets, WeightedRandomList<WeightedEntry.Wrapper<HolderSet<WoodPalette>>> paletteChoices, List<ProcessorRule> preprocessingRules) implements FeatureConfiguration
{
    public static final Codec<SwizzleConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryCodecs.homogeneousList(TFRegistries.Keys.WOOD_PALETTES).fieldOf("target_palettes").forGetter(SwizzleConfig::targets), (App)WeightedRandomList.codec((Codec)WeightedEntry.Wrapper.codec((Codec)RegistryCodecs.homogeneousList(TFRegistries.Keys.WOOD_PALETTES))).fieldOf("palette_choices").forGetter(SwizzleConfig::paletteChoices), (App)ProcessorRule.CODEC.listOf().fieldOf("preprocessing_rules").orElseGet(Collections::emptyList).forGetter(SwizzleConfig::preprocessingRules)).apply((Applicative)instance, SwizzleConfig::new));

    @NotNull
    public static WeightedRandomList<WeightedEntry.Wrapper<HolderSet<WoodPalette>>> buildRarityPalette(HolderGetter<WoodPalette> paletteHolders) {
        WeightedEntry.Wrapper common = WeightedEntry.wrap((Object)((HolderSet)paletteHolders.get(CustomTagGenerator.WoodPaletteTagGenerator.COMMON_PALETTES).get()), (int)8);
        WeightedEntry.Wrapper uncommon = WeightedEntry.wrap((Object)((HolderSet)paletteHolders.get(CustomTagGenerator.WoodPaletteTagGenerator.UNCOMMON_PALETTES).get()), (int)4);
        WeightedEntry.Wrapper rare = WeightedEntry.wrap((Object)((HolderSet)paletteHolders.get(CustomTagGenerator.WoodPaletteTagGenerator.RARE_PALETTES).get()), (int)3);
        WeightedEntry.Wrapper treasure = WeightedEntry.wrap((Object)((HolderSet)paletteHolders.get(CustomTagGenerator.WoodPaletteTagGenerator.TREASURE_PALETTES).get()), (int)1);
        return WeightedRandomList.create((WeightedEntry[])new WeightedEntry.Wrapper[]{common, uncommon, rare, treasure});
    }

    public static SwizzleConfig generate(HolderGetter<WoodPalette> paletteHolders, TagKey<WoodPalette> swizzleMask, WeightedRandomList<WeightedEntry.Wrapper<HolderSet<WoodPalette>>> paletteChoices, ProcessorRule ... postProcessingRules) {
        return new SwizzleConfig((HolderSet<WoodPalette>)paletteHolders.getOrThrow(swizzleMask), paletteChoices, List.of(postProcessingRules));
    }

    public void buildAddProcessors(StructurePlaceSettings settings, RandomSource random) {
        if (!this.preprocessingRules().isEmpty()) {
            settings.addProcessor((StructureProcessor)new StateTransfiguringProcessor(this.preprocessingRules()));
        }
        for (Holder targetPalette : this.targets) {
            settings.addProcessor((StructureProcessor)new WoodPaletteSwizzle((Holder<WoodPalette>)targetPalette, (Holder<WoodPalette>)((Holder)((HolderSet)((WeightedEntry.Wrapper)this.paletteChoices().getRandom(random).get()).data()).getRandomElement(random).get())));
        }
    }
}

