/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.util.landmarks;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import twilightforest.advancements.StructureClearedTrigger;
import twilightforest.data.tags.StructureTagGenerator;
import twilightforest.entity.EnforcedHomePoint;
import twilightforest.init.TFAdvancements;
import twilightforest.init.TFGameRules;
import twilightforest.util.landmarks.LegacyLandmarkPlacements;
import twilightforest.world.components.structures.start.TFStructureStart;
import twilightforest.world.components.structures.util.CustomStructureData;

public final class LandmarkUtil {
    public static Optional<StructureStart> locateNearestLandmarkStart(LevelAccessor level, int chunkX, int chunkZ) {
        return LandmarkUtil.locateNearestMatchingLandmark(level, StructureTagGenerator.LANDMARK, chunkX, chunkZ);
    }

    public static Optional<StructureStart> locateNearestMatchingLandmark(LevelAccessor level, TagKey<Structure> matching, int chunkX, int chunkZ) {
        Optional structureRegistry = level.registryAccess().registry(Registries.STRUCTURE);
        if (structureRegistry.isEmpty()) {
            return Optional.empty();
        }
        Optional holders = ((Registry)structureRegistry.get()).getTag(matching);
        if (holders.isEmpty()) {
            return Optional.empty();
        }
        return LandmarkUtil.locateNearestMatchingLandmark(level, (HolderSet<Structure>)((HolderSet)holders.get()), chunkX, chunkZ);
    }

    public static Optional<StructureStart> locateNearestMatchingLandmark(LevelAccessor level, HolderSet<Structure> matching, int chunkX, int chunkZ) {
        Set structures = matching.stream().map(Holder::value).collect(Collectors.toSet());
        return LandmarkUtil.locateNearestMatchingLandmark(level, structures::contains, chunkX, chunkZ, true);
    }

    public static Optional<StructureStart> locateNearestMatchingLandmark(LevelAccessor level, Predicate<Structure> filter, int chunkX, int chunkZ, boolean checkReady) {
        BlockPos nearestFeature = LegacyLandmarkPlacements.getNearestCenterXZ(chunkX, chunkZ);
        int centerX = SectionPos.blockToSectionCoord((int)nearestFeature.getX());
        int centerZ = SectionPos.blockToSectionCoord((int)nearestFeature.getZ());
        if (checkReady && !level.hasChunk(centerX, centerZ)) {
            return Optional.empty();
        }
        ChunkAccess chunkAccess = level.getChunk(centerX, centerZ, ChunkStatus.STRUCTURE_STARTS);
        for (Map.Entry structureEntry : chunkAccess.getAllStarts().entrySet()) {
            if (!filter.test((Structure)structureEntry.getKey())) continue;
            return Optional.of((StructureStart)structureEntry.getValue());
        }
        return Optional.empty();
    }

    public static boolean isConquered(Level level, int blockX, int blockZ) {
        Optional<StructureStart> start = LandmarkUtil.locateNearestMatchingLandmark((LevelAccessor)level, s -> s instanceof CustomStructureData, blockX >> 4, blockZ >> 4, false);
        return start.filter(structureStart -> {
            TFStructureStart tfStructureStart;
            return structureStart instanceof TFStructureStart && (tfStructureStart = (TFStructureStart)((Object)structureStart)).isConquered();
        }).isPresent();
    }

    public static void markStructureConquered(Level level, EnforcedHomePoint mobHome, ResourceKey<Structure> structureKey, boolean conquered) {
        LandmarkUtil.markStructureConquered(level, mobHome.getRestrictionPoint(), structureKey, conquered);
    }

    public static void markStructureConquered(Level level, @Nullable GlobalPos pos, ResourceKey<Structure> structureKey, boolean conquered) {
        if (pos != null && level.dimension() == pos.dimension()) {
            Object object;
            Optional<StructureStart> nearStart = LandmarkUtil.locateNearestLandmarkStart((LevelAccessor)level, structureKey, pos.pos());
            if (nearStart.isEmpty() || !((object = nearStart.get()) instanceof TFStructureStart)) {
                return;
            }
            TFStructureStart twilightStart = (TFStructureStart)((Object)object);
            twilightStart.setConquered(conquered, (LevelAccessor)level);
            for (ServerPlayer player : level.getEntitiesOfClass(ServerPlayer.class, new AABB(pos.pos()).inflate(32.0))) {
                ((StructureClearedTrigger)((Object)TFAdvancements.STRUCTURE_CLEARED.get())).trigger(player, structureKey);
            }
        }
    }

    @Nullable
    public static Structure structureForKey(LevelReader level, ResourceKey<Structure> structureKey) {
        Optional registry = level.registryAccess().registry(Registries.STRUCTURE);
        return registry.isPresent() ? (Structure)((Registry)registry.get()).get(structureKey) : null;
    }

    public static Optional<StructureStart> locateNearestLandmarkStart(LevelAccessor level, ResourceKey<Structure> structureKey, BlockPos pos) {
        return LandmarkUtil.locateNearestLandmarkStart(level, structureKey, SectionPos.blockToSectionCoord((int)pos.getX()), SectionPos.blockToSectionCoord((int)pos.getZ()));
    }

    public static Optional<StructureStart> locateNearestLandmarkStart(LevelAccessor level, ResourceKey<Structure> structureKey, int chunkX, int chunkZ) {
        Structure structure = LandmarkUtil.structureForKey((LevelReader)level, structureKey);
        if (structure == null) {
            return Optional.empty();
        }
        return LandmarkUtil.locateNearestLandmarkStart(level, structure, chunkX, chunkZ);
    }

    public static Optional<StructureStart> locateNearestLandmarkStart(LevelAccessor level, Structure structure, int chunkX, int chunkZ) {
        BlockPos nearestLandmark = LegacyLandmarkPlacements.getNearestCenterXZ(chunkX, chunkZ);
        ChunkAccess chunkAccess = level.getChunk(SectionPos.blockToSectionCoord((int)nearestLandmark.getX()), SectionPos.blockToSectionCoord((int)nearestLandmark.getZ()), ChunkStatus.STRUCTURE_STARTS);
        for (Long packedChunkPos : chunkAccess.getReferencesForStructure(structure)) {
            StructureStart structureStart;
            int packedZ;
            int packedX = ChunkPos.getX((long)packedChunkPos);
            if (!level.hasChunk(packedX, packedZ = ChunkPos.getZ((long)packedChunkPos)) || (structureStart = level.getChunk(packedX, packedZ, ChunkStatus.STRUCTURE_STARTS).getStartForStructure(structure)) == null || !structureStart.isValid()) continue;
            return Optional.of(structureStart);
        }
        return Optional.empty();
    }

    public static boolean isProgressionEnforced(Level world) {
        return world.getGameRules().getBoolean(TFGameRules.ENFORCED_PROGRESSION_RULE.get());
    }

    private LandmarkUtil() {
    }
}

