/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.util.jigsaw;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.Optionull;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.FrontAndTop;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import twilightforest.util.jigsaw.JigsawUtil;

public record JigsawRecord(int priority, FrontAndTop orientation, BlockPos pos, String pool, String name, String target) {
    public static List<JigsawRecord> allFromTemplate(StructureTemplateManager structureManager, ResourceLocation templateLocation, StructurePlaceSettings placeSettings) {
        placeSettings.setMirror(Mirror.NONE);
        return structureManager.getOrCreate(templateLocation).filterBlocks(BlockPos.ZERO, placeSettings, Blocks.JIGSAW).stream().map(JigsawRecord::fromJigsawBlock).toList();
    }

    public static List<JigsawRecord> fromUnprocessedInfos(List<StructureTemplate.StructureBlockInfo> infos, StructurePlaceSettings settings, RandomSource random) {
        ArrayList<JigsawRecord> list = new ArrayList<JigsawRecord>();
        for (StructureTemplate.StructureBlockInfo info : infos) {
            JigsawRecord jigsawRecord = JigsawRecord.fromUnconfiguredJigsaw(info, settings);
            list.add(jigsawRecord);
        }
        Util.shuffle(list, (RandomSource)random);
        list.sort(Comparator.comparingInt(JigsawRecord::priority).reversed());
        return list;
    }

    public static JigsawRecord fromUnconfiguredJigsaw(StructureTemplate.StructureBlockInfo info, StructurePlaceSettings settings) {
        return new JigsawRecord((Integer)Optionull.mapOrDefault((Object)info.nbt(), tag -> tag.getInt("selection_priority"), (Object)0), JigsawUtil.process((FrontAndTop)info.state().getValue((Property)JigsawBlock.ORIENTATION), settings), StructureTemplate.calculateRelativePosition((StructurePlaceSettings)settings, (BlockPos)info.pos()), (String)Optionull.mapOrDefault((Object)info.nbt(), tag -> tag.getString("pool"), (Object)"minecraft:empty"), (String)Optionull.mapOrDefault((Object)info.nbt(), tag -> tag.getString("name"), (Object)""), (String)Optionull.mapOrDefault((Object)info.nbt(), tag -> tag.getString("target"), (Object)""));
    }

    public static JigsawRecord fromJigsawBlock(StructureTemplate.StructureBlockInfo info) {
        return new JigsawRecord((Integer)Optionull.mapOrDefault((Object)info.nbt(), tag -> tag.getInt("selection_priority"), (Object)0), (FrontAndTop)info.state().getValue((Property)JigsawBlock.ORIENTATION), info.pos(), (String)Optionull.mapOrDefault((Object)info.nbt(), tag -> tag.getString("pool"), (Object)"minecraft:empty"), (String)Optionull.mapOrDefault((Object)info.nbt(), tag -> tag.getString("name"), (Object)""), (String)Optionull.mapOrDefault((Object)info.nbt(), tag -> tag.getString("target"), (Object)""));
    }

    public static JigsawRecord fromTag(CompoundTag tag) {
        return new JigsawRecord(tag.getInt("priority"), FrontAndTop.values()[tag.getInt("facing")], new BlockPos(tag.getInt("x"), tag.getInt("y"), tag.getInt("z")), tag.getString("pool"), tag.getString("name"), tag.getString("target"));
    }

    public CompoundTag toTag() {
        CompoundTag ret = new CompoundTag();
        ret.putInt("priority", this.priority);
        ret.putInt("facing", this.orientation.ordinal());
        ret.putInt("x", this.pos.getX());
        ret.putInt("y", this.pos.getY());
        ret.putInt("z", this.pos.getZ());
        ret.putString("pool", this.pool);
        ret.putString("name", this.name);
        ret.putString("target", this.target);
        return ret;
    }
}

