/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.loot;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import twilightforest.components.entity.MultiplayerInclusivityAttachment;
import twilightforest.config.TFConfig;
import twilightforest.init.TFDataAttachments;
import twilightforest.init.TFLoot;

public record MultiplayerBasedNumberProvider(NumberProvider rollsPerPlayer, NumberProvider defaultRolls) implements NumberProvider
{
    public static final MapCodec<MultiplayerBasedNumberProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)NumberProviders.CODEC.fieldOf("per_player_rolls").forGetter(MultiplayerBasedNumberProvider::rollsPerPlayer), (App)NumberProviders.CODEC.fieldOf("default_rolls").forGetter(MultiplayerBasedNumberProvider::defaultRolls)).apply((Applicative)instance, MultiplayerBasedNumberProvider::new));

    public LootNumberProviderType getType() {
        return (LootNumberProviderType)TFLoot.MULTIPLAYER_ROLLS.get();
    }

    public static MultiplayerBasedNumberProvider rollsForPlayers(NumberProvider rollsPerPlayer, NumberProvider defaultRolls) {
        return new MultiplayerBasedNumberProvider(rollsPerPlayer, defaultRolls);
    }

    public float getFloat(LootContext context) {
        if (TFConfig.multiplayerFightAdjuster.adjustsLootRolls() && context.hasParam(LootContextParams.THIS_ENTITY) && ((Entity)context.getParam(LootContextParams.THIS_ENTITY)).hasData(TFDataAttachments.MULTIPLAYER_FIGHT)) {
            int qualifiedPlayers = ((MultiplayerInclusivityAttachment)((Entity)context.getParam(LootContextParams.THIS_ENTITY)).getData(TFDataAttachments.MULTIPLAYER_FIGHT)).getQualifiedPlayers().size();
            float total = this.defaultRolls.getFloat(context);
            for (int i = 0; i < qualifiedPlayers - 1; ++i) {
                total += Math.max(0.0f, this.rollsPerPlayer.getFloat(context));
            }
            return total;
        }
        return this.defaultRolls.getFloat(context);
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return Sets.union((Set)this.rollsPerPlayer.getReferencedContextParams(), (Set)this.defaultRolls.getReferencedContextParams());
    }
}

