/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item.travellers_gear.modifiers;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.item.ItemStack;
import twilightforest.TFRegistries;
import twilightforest.init.custom.TravellersModifiersManager;
import twilightforest.item.travellers_gear.TravellersArmorItem;

public interface TravellersModifier {
    public static final Codec<TravellersModifier> CODEC = TFRegistries.TRAVELLERS_MODIFIER_TYPE.byNameCodec().dispatch(TravellersModifier::codec, Function.identity());

    public MapCodec<? extends TravellersModifier> codec();

    public EquipmentSlotGroup group();

    public boolean hasModifier(ItemStack var1);

    public boolean isAbility();

    default public List<Component> getDescription() {
        return List.of();
    }

    default public String getPrefix() {
        return "travellers_gear.modifier";
    }

    default public boolean isActive(ItemStack stack, ResourceKey<TravellersModifier> modifier) {
        return this.hasModifier(stack) && (!TravellersArmorItem.isTravellersArmorAndBroken(stack) || TravellersModifiersManager.ALWAYS_ACTIVE.contains(modifier));
    }

    public static DataResult<EquipmentSlotGroup> validateEquipment(EquipmentSlotGroup group) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot.isArmor() || !group.test(slot)) continue;
            return DataResult.error(() -> "EquipmentSlotGroup must only use armor slots");
        }
        return DataResult.success((Object)group);
    }
}

