/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item.travellers_gear;

import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import twilightforest.components.item.ItemDisplayContents;
import twilightforest.init.TFDataComponents;
import twilightforest.init.custom.TravellersModifiersManager;
import twilightforest.item.travellers_gear.TravellersArmorItem;

public class TravellersGogglesItem
extends TravellersArmorItem {
    public TravellersGogglesItem(Item.Properties properties) {
        super(ArmorItem.Type.HELMET, properties, 3, 12);
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return !stack.has(DataComponents.HIDE_TOOLTIP) && !stack.has(DataComponents.HIDE_ADDITIONAL_TOOLTIP) ? Optional.ofNullable((ItemDisplayContents)stack.get(TFDataComponents.ITEM_DISPLAY)).map(Tooltip::new) : Optional.empty();
    }

    public boolean overrideStackedOnOther(ItemStack stack, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player) {
        if (stack.getCount() != 1 || action != ClickAction.SECONDARY) {
            return false;
        }
        ItemDisplayContents contents = (ItemDisplayContents)stack.get(TFDataComponents.ITEM_DISPLAY);
        if (contents == null) {
            return false;
        }
        ItemDisplayContents.Mutable mutableContents = new ItemDisplayContents.Mutable(contents);
        ItemStack itemstack = slot.getItem();
        if (itemstack.isEmpty()) {
            ItemStack removedStack = mutableContents.removeFirstFree(slot);
            if (removedStack != null) {
                slot.safeInsert(removedStack);
                this.playRemoveOneSound((Entity)player);
            }
        } else if (itemstack.canFitInsideContainerItems()) {
            if (mutableContents.trySwap(SlotAccess.of(() -> ((Slot)slot).getItem(), arg_0 -> ((Slot)slot).set(arg_0)), player)) {
                this.playInsertSound((Entity)player);
            }
        }
        stack.set(TFDataComponents.ITEM_DISPLAY, (Object)mutableContents.toImmutable());
        return true;
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, @NotNull ItemStack other, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player, @NotNull SlotAccess access) {
        if (stack.getCount() != 1 || action != ClickAction.SECONDARY || !slot.allowModification(player)) {
            return false;
        }
        ItemDisplayContents contents = (ItemDisplayContents)stack.get(TFDataComponents.ITEM_DISPLAY);
        if (contents == null) {
            return false;
        }
        ItemDisplayContents.Mutable mutableContents = new ItemDisplayContents.Mutable(contents);
        if (other.isEmpty()) {
            ItemStack itemstack = mutableContents.removeFirstFree(null);
            if (itemstack != null) {
                this.playRemoveOneSound((Entity)player);
                access.set(itemstack);
            }
        } else if (mutableContents.trySwap(access, player)) {
            this.playInsertSound((Entity)player);
        }
        stack.set(TFDataComponents.ITEM_DISPLAY, (Object)mutableContents.toImmutable());
        return true;
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        ServerPlayer player;
        Packet packet;
        Item item;
        if (slotId != 36 + EquipmentSlot.HEAD.getIndex()) {
            return;
        }
        if (level.isClientSide() || !TravellersModifiersManager.isModifierActive(entity, TravellersModifiersManager.ITEM_DISPLAY_MODIFIER)) {
            return;
        }
        ItemDisplayContents contents = (ItemDisplayContents)stack.get(TFDataComponents.ITEM_DISPLAY);
        if (contents == null || contents.isEmpty()) {
            return;
        }
        int mapSlot = contents.findActiveMapSlot();
        if (mapSlot == -1) {
            return;
        }
        ItemStack map = (ItemStack)contents.items().get(mapSlot);
        if (map.isEmpty() || !((item = map.getItem()) instanceof MapItem)) {
            return;
        }
        MapItem mapItem = (MapItem)item;
        mapItem.inventoryTick(map, level, entity, slotId, true);
        if (entity instanceof ServerPlayer && (packet = mapItem.getUpdatePacket(map, level, (Player)(player = (ServerPlayer)entity))) != null) {
            player.connection.send(packet);
        }
    }

    public boolean isEnderMask(@NotNull ItemStack stack, @NotNull Player player, @NotNull EnderMan enderman) {
        return TravellersModifiersManager.isModifierActive((LivingEntity)player, TravellersModifiersManager.ALL_NIGHT_GOGGLES_MODIFIER);
    }

    private void playRemoveOneSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_REMOVE_ONE, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playInsertSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    public record Tooltip(ItemDisplayContents contents) implements TooltipComponent
    {
    }
}

