/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item.travellers_gear;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import org.jetbrains.annotations.NotNull;
import twilightforest.data.tags.ItemTagGenerator;
import twilightforest.init.TFDataComponents;
import twilightforest.init.TFSounds;
import twilightforest.init.custom.TravellersModifiersManager;
import twilightforest.item.travellers_gear.TravellersArmorItem;

public class TravellersArmorBeltItem
extends TravellersArmorItem {
    public static final ItemContainerContents DEFAULT_EMPTY_BELT_CONTAINER = ItemContainerContents.fromItems((List)NonNullList.withSize((int)9, (Object)ItemStack.EMPTY));

    public TravellersArmorBeltItem(ArmorItem.Type equipmentType, Item.Properties properties, int insertableModifierSlots, int durability) {
        super(equipmentType, properties, insertableModifierSlots, durability);
    }

    public TravellersArmorBeltItem(ArmorItem.Type equipmentType, Item.Properties properties, int insertableModifierSlots) {
        super(equipmentType, properties, insertableModifierSlots);
    }

    public static Item.Properties beltProperties(Item.Properties properties) {
        return properties.component(TFDataComponents.SWAP_HOTBAR_ABILITY, (Object)Unit.INSTANCE).component(DataComponents.CONTAINER, (Object)DEFAULT_EMPTY_BELT_CONTAINER).component(TFDataComponents.TRAVELLERS_HAS_BELT, (Object)Unit.INSTANCE);
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return !stack.has(DataComponents.HIDE_TOOLTIP) && !stack.has(DataComponents.HIDE_ADDITIONAL_TOOLTIP) ? Optional.ofNullable((ItemContainerContents)stack.get(DataComponents.CONTAINER)).map(Tooltip::new) : Optional.empty();
    }

    public boolean canFitInsideContainerItems() {
        return false;
    }

    public boolean canFitInsideContainerItems(ItemStack stack) {
        return !stack.has(DataComponents.CONTAINER);
    }

    public static void travellersTrySwapHotbar(Player player) {
        ItemStack legArmor = player.getInventory().getArmor(EquipmentSlot.LEGS.getIndex());
        ItemContainerContents containerContents = (ItemContainerContents)legArmor.get(DataComponents.CONTAINER);
        if (!TravellersArmorBeltItem.hasSwapHotbar(player, legArmor) || containerContents == null) {
            return;
        }
        NonNullList hotbarStacks = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
        Inventory inventory = player.getInventory();
        boolean isSwapHotbarActive = TravellersArmorBeltItem.isSwapHotbarActive(player, legArmor);
        boolean hasChanged = false;
        for (int slotIndex = 0; slotIndex < 9; ++slotIndex) {
            ItemStack beltStack;
            ItemStack inventoryStack = inventory.getItem(slotIndex);
            ItemStack itemStack = beltStack = containerContents.getSlots() <= slotIndex ? ItemStack.EMPTY : containerContents.getStackInSlot(slotIndex);
            if (inventoryStack.canFitInsideContainerItems() && !inventoryStack.is(ItemTagGenerator.TRAVELLERS_BELT_BLACKLISTED) && (isSwapHotbarActive || inventoryStack.isEmpty())) {
                hotbarStacks.set(slotIndex, (Object)inventoryStack);
                inventory.setItem(slotIndex, beltStack);
                if (beltStack.equals(inventoryStack)) continue;
                hasChanged = true;
                continue;
            }
            hotbarStacks.set(slotIndex, (Object)beltStack);
        }
        legArmor.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)hotbarStacks));
        if (hasChanged) {
            player.level().playSound(null, (Entity)player, (SoundEvent)TFSounds.SWAP_HOTBAR.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public static boolean isSwapHotbarActive(Player player, ItemStack stack) {
        return (TravellersModifiersManager.isModifierActive((LivingEntity)player, TravellersModifiersManager.SWAP_HOTBAR_MODIFIER) || TravellersModifiersManager.isModifierActive((LivingEntity)player, TravellersModifiersManager.SWAP_HOTBAR_ABILITY)) && stack.has(DataComponents.CONTAINER);
    }

    public static boolean hasSwapHotbar(Player player, ItemStack stack) {
        return (TravellersModifiersManager.hasTravellersModifier((HolderLookup.Provider)player.registryAccess(), stack, TravellersModifiersManager.SWAP_HOTBAR_MODIFIER) || TravellersModifiersManager.hasTravellersModifier((HolderLookup.Provider)player.registryAccess(), stack, TravellersModifiersManager.SWAP_HOTBAR_ABILITY)) && stack.has(DataComponents.CONTAINER);
    }

    public record Tooltip(ItemContainerContents contents) implements TooltipComponent
    {
    }
}

