/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import twilightforest.block.WroughtIronFenceBlock;
import twilightforest.init.TFSounds;

public class WroughtIronFenceItem
extends BlockItem {
    public WroughtIronFenceItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Block block = this.getBlock();
        if (context.isSecondaryUseActive() && level.getBlockState(pos).is(block) && !level.getBlockState(pos.above()).is(block)) {
            boolean capped;
            BlockState state = level.getBlockState(pos);
            boolean bl = capped = state.getValue(WroughtIronFenceBlock.POST) == WroughtIronFenceBlock.PostState.CAPPED;
            if (capped || level.getBlockState(pos.above()).canBeReplaced()) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue(WroughtIronFenceBlock.POST, (Comparable)((Object)(capped ? WroughtIronFenceBlock.makePost((LevelReader)level, state, pos, false) : WroughtIronFenceBlock.PostState.CAPPED))));
            }
            level.playSound(null, pos, (SoundEvent)TFSounds.WROUGHT_IRON_FENCE_EXTENDED.get(), SoundSource.BLOCKS, 0.35f, level.getRandom().nextFloat() * 0.1f + 0.75f);
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }
}

