/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import twilightforest.block.LightableBlock;
import twilightforest.init.TFDataAttachments;
import twilightforest.init.TFSounds;
import twilightforest.network.MovePlayerPacket;
import twilightforest.network.ParticlePacket;
import twilightforest.util.WorldUtil;

public class PeacockFanItem
extends Item {
    public PeacockFanItem(Item.Properties properties) {
        super(properties);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @Nonnull InteractionHand hand) {
        boolean flag;
        ItemStack stack = player.getItemInHand(hand);
        boolean bl = flag = !player.onGround() && !player.isSwimming() && (Boolean)player.getData(TFDataAttachments.FEATHER_FAN) == false;
        if (!level.isClientSide()) {
            int fanned = this.doFan(level, player);
            stack.hurtAndBreak(fanned + 1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            if (flag) {
                player.setData(TFDataAttachments.FEATHER_FAN, (Object)true);
            } else {
                AABB fanBox = this.getEffectAABB(player);
                Vec3 lookVec = player.getLookAngle();
                for (ServerPlayer serverplayer : ((ServerLevel)level).players()) {
                    if (!(serverplayer.distanceToSqr(player.position()) < 4096.0)) continue;
                    ParticlePacket packet = new ParticlePacket();
                    for (int i = 0; i < 30; ++i) {
                        packet.queueParticle((ParticleOptions)ParticleTypes.CLOUD, true, fanBox.minX + (double)level.getRandom().nextFloat() * (fanBox.maxX - fanBox.minX), fanBox.minY + (double)level.getRandom().nextFloat() * (fanBox.maxY - fanBox.minY), fanBox.minZ + (double)level.getRandom().nextFloat() * (fanBox.maxZ - fanBox.minZ), lookVec.x(), lookVec.y(), lookVec.z());
                    }
                    PacketDistributor.sendToPlayer((ServerPlayer)serverplayer, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        } else {
            if (player.isFallFlying()) {
                Vec3 look = player.getLookAngle();
                Vec3 movement = player.getDeltaMovement();
                player.setDeltaMovement(movement.add(look.x() * 0.1 + (look.x() * 2.0 - movement.x()) * 0.5, look.y() * 0.1 + (look.y() * 2.0 - movement.y()) * 0.5 + 1.25, look.z() * 0.1 + (look.z() * 2.0 - movement.z()) * 0.5));
            }
            if (flag) {
                player.setDeltaMovement(new Vec3(player.getDeltaMovement().x() * (double)1.05f, 1.5, player.getDeltaMovement().z() * (double)1.05f));
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        level.playSound(null, player.blockPosition(), (SoundEvent)TFSounds.FAN_WHOOSH.get(), SoundSource.PLAYERS, 1.0f + level.getRandom().nextFloat(), level.getRandom().nextFloat() * 0.7f + 0.3f);
        player.startUsingItem(hand);
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    @Nonnull
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 20;
    }

    private int doFan(Level level, Player player) {
        AABB fanBox = this.getEffectAABB(player);
        return this.fanBlocksInAABB(level, fanBox, player) + this.fanEntitiesInAABB(level, player, fanBox);
    }

    private int fanEntitiesInAABB(Level level, Player player, AABB fanBox) {
        Vec3 moveVec = player.getLookAngle().scale(2.0);
        Item fan = player.getUseItem().getItem();
        int fannedEntities = 0;
        for (Entity entity : level.getEntitiesOfClass(Entity.class, fanBox)) {
            ServerPlayer pushedPlayer;
            if (entity.isPushable() || entity instanceof ItemEntity || entity instanceof Projectile) {
                entity.setDeltaMovement(moveVec.x(), moveVec.y(), moveVec.z());
                ++fannedEntities;
            }
            if (!(entity instanceof ServerPlayer) || (pushedPlayer = (ServerPlayer)entity) == player || pushedPlayer.isShiftKeyDown()) continue;
            PacketDistributor.sendToPlayer((ServerPlayer)pushedPlayer, (CustomPacketPayload)new MovePlayerPacket(moveVec.x(), moveVec.y(), moveVec.z()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            player.getCooldowns().addCooldown(fan, 40);
            fannedEntities += 2;
        }
        return fannedEntities;
    }

    private AABB getEffectAABB(Player player) {
        double range = 3.0;
        double radius = 2.0;
        Vec3 srcVec = new Vec3(player.getX(), player.getY() + (double)player.getEyeHeight(), player.getZ());
        Vec3 lookVec = player.getLookAngle().scale(range);
        Vec3 destVec = srcVec.add(lookVec.x(), lookVec.y(), lookVec.z());
        return new AABB(destVec.x() - radius, destVec.y() - radius, destVec.z() - radius, destVec.x() + radius, destVec.y() + radius, destVec.z() + radius);
    }

    private int fanBlocksInAABB(Level level, AABB box, Player player) {
        int fan = 0;
        for (BlockPos pos : WorldUtil.getAllInBB(box)) {
            fan += this.fanBlock(level, pos, player);
        }
        return fan;
    }

    private int fanBlock(Level level, BlockPos pos, Player player) {
        int cost = 0;
        BlockState state = level.getBlockState(pos);
        if (state.getBlock() instanceof FlowerBlock) {
            if (level.getRandom().nextInt(3) == 0 && !((BlockEvent.BreakEvent)NeoForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(level, pos, state, player))).isCanceled()) {
                level.destroyBlock(pos, true);
                ++cost;
            }
        } else if (state.getBlock() instanceof AbstractCandleBlock && ((Boolean)state.getValue((Property)AbstractCandleBlock.LIT)).booleanValue()) {
            AbstractCandleBlock.extinguish(null, (BlockState)state, (LevelAccessor)level, (BlockPos)pos);
        } else {
            Block block = state.getBlock();
            if (block instanceof LightableBlock) {
                LightableBlock lightable = (LightableBlock)block;
                if (state.getValue(LightableBlock.LIGHTING) == LightableBlock.Lighting.NORMAL || state.getValue(LightableBlock.LIGHTING) == LightableBlock.Lighting.DIM) {
                    lightable.extinguish(null, state, (LevelAccessor)level, pos);
                }
            }
        }
        return cost;
    }
}

