/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;

public class FierySwordItem
extends SwordItem {
    public FierySwordItem(Tier toolMaterial, Item.Properties properties) {
        super(toolMaterial, properties);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        boolean result = super.hurtEnemy(stack, target, attacker);
        if (result && !target.level().isClientSide() && !target.fireImmune()) {
            target.igniteForSeconds(15.0f);
        } else {
            for (int var1 = 0; var1 < 20; ++var1) {
                double px = target.getX() + (double)(target.level().getRandom().nextFloat() * target.getBbWidth() * 2.0f) - (double)target.getBbWidth();
                double py = target.getY() + (double)(target.level().getRandom().nextFloat() * target.getBbHeight());
                double pz = target.getZ() + (double)(target.level().getRandom().nextFloat() * target.getBbWidth() * 2.0f) - (double)target.getBbWidth();
                target.level().addParticle((ParticleOptions)ParticleTypes.FLAME, px, py, pz, 0.02, 0.02, 0.02);
            }
        }
        return result;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".desc")).withStyle(ChatFormatting.GRAY));
    }
}

