/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;

public class FieryPickItem
extends PickaxeItem {
    public FieryPickItem(Tier toolMaterial, Item.Properties properties) {
        super(toolMaterial, properties);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        boolean result = super.hurtEnemy(stack, target, attacker);
        if (result && !target.fireImmune()) {
            if (!target.level().isClientSide()) {
                target.igniteForSeconds(15.0f);
            } else {
                target.level().addParticle((ParticleOptions)ParticleTypes.FLAME, target.getX(), target.getY() + (double)target.getBbHeight() * 0.5, target.getZ(), (double)target.getBbWidth() * 0.5, (double)target.getBbHeight() * 0.5, (double)target.getBbWidth() * 0.5);
            }
        }
        return result;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flags) {
        super.appendHoverText(stack, context, tooltip, flags);
        tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".desc")).withStyle(ChatFormatting.GRAY));
    }
}

