/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.util.FastColor;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import twilightforest.components.entity.PotionFlaskTrackingAttachment;
import twilightforest.components.item.PotionFlaskComponent;
import twilightforest.init.TFDamageTypes;
import twilightforest.init.TFDataAttachments;
import twilightforest.init.TFDataComponents;
import twilightforest.init.TFSounds;

public class BrittleFlaskItem
extends Item {
    public static final int DOSES = 3;

    public BrittleFlaskItem(Item.Properties properties) {
        super(properties);
    }

    public ItemStack getDefaultInstance() {
        ItemStack itemstack = super.getDefaultInstance();
        itemstack.set(TFDataComponents.POTION_FLASK_CONTENTS, (Object)PotionFlaskComponent.EMPTY);
        return itemstack;
    }

    public int getMaxStackSize(ItemStack stack) {
        return ((PotionFlaskComponent)stack.getOrDefault(TFDataComponents.POTION_FLASK_CONTENTS, (Object)PotionFlaskComponent.EMPTY)).potion().potion().isPresent() ? 1 : super.getMaxStackSize(stack);
    }

    public boolean isBarVisible(ItemStack stack) {
        return ((PotionFlaskComponent)stack.getOrDefault(TFDataComponents.POTION_FLASK_CONTENTS, (Object)PotionFlaskComponent.EMPTY)).potion().potion().isPresent();
    }

    public int getBarColor(ItemStack stack) {
        return FastColor.ARGB32.opaque((int)((PotionFlaskComponent)stack.getOrDefault(TFDataComponents.POTION_FLASK_CONTENTS, (Object)PotionFlaskComponent.EMPTY)).potion().getColor());
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        PotionFlaskComponent flaskContents = (PotionFlaskComponent)stack.getOrDefault(TFDataComponents.POTION_FLASK_CONTENTS, (Object)PotionFlaskComponent.EMPTY);
        PotionContents potionContents = (PotionContents)other.get(DataComponents.POTION_CONTENTS);
        if (action == ClickAction.SECONDARY && potionContents != null && (flaskContents.potion().potion().isEmpty() || flaskContents.potion().equals((Object)potionContents)) && flaskContents.doses() < 3 - flaskContents.breakage()) {
            if (!player.getAbilities().instabuild) {
                other.shrink(1);
                if (!player.getInventory().add(new ItemStack((ItemLike)Items.GLASS_BOTTLE))) {
                    player.drop(new ItemStack((ItemLike)Items.GLASS_BOTTLE), false);
                }
            }
            this.changeAndConsumeFlask(stack, player, flask -> flask.update(TFDataComponents.POTION_FLASK_CONTENTS, (Object)flaskContents, component -> component.tryAddDose(potionContents)));
            player.playSound((SoundEvent)TFSounds.FLASK_FILL.get(), (float)(flaskContents.doses() + 1) * 0.25f, player.level().getRandom().nextFloat() * 0.1f + 0.9f);
            return true;
        }
        return false;
    }

    public boolean overrideStackedOnOther(ItemStack stack, Slot slot, ClickAction action, Player player) {
        PotionFlaskComponent flaskContents = (PotionFlaskComponent)stack.getOrDefault(TFDataComponents.POTION_FLASK_CONTENTS, (Object)PotionFlaskComponent.EMPTY);
        ItemStack other = slot.getItem();
        PotionContents potionContents = (PotionContents)other.get(DataComponents.POTION_CONTENTS);
        if (action == ClickAction.SECONDARY && potionContents != null && (flaskContents.potion().potion().isEmpty() || flaskContents.potion().equals((Object)potionContents)) && flaskContents.doses() < 3 - flaskContents.breakage()) {
            if (!player.getAbilities().instabuild) {
                other.shrink(1);
                if (!player.getInventory().add(new ItemStack((ItemLike)Items.GLASS_BOTTLE))) {
                    player.drop(new ItemStack((ItemLike)Items.GLASS_BOTTLE), false);
                }
            }
            this.changeAndConsumeFlask(stack, player, flask -> flask.update(TFDataComponents.POTION_FLASK_CONTENTS, (Object)flaskContents, component -> component.tryAddDose(potionContents)));
            player.playSound((SoundEvent)TFSounds.FLASK_FILL.get(), (float)(flaskContents.doses() + 1) * 0.25f, player.level().getRandom().nextFloat() * 0.1f + 0.9f);
            return true;
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        PotionFlaskComponent flaskContents = (PotionFlaskComponent)stack.getOrDefault(TFDataComponents.POTION_FLASK_CONTENTS, (Object)PotionFlaskComponent.EMPTY);
        if (flaskContents.potion() == PotionContents.EMPTY) {
            return InteractionResultHolder.fail((Object)player.getItemInHand(hand));
        }
        if (flaskContents.doses() > 0) {
            return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)hand);
        }
        return InteractionResultHolder.fail((Object)player.getItemInHand(hand));
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 32;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        PotionFlaskComponent flaskContents = (PotionFlaskComponent)stack.getOrDefault(TFDataComponents.POTION_FLASK_CONTENTS, (Object)PotionFlaskComponent.EMPTY);
        if (flaskContents.potion() != PotionContents.EMPTY && entity instanceof Player) {
            Player player = (Player)entity;
            if (!level.isClientSide()) {
                for (MobEffectInstance mobeffectinstance : flaskContents.potion().getAllEffects()) {
                    if (mobeffectinstance.is(MobEffects.HARM) != entity.isInvertedHealAndHarm() && mobeffectinstance.getAmplifier() > 0) {
                        entity.hurt(entity.damageSources().source(TFDamageTypes.FAILED_CHALLENGE), (float)(6 << mobeffectinstance.getAmplifier()));
                        continue;
                    }
                    if (((MobEffect)mobeffectinstance.getEffect().value()).isInstantenous()) {
                        ((MobEffect)mobeffectinstance.getEffect().value()).applyInstantenousEffect((Entity)player, (Entity)player, (LivingEntity)player, mobeffectinstance.getAmplifier(), 1.0);
                        continue;
                    }
                    player.addEffect(new MobEffectInstance(mobeffectinstance));
                }
                if (!player.isCreative() && !player.isSpectator() && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    flaskContents.potion().potion().ifPresent(potion -> ((PotionFlaskTrackingAttachment)player.getData(TFDataAttachments.FLASK_DOSES)).trackDrink((Holder<Potion>)potion, serverPlayer));
                }
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            if (!player.getAbilities().instabuild) {
                this.changeAndConsumeFlask(stack, player, flask -> flask.update(TFDataComponents.POTION_FLASK_CONTENTS, (Object)flaskContents, component -> {
                    if ((component = component.removeDose()).breakable()) {
                        if (component.breakage() >= 3) {
                            flask.shrink(1);
                            level.playSound(null, (Entity)player, (SoundEvent)TFSounds.BRITTLE_FLASK_BREAK.get(), player.getSoundSource(), 1.5f, 0.7f);
                        } else {
                            level.playSound(null, (Entity)player, (SoundEvent)TFSounds.BRITTLE_FLASK_CRACK.get(), player.getSoundSource(), 1.5f, 2.0f);
                        }
                    }
                    return component;
                }));
            }
        }
        return super.finishUsingItem(stack, level, entity);
    }

    private void changeAndConsumeFlask(ItemStack stack, Player player, Consumer<ItemStack> onDrink) {
        if (stack.getCount() > 1) {
            ItemStack copy = stack.copyWithCount(1);
            stack.shrink(1);
            onDrink.accept(copy);
            if (!player.getInventory().add(copy)) {
                player.drop(copy, false);
            }
        } else {
            onDrink.accept(stack);
        }
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return Optional.of(new Tooltip((PotionFlaskComponent)stack.getOrDefault(TFDataComponents.POTION_FLASK_CONTENTS, (Object)PotionFlaskComponent.EMPTY), 3));
    }

    public int getBarWidth(ItemStack stack) {
        return Math.round(13.0f - (float)Math.abs(((PotionFlaskComponent)stack.getOrDefault(TFDataComponents.POTION_FLASK_CONTENTS, (Object)PotionFlaskComponent.EMPTY)).doses() - 3) * 13.0f / 3.0f);
    }

    public record Tooltip(PotionFlaskComponent component, int maxDoses) implements TooltipComponent
    {
    }
}

