/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.init.custom;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import twilightforest.TFRegistries;
import twilightforest.TwilightForestMod;
import twilightforest.components.item.ItemDisplayContents;
import twilightforest.init.TFAttributeModifiers;
import twilightforest.init.TFDataComponents;
import twilightforest.item.travellers_gear.TravellersArmorBeltItem;
import twilightforest.item.travellers_gear.modifiers.BuiltinTravellersComponentModifier;
import twilightforest.item.travellers_gear.modifiers.InsertableTravellersModifier;
import twilightforest.item.travellers_gear.modifiers.TransferableComponentModifier;
import twilightforest.item.travellers_gear.modifiers.TransferableTravellersModifier;
import twilightforest.item.travellers_gear.modifiers.TravellersComponentModifier;
import twilightforest.item.travellers_gear.modifiers.TravellersEntryModifier;
import twilightforest.item.travellers_gear.modifiers.TravellersModifier;

public class TravellersModifiersManager {
    public static final ResourceKey<TravellersModifier> AUTO_REPAIR_MODIFIER = TravellersModifiersManager.makeKey("auto_repair");
    public static final ResourceKey<TravellersModifier> ZOOM_ABILITY = TravellersModifiersManager.makeKey("zoom");
    public static final ResourceKey<TravellersModifier> AQUATIC_AGILITY_MODIFIER = TravellersModifiersManager.makeKey("aquatic_agility");
    public static final ResourceKey<TravellersModifier> RED_THREAD_VISION_MODIFIER = TravellersModifiersManager.makeKey("red_thread_vision");
    public static final ResourceKey<TravellersModifier> ALL_NIGHT_GOGGLES_MODIFIER = TravellersModifiersManager.makeKey("all_night_goggles");
    public static final ResourceKey<TravellersModifier> ITEM_DISPLAY_MODIFIER = TravellersModifiersManager.makeKey("item_display");
    public static final ResourceKey<TravellersModifier> SWIFT_SWIM_ABILITY = TravellersModifiersManager.makeKey("swift_swim");
    public static final ResourceKey<TravellersModifier> STEALTH_MODIFIER = TravellersModifiersManager.makeKey("stealth");
    public static final ResourceKey<TravellersModifier> ARROW_MAGNETISM_MODIFIER = TravellersModifiersManager.makeKey("arrow_magnetism");
    public static final ResourceKey<TravellersModifier> EFFICIENT_EATER_MODIFIER = TravellersModifiersManager.makeKey("efficient_eater");
    public static final ResourceKey<TravellersModifier> PERFECT_DODGE_MODIFIER = TravellersModifiersManager.makeKey("perfect_dodge");
    public static final ResourceKey<TravellersModifier> HASTE_MODIFIER = TravellersModifiersManager.makeKey("haste");
    public static final ResourceKey<TravellersModifier> SWAP_HOTBAR_ABILITY = TravellersModifiersManager.makeKey("swap_hotbar_ability");
    public static final ResourceKey<TravellersModifier> SWAP_HOTBAR_MODIFIER = TravellersModifiersManager.makeKey("swap_hotbar");
    public static final ResourceKey<TravellersModifier> HIGH_JUMP_ABILITY = TravellersModifiersManager.makeKey("high_jump");
    public static final ResourceKey<TravellersModifier> GRADUAL_GLIDE_MODIFIER = TravellersModifiersManager.makeKey("gradual_glide");
    public static final ResourceKey<TravellersModifier> AGILE_RANGER_MODIFIER = TravellersModifiersManager.makeKey("agile_ranger");
    public static final ResourceKey<TravellersModifier> DOUBLE_JUMP_MODIFIER = TravellersModifiersManager.makeKey("double_jump");
    public static final ResourceKey<TravellersModifier> SIDESTEP_MODIFIER = TravellersModifiersManager.makeKey("side_step");
    public static final ResourceKey<TravellersModifier> STEP_UP_ABILITY = TravellersModifiersManager.makeKey("step_up");
    public static final ResourceKey<TravellersModifier> STRAIGHT_AHEAD_MODIFIER = TravellersModifiersManager.makeKey("straight_ahead");
    public static final ResourceKey<TravellersModifier> SLIMY_SOLES_MODIFIER = TravellersModifiersManager.makeKey("slimy_soles");
    public static final ResourceKey<TravellersModifier> UNRESTRAINED_MODIFIER = TravellersModifiersManager.makeKey("unrestrained");
    public static final ResourceKey<TravellersModifier> WATER_WALK_MODIFIER = TravellersModifiersManager.makeKey("water_walk");
    public static final Set<ResourceKey<TravellersModifier>> ALWAYS_ACTIVE = Set.of(AUTO_REPAIR_MODIFIER);
    private static final Map<ResourceKey<TravellersModifier>, TravellersModifier> CACHED_MODIFIERS = new ConcurrentHashMap<ResourceKey<TravellersModifier>, TravellersModifier>();
    private static final Set<ResourceKey<TravellersModifier>> MISSING_MODIFIERS = ConcurrentHashMap.newKeySet();

    private static ResourceKey<TravellersModifier> makeKey(String name) {
        return ResourceKey.create(TFRegistries.Keys.TRAVELLERS_MODIFIERS, (ResourceLocation)TwilightForestMod.prefix(name));
    }

    public static void bootstrap(BootstrapContext<TravellersModifier> context) {
        context.register(AUTO_REPAIR_MODIFIER, (Object)new TravellersComponentModifier(EquipmentSlotGroup.ARMOR, (DataComponentType)TFDataComponents.AUTO_REPAIR_PROBABILITY.get(), Float.valueOf(0.001f), TravellersModifiersManager.componentText(AUTO_REPAIR_MODIFIER, new Object[0])));
        context.register(ZOOM_ABILITY, (Object)new BuiltinTravellersComponentModifier(EquipmentSlotGroup.HEAD, (DataComponentType)TFDataComponents.ZOOM_ABILITY_MODIFIER.get()));
        context.register(AQUATIC_AGILITY_MODIFIER, (Object)new TravellersEntryModifier(EquipmentSlotGroup.HEAD, List.of(new ItemAttributeModifiers.Entry(Attributes.OXYGEN_BONUS, TFAttributeModifiers.TRAVELLERS_AQUATIC_AGILITY_OXYGEN, EquipmentSlotGroup.HEAD), new ItemAttributeModifiers.Entry(Attributes.SUBMERGED_MINING_SPEED, TFAttributeModifiers.TRAVELLERS_AQUATIC_AGILITY_MINING, EquipmentSlotGroup.HEAD)), (Supplier<DataComponentType<Unit>>)TFDataComponents.AQUATIC_AGILITY, TravellersModifiersManager.componentText(AQUATIC_AGILITY_MODIFIER, new Object[0]), false));
        context.register(RED_THREAD_VISION_MODIFIER, (Object)new TravellersComponentModifier(EquipmentSlotGroup.HEAD, (DataComponentType)TFDataComponents.RED_THREAD_VISION.get(), Unit.INSTANCE, TravellersModifiersManager.componentText(RED_THREAD_VISION_MODIFIER, new Object[0])));
        context.register(ALL_NIGHT_GOGGLES_MODIFIER, (Object)new TravellersComponentModifier(EquipmentSlotGroup.HEAD, (DataComponentType)TFDataComponents.ALL_NIGHT_GOGGLES.get(), Unit.INSTANCE, TravellersModifiersManager.componentText(ALL_NIGHT_GOGGLES_MODIFIER, new Object[0])));
        context.register(ITEM_DISPLAY_MODIFIER, (Object)new TravellersComponentModifier(EquipmentSlotGroup.HEAD, (DataComponentType)TFDataComponents.ITEM_DISPLAY.get(), ItemDisplayContents.EMPTY, TravellersModifiersManager.componentText(ITEM_DISPLAY_MODIFIER, new Object[0])));
        context.register(SWIFT_SWIM_ABILITY, (Object)new TravellersEntryModifier(EquipmentSlotGroup.CHEST, List.of(new ItemAttributeModifiers.Entry(Attributes.WATER_MOVEMENT_EFFICIENCY, TFAttributeModifiers.TRAVELLERS_SWIFT_SWIM, EquipmentSlotGroup.CHEST)), (Supplier<DataComponentType<Unit>>)TFDataComponents.SWIFT_SWIM, true));
        context.register(STEALTH_MODIFIER, (Object)new TravellersComponentModifier(EquipmentSlotGroup.CHEST, (DataComponentType)TFDataComponents.STEALTH_CROUCHING.get(), Unit.INSTANCE, TravellersModifiersManager.componentText(STEALTH_MODIFIER, new Object[0])));
        context.register(ARROW_MAGNETISM_MODIFIER, (Object)new TravellersComponentModifier(EquipmentSlotGroup.CHEST, (DataComponentType)TFDataComponents.ARROW_MAGNETISM.get(), Unit.INSTANCE, TravellersModifiersManager.componentText(ARROW_MAGNETISM_MODIFIER, new Object[0])));
        context.register(EFFICIENT_EATER_MODIFIER, (Object)new TravellersComponentModifier(EquipmentSlotGroup.CHEST, (DataComponentType)TFDataComponents.EFFICIENT_EATER.get(), Float.valueOf(2.0f), TravellersModifiersManager.componentText(EFFICIENT_EATER_MODIFIER, new Object[0])));
        context.register(PERFECT_DODGE_MODIFIER, (Object)new TravellersComponentModifier(EquipmentSlotGroup.CHEST, (DataComponentType)TFDataComponents.PERFECT_DODGE_PROBABILITY.get(), Float.valueOf(0.3f), TravellersModifiersManager.componentText(PERFECT_DODGE_MODIFIER, new Object[0])));
        context.register(HASTE_MODIFIER, (Object)new TravellersComponentModifier(EquipmentSlotGroup.CHEST, (DataComponentType)TFDataComponents.HASTE_AMPLIFIER.get(), 1, TravellersModifiersManager.componentText(HASTE_MODIFIER, new Object[0])));
        context.register(SWAP_HOTBAR_ABILITY, (Object)new BuiltinTravellersComponentModifier(EquipmentSlotGroup.LEGS, (DataComponentType)TFDataComponents.SWAP_HOTBAR_ABILITY.get()));
        context.register(SWAP_HOTBAR_MODIFIER, (Object)new TransferableComponentModifier(EquipmentSlotGroup.LEGS, (DataComponentType<Unit>)((DataComponentType)TFDataComponents.SWAP_HOTBAR_MODIFIER.get()), DataComponents.CONTAINER, TravellersArmorBeltItem.DEFAULT_EMPTY_BELT_CONTAINER, TravellersModifiersManager.componentText(SWAP_HOTBAR_MODIFIER, new Object[0])));
        context.register(HIGH_JUMP_ABILITY, (Object)new BuiltinTravellersComponentModifier(EquipmentSlotGroup.LEGS, (DataComponentType)TFDataComponents.HIGH_JUMP_AMPLIFIER.get()));
        context.register(GRADUAL_GLIDE_MODIFIER, (Object)new TravellersComponentModifier(EquipmentSlotGroup.LEGS, (DataComponentType)TFDataComponents.GRADUALLY_GLIDING_MULTIPLIER.get(), Float.valueOf(0.8333333f), TravellersModifiersManager.componentText(GRADUAL_GLIDE_MODIFIER, new Object[0])));
        context.register(AGILE_RANGER_MODIFIER, (Object)new TravellersComponentModifier(EquipmentSlotGroup.LEGS, (DataComponentType)TFDataComponents.AGILE_RANGER_MODIFIER.get(), Float.valueOf(5.0f), TravellersModifiersManager.componentText(AGILE_RANGER_MODIFIER, new Object[0])));
        context.register(DOUBLE_JUMP_MODIFIER, (Object)new TravellersComponentModifier(EquipmentSlotGroup.LEGS, (DataComponentType)TFDataComponents.DOUBLE_JUMP.get(), Unit.INSTANCE, TravellersModifiersManager.componentText(DOUBLE_JUMP_MODIFIER, new Object[0])));
        context.register(SIDESTEP_MODIFIER, (Object)new TravellersComponentModifier(EquipmentSlotGroup.LEGS, (DataComponentType)TFDataComponents.SIDESTEP_COOLDOWN.get(), 40L, TravellersModifiersManager.componentText(SIDESTEP_MODIFIER, Component.keybind((String)"key.left"), Component.keybind((String)"key.right"))));
        context.register(STEP_UP_ABILITY, (Object)new TravellersEntryModifier(EquipmentSlotGroup.FEET, List.of(new ItemAttributeModifiers.Entry(Attributes.STEP_HEIGHT, TFAttributeModifiers.TRAVELLERS_HIGH_STEP, EquipmentSlotGroup.FEET)), (Supplier<DataComponentType<Unit>>)TFDataComponents.HIGH_STEP, true));
        context.register(STRAIGHT_AHEAD_MODIFIER, (Object)new TravellersComponentModifier(EquipmentSlotGroup.FEET, (DataComponentType)TFDataComponents.STRAIGHT_AHEAD_MULTIPLIER.get(), 1.4, TravellersModifiersManager.componentText(STRAIGHT_AHEAD_MODIFIER, new Object[0])));
        context.register(SLIMY_SOLES_MODIFIER, (Object)new TravellersComponentModifier(EquipmentSlotGroup.FEET, (DataComponentType)TFDataComponents.SLIMY_SOLES_COEFFICIENT.get(), Float.valueOf(0.5f), TravellersModifiersManager.componentText(SLIMY_SOLES_MODIFIER, new Object[0])));
        context.register(UNRESTRAINED_MODIFIER, (Object)new TravellersComponentModifier(EquipmentSlotGroup.FEET, (DataComponentType)TFDataComponents.UNRESTRAINED.get(), Unit.INSTANCE, TravellersModifiersManager.componentText(UNRESTRAINED_MODIFIER, new Object[0])));
        context.register(WATER_WALK_MODIFIER, (Object)new TravellersComponentModifier(EquipmentSlotGroup.FEET, (DataComponentType)TFDataComponents.WATER_WALK.get(), Unit.INSTANCE, TravellersModifiersManager.componentText(WATER_WALK_MODIFIER, new Object[0])));
    }

    private static List<Component> componentText(ResourceKey<TravellersModifier> modifier, Object ... args) {
        return List.of(Component.translatable((String)modifier.location().toLanguageKey("travellers_gear.modifier", "description"), (Object[])args));
    }

    public static boolean isModifierActive(HolderLookup.Provider registries, ItemStack stack, ResourceKey<TravellersModifier> modifierKey) {
        return TravellersModifiersManager.getCachedModifier(registries, modifierKey).map(modifier -> modifier.isActive(stack, modifierKey)).orElse(false);
    }

    public static boolean isModifierActive(Entity entity, ItemStack stack, ResourceKey<TravellersModifier> modifierKey) {
        return TravellersModifiersManager.isModifierActive((HolderLookup.Provider)entity.registryAccess(), stack, modifierKey);
    }

    public static boolean isModifierActive(Entity entity, ResourceKey<TravellersModifier> modifierKey) {
        LivingEntity livingEntity;
        return entity instanceof LivingEntity && TravellersModifiersManager.isModifierActive(livingEntity = (LivingEntity)entity, modifierKey);
    }

    public static boolean isModifierActive(LivingEntity livingEntity, ResourceKey<TravellersModifier> modifierKey) {
        Optional<TravellersModifier> modifier = TravellersModifiersManager.getCachedModifier((HolderLookup.Provider)livingEntity.registryAccess(), modifierKey);
        if (modifier.isEmpty()) {
            return false;
        }
        ItemStack equippedStack = TravellersModifiersManager.getStackForGroup(livingEntity, modifier.get().group());
        return !equippedStack.isEmpty() && modifier.get().isActive(equippedStack, modifierKey);
    }

    public static boolean hasTravellersModifier(HolderLookup.Provider registries, ItemStack stack, ResourceKey<TravellersModifier> modifierKey) {
        return TravellersModifiersManager.getCachedModifier(registries, modifierKey).map(modifier -> modifier.hasModifier(stack)).orElse(false);
    }

    public static boolean addModifier(HolderLookup.Provider registries, ItemStack stack, ResourceKey<TravellersModifier> modifierKey) {
        TravellersModifier travellersModifier;
        Optional<TravellersModifier> modifier = TravellersModifiersManager.getCachedModifier(registries, modifierKey);
        if (modifier.isEmpty() || !((travellersModifier = modifier.get()) instanceof InsertableTravellersModifier)) {
            return false;
        }
        InsertableTravellersModifier insertableTravellersModifier = (InsertableTravellersModifier)travellersModifier;
        return insertableTravellersModifier.addModifier(stack);
    }

    public static boolean transferModifier(HolderLookup.Provider registries, ItemStack stack, List<Ingredient> ingredients, ResourceKey<TravellersModifier> modifierKey) {
        TravellersModifier travellersModifier;
        Optional<TravellersModifier> modifier = TravellersModifiersManager.getCachedModifier(registries, modifierKey);
        if (modifier.isEmpty() || !((travellersModifier = modifier.get()) instanceof TransferableTravellersModifier)) {
            return false;
        }
        TransferableTravellersModifier transferableTravellersModifier = (TransferableTravellersModifier)travellersModifier;
        return transferableTravellersModifier.transfer(stack, ingredients);
    }

    public static int getModifierDataComponentProviders(HolderLookup.Provider registries, List<Ingredient> ingredients, ResourceKey<TravellersModifier> modifierKey) {
        TravellersModifier travellersModifier;
        Optional<TravellersModifier> modifier = TravellersModifiersManager.getCachedModifier(registries, modifierKey);
        if (modifier.isEmpty() || !((travellersModifier = modifier.get()) instanceof TransferableComponentModifier)) {
            return 0;
        }
        TransferableComponentModifier transferableComponentModifier = (TransferableComponentModifier)travellersModifier;
        return transferableComponentModifier.findDataComponentProviders(ingredients).size();
    }

    public static List<Holder.Reference<TravellersModifier>> findAllInsertableModifiers(HolderLookup.Provider registries, ItemStack stack) {
        return registries.lookupOrThrow(TFRegistries.Keys.TRAVELLERS_MODIFIERS).listElements().filter(travellersModifier -> travellersModifier.value() instanceof InsertableTravellersModifier && !((TravellersModifier)travellersModifier.value()).isAbility() && ((TravellersModifier)travellersModifier.value()).hasModifier(stack)).toList();
    }

    public static List<Holder.Reference<TravellersModifier>> findAllInsertableModifiers(Entity entity, ItemStack stack) {
        return TravellersModifiersManager.findAllInsertableModifiers((HolderLookup.Provider)entity.registryAccess(), stack);
    }

    public static List<Holder.Reference<TravellersModifier>> findAllInsertableModifiers(Level level, ItemStack stack) {
        return TravellersModifiersManager.findAllInsertableModifiers((HolderLookup.Provider)level.registryAccess(), stack);
    }

    public static List<Holder.Reference<TravellersModifier>> findAllAbilityModifiers(HolderLookup.Provider registries, ItemStack stack) {
        return registries.lookupOrThrow(TFRegistries.Keys.TRAVELLERS_MODIFIERS).listElements().filter(travellersModifier -> ((TravellersModifier)travellersModifier.value()).isAbility() && ((TravellersModifier)travellersModifier.value()).hasModifier(stack)).toList();
    }

    public static long countInsertableModifiers(HolderLookup.Provider registries, ItemStack stack) {
        return TravellersModifiersManager.findAllInsertableModifiers(registries, stack).size();
    }

    public static boolean isModifierEnabled(HolderLookup.Provider registries, ResourceKey<TravellersModifier> modifierKey) {
        return TravellersModifiersManager.getCachedModifier(registries, modifierKey).isPresent();
    }

    private static ItemStack getStackForGroup(LivingEntity livingEntity, EquipmentSlotGroup group) {
        EquipmentSlot matchedSlot = null;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (!slot.isArmor() || !group.test(slot)) continue;
            if (matchedSlot != null) {
                return ItemStack.EMPTY;
            }
            matchedSlot = slot;
        }
        return matchedSlot == null ? ItemStack.EMPTY : livingEntity.getItemBySlot(matchedSlot);
    }

    public static void clearCache() {
        CACHED_MODIFIERS.clear();
        MISSING_MODIFIERS.clear();
    }

    private static Optional<TravellersModifier> getCachedModifier(HolderLookup.Provider registries, ResourceKey<TravellersModifier> modifierKey) {
        TravellersModifier cached = CACHED_MODIFIERS.get(modifierKey);
        if (cached != null) {
            return Optional.of(cached);
        }
        if (MISSING_MODIFIERS.contains(modifierKey)) {
            return Optional.empty();
        }
        Optional modifier = registries.holder(modifierKey);
        if (modifier.isPresent()) {
            CACHED_MODIFIERS.put(modifierKey, (TravellersModifier)((Holder.Reference)modifier.get()).value());
            return Optional.of((TravellersModifier)((Holder.Reference)modifier.get()).value());
        }
        TwilightForestMod.LOGGER.warn("Travellers modifier {} is not present in the registry", (Object)modifierKey.location());
        MISSING_MODIFIERS.add(modifierKey);
        return Optional.empty();
    }

    public static final class CacheInvalidationReloadListener
    extends SimplePreparableReloadListener<Unit> {
        public static final CacheInvalidationReloadListener INSTANCE = new CacheInvalidationReloadListener();

        private CacheInvalidationReloadListener() {
        }

        protected Unit prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
            return Unit.INSTANCE;
        }

        protected void apply(Unit object, ResourceManager resourceManager, ProfilerFiller profiler) {
            TravellersModifiersManager.clearCache();
        }
    }
}

