/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.init;

import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import twilightforest.TwilightForestMod;
import twilightforest.beanification.Autowired;
import twilightforest.enums.extensions.TFGrassColorModifierEnumExtension;
import twilightforest.world.registration.biomes.BiomeHelper;

public class TFBiomes {
    @Autowired
    private static TFGrassColorModifierEnumExtension grassColorModifierEnumExtension;
    public static final ResourceKey<Biome> FOREST;
    public static final ResourceKey<Biome> DENSE_FOREST;
    public static final ResourceKey<Biome> FIREFLY_FOREST;
    public static final ResourceKey<Biome> CLEARING;
    public static final ResourceKey<Biome> OAK_SAVANNAH;
    public static final ResourceKey<Biome> STREAM;
    public static final ResourceKey<Biome> LAKE;
    public static final ResourceKey<Biome> MUSHROOM_FOREST;
    public static final ResourceKey<Biome> DENSE_MUSHROOM_FOREST;
    public static final ResourceKey<Biome> ENCHANTED_FOREST;
    public static final ResourceKey<Biome> SPOOKY_FOREST;
    public static final ResourceKey<Biome> SWAMP;
    public static final ResourceKey<Biome> FIRE_SWAMP;
    public static final ResourceKey<Biome> DARK_FOREST;
    public static final ResourceKey<Biome> DARK_FOREST_CENTER;
    public static final ResourceKey<Biome> SNOWY_FOREST;
    public static final ResourceKey<Biome> GLACIER;
    public static final ResourceKey<Biome> HIGHLANDS;
    public static final ResourceKey<Biome> HIGHLANDS_UNDERGROUND;
    public static final ResourceKey<Biome> THORNLANDS;
    public static final ResourceKey<Biome> FINAL_PLATEAU;
    public static final ResourceKey<Biome> UNDERGROUND;

    private static ResourceKey<Biome> makeKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)TwilightForestMod.prefix(name));
    }

    public static void bootstrap(BootstrapContext<Biome> context) {
        HolderGetter featureGetter = context.lookup(Registries.PLACED_FEATURE);
        HolderGetter carverGetter = context.lookup(Registries.CONFIGURED_CARVER);
        context.register(FOREST, (Object)BiomeHelper.biomeWithDefaults(BiomeHelper.fireflyParticles(BiomeHelper.defaultAmbientBuilder()), BiomeHelper.defaultMobSpawning(), BiomeHelper.twilightForestGen((HolderGetter<PlacedFeature>)featureGetter, carverGetter)).build());
        context.register(DENSE_FOREST, (Object)BiomeHelper.biomeWithDefaults(BiomeHelper.fireflyParticles(BiomeHelper.defaultAmbientBuilder()).waterColor(21794).waterFogColor(21794), BiomeHelper.defaultMobSpawning(), BiomeHelper.denseForestGen((HolderGetter<PlacedFeature>)featureGetter, carverGetter)).temperature(0.7f).downfall(0.8f).build());
        context.register(FIREFLY_FOREST, (Object)BiomeHelper.biomeWithDefaults(BiomeHelper.fireflyForestParticles(BiomeHelper.defaultAmbientBuilder()), BiomeHelper.defaultMobSpawning(), BiomeHelper.fireflyForestGen((HolderGetter<PlacedFeature>)featureGetter, carverGetter)).temperature(0.5f).downfall(1.0f).build());
        context.register(CLEARING, (Object)BiomeHelper.biomeWithDefaults(BiomeHelper.defaultAmbientBuilder(), BiomeHelper.defaultMobSpawning(), BiomeHelper.clearingGen((HolderGetter<PlacedFeature>)featureGetter, carverGetter)).temperature(0.8f).downfall(0.4f).build());
        context.register(OAK_SAVANNAH, (Object)BiomeHelper.biomeWithDefaults(BiomeHelper.defaultAmbientBuilder(), BiomeHelper.defaultMobSpawning(), BiomeHelper.oakSavannaGen((HolderGetter<PlacedFeature>)featureGetter, carverGetter)).temperature(0.9f).downfall(0.0f).build());
        context.register(MUSHROOM_FOREST, (Object)BiomeHelper.biomeWithDefaults(BiomeHelper.fireflyParticles(BiomeHelper.defaultAmbientBuilder()), BiomeHelper.defaultMobSpawning(), BiomeHelper.mushroomForestGen((HolderGetter<PlacedFeature>)featureGetter, carverGetter)).temperature(0.8f).downfall(0.8f).build());
        context.register(DENSE_MUSHROOM_FOREST, (Object)BiomeHelper.biomeWithDefaults(BiomeHelper.fireflyParticles(BiomeHelper.defaultAmbientBuilder()), BiomeHelper.defaultMobSpawning(), BiomeHelper.denseMushroomForestGen((HolderGetter<PlacedFeature>)featureGetter, carverGetter)).temperature(0.8f).downfall(1.0f).build());
        context.register(SPOOKY_FOREST, (Object)BiomeHelper.biomeWithDefaults(BiomeHelper.defaultAmbientBuilder().grassColorOverride(12865827).foliageColorOverride(16745729).fogColor(8549265).waterColor(12355671).waterFogColor(12355671).grassColorModifier(TFBiomes.grassColorModifierEnumExtension.SPOOKY_FOREST), BiomeHelper.spookSpawning(), BiomeHelper.spookyForestGen((HolderGetter<PlacedFeature>)featureGetter, carverGetter)).temperature(0.5f).downfall(1.0f).build());
        context.register(ENCHANTED_FOREST, (Object)BiomeHelper.biomeWithDefaults(BiomeHelper.fireflyParticles(BiomeHelper.defaultAmbientBuilder()).foliageColorOverride(65535).grassColorOverride(65535).grassColorModifier(TFBiomes.grassColorModifierEnumExtension.ENCHANTED_FOREST), BiomeHelper.defaultMobSpawning(), BiomeHelper.enchantedForestGen((HolderGetter<PlacedFeature>)featureGetter, carverGetter)).hasPrecipitation(false).build());
        context.register(STREAM, (Object)BiomeHelper.biomeWithDefaults(BiomeHelper.defaultAmbientBuilder(), BiomeHelper.defaultMobSpawning(), BiomeHelper.streamsAndLakes((HolderGetter<PlacedFeature>)featureGetter, carverGetter, false)).temperature(0.5f).downfall(0.1f).build());
        context.register(LAKE, (Object)BiomeHelper.biomeWithDefaults(BiomeHelper.defaultAmbientBuilder(), BiomeHelper.defaultMobSpawning(), BiomeHelper.streamsAndLakes((HolderGetter<PlacedFeature>)featureGetter, carverGetter, true)).temperature(0.66f).downfall(1.0f).build());
        context.register(SWAMP, (Object)BiomeHelper.biomeWithDefaults(BiomeHelper.defaultAmbientBuilder().skyColor(8466).fogColor(16161).grassColorOverride(6056270).foliageColorOverride(4809015).waterColor(9811295).waterFogColor(9811295).grassColorModifier(TFBiomes.grassColorModifierEnumExtension.SWAMP), BiomeHelper.swampSpawning(), BiomeHelper.swampGen((HolderGetter<PlacedFeature>)featureGetter, carverGetter)).temperature(0.8f).downfall(0.9f).build());
        context.register(FIRE_SWAMP, (Object)BiomeHelper.biomeWithDefaults(BiomeHelper.whiteAshParticles(BiomeHelper.defaultAmbientBuilder()).waterColor(2950912).fogColor(3672576).grassColorOverride(5713443).foliageColorOverride(6563343).waterColor(0x6C2C2C).waterFogColor(0x6C2C2C), new MobSpawnSettings.Builder(), BiomeHelper.fireSwampGen((HolderGetter<PlacedFeature>)featureGetter, carverGetter)).hasPrecipitation(false).temperature(1.0f).downfall(0.4f).build());
        context.register(DARK_FOREST, (Object)BiomeHelper.biomeWithDefaults(BiomeHelper.defaultAmbientBuilder().skyColor(0).fogColor(0).grassColorOverride(4941652).foliageColorOverride(3890751).grassColorModifier(TFBiomes.grassColorModifierEnumExtension.DARK_FOREST), BiomeHelper.darkForestSpawning(), BiomeHelper.darkForestGen((HolderGetter<PlacedFeature>)featureGetter, carverGetter)).temperature(0.7f).downfall(0.8f).build());
        context.register(DARK_FOREST_CENTER, (Object)BiomeHelper.biomeWithDefaults(BiomeHelper.defaultAmbientBuilder().skyColor(0).fogColor(4796416).grassColorOverride(6714688).foliageColorOverride(16351774).grassColorModifier(TFBiomes.grassColorModifierEnumExtension.DARK_FOREST_CENTER), new MobSpawnSettings.Builder(), BiomeHelper.darkForestCenterGen((HolderGetter<PlacedFeature>)featureGetter, carverGetter)).build());
        context.register(SNOWY_FOREST, (Object)BiomeHelper.biomeWithDefaults(BiomeHelper.defaultAmbientBuilder().skyColor(0x808080).fogColor(0xFFFFFF).foliageColorOverride(0xFFFFFF).grassColorOverride(0xFFFFFF), BiomeHelper.snowForestSpawning(), BiomeHelper.snowyForestGen((HolderGetter<PlacedFeature>)featureGetter, carverGetter)).hasPrecipitation(true).temperature(0.09f).downfall(0.9f).build());
        context.register(GLACIER, (Object)BiomeHelper.biomeWithDefaults(BiomeHelper.defaultAmbientBuilder().skyColor(1248552).fogColor(3547016), BiomeHelper.penguinSpawning(), BiomeHelper.glacierGen((HolderGetter<PlacedFeature>)featureGetter, carverGetter)).temperature(0.08f).downfall(0.1f).hasPrecipitation(true).build());
        context.register(HIGHLANDS, (Object)BiomeHelper.biomeWithDefaults(BiomeHelper.defaultAmbientBuilder(), BiomeHelper.defaultMobSpawning(), BiomeHelper.highlandsGen((HolderGetter<PlacedFeature>)featureGetter, carverGetter)).temperature(0.4f).downfall(0.7f).build());
        context.register(HIGHLANDS_UNDERGROUND, (Object)BiomeHelper.biomeWithDefaults(BiomeHelper.defaultAmbientBuilder(), BiomeHelper.undergroundMobSpawning(), BiomeHelper.highlandsUndergroundGen((HolderGetter<PlacedFeature>)featureGetter, carverGetter)).temperature(0.35f).downfall(0.0f).build());
        context.register(THORNLANDS, (Object)BiomeHelper.biomeWithDefaults(BiomeHelper.defaultAmbientBuilder(), new MobSpawnSettings.Builder(), BiomeHelper.thornlandsGen((HolderGetter<PlacedFeature>)featureGetter, carverGetter)).temperature(0.3f).downfall(0.2f).build());
        context.register(FINAL_PLATEAU, (Object)BiomeHelper.biomeWithDefaults(BiomeHelper.defaultAmbientBuilder(), BiomeHelper.ravenSpawning(), new BiomeGenerationSettings.Builder(featureGetter, carverGetter)).temperature(1.0f).downfall(0.2f).build());
        context.register(UNDERGROUND, (Object)BiomeHelper.biomeWithDefaults(BiomeHelper.defaultAmbientBuilder(), BiomeHelper.undergroundMobSpawning(), BiomeHelper.undergroundGen((HolderGetter<PlacedFeature>)featureGetter, carverGetter)).temperature(0.7f).downfall(0.0f).build());
    }

    static {
        FOREST = TFBiomes.makeKey("forest");
        DENSE_FOREST = TFBiomes.makeKey("dense_forest");
        FIREFLY_FOREST = TFBiomes.makeKey("firefly_forest");
        CLEARING = TFBiomes.makeKey("clearing");
        OAK_SAVANNAH = TFBiomes.makeKey("oak_savannah");
        STREAM = TFBiomes.makeKey("stream");
        LAKE = TFBiomes.makeKey("lake");
        MUSHROOM_FOREST = TFBiomes.makeKey("mushroom_forest");
        DENSE_MUSHROOM_FOREST = TFBiomes.makeKey("dense_mushroom_forest");
        ENCHANTED_FOREST = TFBiomes.makeKey("enchanted_forest");
        SPOOKY_FOREST = TFBiomes.makeKey("spooky_forest");
        SWAMP = TFBiomes.makeKey("swamp");
        FIRE_SWAMP = TFBiomes.makeKey("fire_swamp");
        DARK_FOREST = TFBiomes.makeKey("dark_forest");
        DARK_FOREST_CENTER = TFBiomes.makeKey("dark_forest_center");
        SNOWY_FOREST = TFBiomes.makeKey("snowy_forest");
        GLACIER = TFBiomes.makeKey("glacier");
        HIGHLANDS = TFBiomes.makeKey("highlands");
        HIGHLANDS_UNDERGROUND = TFBiomes.makeKey("highlands_underground");
        THORNLANDS = TFBiomes.makeKey("thornlands");
        FINAL_PLATEAU = TFBiomes.makeKey("final_plateau");
        UNDERGROUND = TFBiomes.makeKey("underground");
    }
}

