/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.events;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.BlockSnapshot;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import twilightforest.advancements.SimpleAdvancementTrigger;
import twilightforest.beanification.Component;
import twilightforest.beanification.PostConstruct;
import twilightforest.block.TFPortalBlock;
import twilightforest.config.TFConfig;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.data.tags.ItemTagGenerator;
import twilightforest.entity.monster.Kobold;
import twilightforest.init.TFAdvancements;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFDimension;
import twilightforest.network.AreaProtectionPacket;
import twilightforest.network.MissingAdvancementToastPacket;
import twilightforest.network.StructureProtectionPacket;
import twilightforest.util.Enforcement;
import twilightforest.util.PlayerHelper;
import twilightforest.util.landmarks.LandmarkUtil;
import twilightforest.world.components.structures.util.AdvancementLockedStructure;
import twilightforest.world.components.structures.util.ProgressionPiece;
import twilightforest.world.components.structures.util.ProgressionStructure;

@Component
public class ProgressionEvents {
    @PostConstruct
    private void setup() {
        NeoForge.EVENT_BUS.addListener(this::preventLockedAreaBlockBreaking);
        NeoForge.EVENT_BUS.addListener(this::preventLockedAreaBlockPlacing);
        NeoForge.EVENT_BUS.addListener(this::preventLockedAreaBlockInteracting);
        NeoForge.EVENT_BUS.addListener(this::preventLockedAreaMultiblocks);
        NeoForge.EVENT_BUS.addListener(this::preventLockedAreaEntityDamage);
        NeoForge.EVENT_BUS.addListener(this::performProtectionAndPortalChecks);
    }

    private void preventLockedAreaBlockBreaking(BlockEvent.BreakEvent event) {
        ServerLevel level;
        block5: {
            block4: {
                LevelAccessor levelAccessor = event.getLevel();
                if (!(levelAccessor instanceof ServerLevel)) break block4;
                level = (ServerLevel)levelAccessor;
                if (!event.isCanceled()) break block5;
            }
            return;
        }
        BlockPos pos = event.getPos();
        if (ProgressionEvents.isBlockProtectedFromBreaking((BlockGetter)level, pos) && ProgressionEvents.isAreaProtected(level, event.getPlayer(), pos)) {
            event.setCanceled(true);
        }
    }

    private void preventLockedAreaBlockPlacing(PlayerInteractEvent.RightClickBlock event) {
        ServerLevel level;
        block5: {
            block4: {
                Level level2 = event.getLevel();
                if (!(level2 instanceof ServerLevel)) break block4;
                level = (ServerLevel)level2;
                if (!event.isCanceled()) break block5;
            }
            return;
        }
        BlockPos pos = event.getPos();
        if (ProgressionEvents.isAreaProtected(level, event.getEntity(), pos)) {
            event.setCanceled(true);
            event.getEntity().inventoryMenu.sendAllDataToRemote();
        }
    }

    private void preventLockedAreaMultiblocks(BlockEvent.EntityMultiPlaceEvent event) {
        Player player;
        ServerLevel level;
        block4: {
            block3: {
                Entity entity = event.getEntity();
                LevelAccessor levelAccessor = event.getLevel();
                if (!(levelAccessor instanceof ServerLevel)) break block3;
                level = (ServerLevel)levelAccessor;
                if (!(entity instanceof Player)) break block3;
                player = (Player)entity;
                if (!event.isCanceled()) break block4;
            }
            return;
        }
        for (BlockSnapshot snapshot : event.getReplacedBlockSnapshots()) {
            BlockPos pos = snapshot.getPos();
            if (!ProgressionEvents.isBlockProtectedFromBreaking((BlockGetter)level, pos) || !ProgressionEvents.isAreaProtected(level, player, pos)) continue;
            event.setCanceled(true);
            player.inventoryMenu.sendAllDataToRemote();
            break;
        }
    }

    private void preventLockedAreaBlockInteracting(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        Level level = player.level();
        if (!level.isClientSide() && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (ProgressionEvents.isBlockProtectedFromInteraction((BlockGetter)level, event.getPos()) && ProgressionEvents.isAreaProtected(serverLevel, player, event.getPos())) {
                event.setUseBlock(TriState.FALSE);
            }
        }
    }

    private static boolean isAreaProtected(ServerLevel level, Player player, BlockPos pos) {
        ProgressionStructure structureHints;
        Structure structure;
        StructureStart structureStart;
        if (player.getAbilities().instabuild || player.isSpectator() || !LandmarkUtil.isProgressionEnforced((Level)level) || player instanceof FakePlayer) {
            return false;
        }
        Optional<StructureStart> struct = LandmarkUtil.locateNearestLandmarkStart((LevelAccessor)level, SectionPos.blockToSectionCoord((int)pos.getX()), SectionPos.blockToSectionCoord((int)pos.getZ()));
        if (struct.isPresent() && (structureStart = struct.get()).getPieces().stream().anyMatch(structurePiece -> structurePiece.getBoundingBox().isInside((Vec3i)pos) && ProgressionEvents.isPieceProtected(structurePiece)) && (structure = structureStart.getStructure()) instanceof ProgressionStructure && !(structureHints = (ProgressionStructure)structure).doesPlayerHaveRequiredAdvancements(player)) {
            ArrayList<BoundingBox> boxes = new ArrayList<BoundingBox>();
            structureStart.getPieces().forEach(piece -> {
                if (piece.getBoundingBox().isInside((Vec3i)pos)) {
                    boxes.add(piece.getBoundingBox());
                }
            });
            ProgressionEvents.sendAreaProtectionPacket(level, pos, boxes);
            structureHints.trySpawnHintMonster((Level)level, player, pos);
            return true;
        }
        return false;
    }

    private void preventLockedAreaEntityDamage(LivingIncomingDamageEvent event) {
        LivingEntity living = event.getEntity();
        Level level = living.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (living instanceof Enemy && event.getSource().getEntity() instanceof Player && !(living instanceof Kobold) && ProgressionEvents.isAreaProtected(serverLevel, (Player)event.getSource().getEntity(), new BlockPos((Vec3i)living.blockPosition()))) {
                event.setCanceled(true);
            }
        }
    }

    private void performProtectionAndPortalChecks(PlayerTickEvent.Post event) {
        Player eventPlayer = event.getEntity();
        if (!(eventPlayer instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)eventPlayer;
        Level level = player.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)level;
        if (!TFConfig.disablePortalCreation && player.tickCount % (!TFConfig.checkPortalPlacement ? 100 : 20) == 0 && world.getServer().getProfilePermissions(player.getGameProfile()) >= TFConfig.portalCreationPermission) {
            ProgressionEvents.checkForPortalCreation(player, (Level)world, TFConfig.portalCreationPermission >= 3 ? 4.0f : 32.0f);
        }
        if (player.tickCount % 20 == 0 && LandmarkUtil.isProgressionEnforced((Level)world) && !player.isCreative() && !player.isSpectator()) {
            Enforcement.enforceBiomeProgression((Player)player, world);
        }
        if (player.tickCount % 100 == 0 && LandmarkUtil.isProgressionEnforced((Level)world)) {
            if (player.isCreative() || player.isSpectator()) {
                ProgressionEvents.sendAllClearPacket((Player)player);
            } else {
                ProgressionEvents.checkForLockedStructuresSendPacket((Player)player, world);
            }
        }
    }

    private static boolean checkForLockedStructuresSendPacket(Player player, ServerLevel world) {
        ChunkPos chunkPlayer = player.chunkPosition();
        return LandmarkUtil.locateNearestLandmarkStart((LevelAccessor)world, chunkPlayer.x, chunkPlayer.z).map(structureStart -> {
            AdvancementLockedStructure advancementLockedStructure;
            Structure patt0$temp = structureStart.getStructure();
            if (patt0$temp instanceof AdvancementLockedStructure && !(advancementLockedStructure = (AdvancementLockedStructure)patt0$temp).doesPlayerHaveRequiredAdvancements(player)) {
                List<Pair<BoundingBox, Boolean>> boundingBoxesData = structureStart.getPieces().stream().map(piece -> Pair.of((Object)(ProgressionEvents.isPieceProtected(piece) ? piece.getBoundingBox().inflatedBy(4) : piece.getBoundingBox()), (Object)ProgressionEvents.isPieceProtected(piece))).toList();
                ProgressionEvents.sendStructureProtectionPacket(player, boundingBoxesData);
                return true;
            }
            ProgressionEvents.sendAllClearPacket(player);
            return false;
        }).orElse(false);
    }

    private static void checkForPortalCreation(ServerPlayer player, Level world, float rangeToCheck) {
        if (world.dimension().location().equals((Object)ResourceLocation.parse((String)TFConfig.originDimension)) || TFDimension.isTwilightPortalDestination(world) || TFConfig.allowPortalsInOtherDimensions) {
            AdvancementHolder requirement;
            List itemList = world.getEntitiesOfClass(ItemEntity.class, player.getBoundingBox().inflate((double)rangeToCheck));
            ItemEntity qualified = null;
            for (ItemEntity entityItem : itemList) {
                if (!entityItem.getItem().is(ItemTagGenerator.PORTAL_ACTIVATOR) || !((TFPortalBlock)((Object)TFBlocks.TWILIGHT_PORTAL.get())).canFormPortal(world.getBlockState(entityItem.blockPosition())) || !Objects.equals(entityItem.getOwner(), player)) continue;
                qualified = entityItem;
                break;
            }
            if (qualified == null) {
                return;
            }
            if (!(player.isCreative() || player.isSpectator() || TFConfig.getPortalLockingAdvancement((Player)player) == null || (requirement = PlayerHelper.getAdvancement((Player)player, Objects.requireNonNull(TFConfig.getPortalLockingAdvancement((Player)player)))) == null || PlayerHelper.doesPlayerHaveRequiredAdvancement((Player)player, requirement))) {
                player.displayClientMessage(TFPortalBlock.PORTAL_UNWORTHY, true);
                if (!TFPortalBlock.isPlayerNotifiedOfRequirement(player)) {
                    DisplayInfo info = requirement.value().display().orElse(null);
                    PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)(info == null ? new MissingAdvancementToastPacket((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"twilightforest.ui.advancement.no_title"), new ItemStack((ItemLike)TFBlocks.TWILIGHT_PORTAL_MINIATURE_STRUCTURE.get())) : new MissingAdvancementToastPacket(info.getTitle(), info.getIcon())), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    TFPortalBlock.playerNotifiedOfRequirement(player);
                }
                return;
            }
            Random rand = new Random();
            for (int i = 0; i < 2; ++i) {
                double vx = rand.nextGaussian() * 0.02;
                double vy = rand.nextGaussian() * 0.02;
                double vz = rand.nextGaussian() * 0.02;
                world.addParticle((ParticleOptions)ParticleTypes.EFFECT, qualified.getX(), qualified.getY() + 0.2, qualified.getZ(), vx, vy, vz);
            }
            if (((TFPortalBlock)((Object)TFBlocks.TWILIGHT_PORTAL.get())).tryToCreatePortal(world, qualified.blockPosition(), qualified, (Player)player)) {
                ((SimpleAdvancementTrigger)((Object)TFAdvancements.MADE_TF_PORTAL.get())).trigger(player);
            }
        }
    }

    private static boolean isPieceProtected(StructurePiece piece) {
        ProgressionPiece progressionPiece;
        return !(piece instanceof ProgressionPiece) || (progressionPiece = (ProgressionPiece)piece).isComponentProtected();
    }

    private static boolean isBlockProtectedFromInteraction(BlockGetter level, BlockPos pos) {
        return level.getBlockState(pos).is(BlockTagGenerator.STRUCTURE_BANNED_INTERACTIONS);
    }

    private static boolean isBlockProtectedFromBreaking(BlockGetter level, BlockPos pos) {
        return !level.getBlockState(pos).is(BlockTagGenerator.PROGRESSION_ALLOW_BREAKING);
    }

    private static void sendAreaProtectionPacket(ServerLevel level, BlockPos pos, List<BoundingBox> sbb) {
        PacketDistributor.sendToPlayersNear((ServerLevel)level, null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)64.0, (CustomPacketPayload)new AreaProtectionPacket(sbb, pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static void sendStructureProtectionPacket(Player player, List<Pair<BoundingBox, Boolean>> sbbData) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)new StructureProtectionPacket(Optional.of(sbbData)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private static void sendAllClearPacket(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)new StructureProtectionPacket(Optional.empty()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

