/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.events;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.Criterion;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Interaction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.LeadItem;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.AdvancementEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.advancements.DrinkFromFlaskTrigger;
import twilightforest.beanification.Autowired;
import twilightforest.beanification.Component;
import twilightforest.beanification.PostConstruct;
import twilightforest.block.AbstractSkullCandleBlock;
import twilightforest.block.CloudBlock;
import twilightforest.block.LightableBlock;
import twilightforest.block.SkullChestBlock;
import twilightforest.block.WroughtIronFenceBlock;
import twilightforest.block.entity.SkullCandleBlockEntity;
import twilightforest.block.entity.SkullChestBlockEntity;
import twilightforest.components.entity.MultiplayerInclusivityAttachment;
import twilightforest.components.entity.PotionFlaskTrackingAttachment;
import twilightforest.config.TFConfig;
import twilightforest.data.tags.EntityTagGenerator;
import twilightforest.enchantment.ApplyFrostedEffect;
import twilightforest.entity.passive.quest.ram.QuestingRamCurrentContext;
import twilightforest.entity.projectile.ITFProjectile;
import twilightforest.entity.projectile.LichBomb;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFDamageTypes;
import twilightforest.init.TFDataAttachments;
import twilightforest.init.TFDataComponents;
import twilightforest.init.TFDataMaps;
import twilightforest.init.TFDimensionData;
import twilightforest.init.TFItems;
import twilightforest.init.TFMobEffects;
import twilightforest.init.TFSounds;
import twilightforest.init.TFStats;
import twilightforest.item.FieryArmorItem;
import twilightforest.item.YetiArmorItem;
import twilightforest.network.SyncQuestsPacket;
import twilightforest.network.WipeOreMeterPacket;
import twilightforest.util.datamaps.EntityTransformation;
import twilightforest.util.entities.EntityUtil;
import twilightforest.util.entities.OminousFireDamageSource;
import twilightforest.world.components.structures.SpawnIndexProvider;
import twilightforest.world.components.structures.start.TFStructureStart;
import twilightforest.world.components.structures.type.HollowHillStructure;
import twilightforest.world.components.structures.util.ControlledSpawns;

@Component
public class EntityEvents {
    @Autowired
    private QuestingRamCurrentContext questingRamCurrentContext;
    private static final boolean SHIELD_PARRY_MOD_LOADED = ModList.get().isLoaded("parry");

    @PostConstruct
    private void setup() {
        NeoForge.EVENT_BUS.addListener(this::ominousFireConversion);
        NeoForge.EVENT_BUS.addListener(this::zombifiedPlayerAttacks);
        NeoForge.EVENT_BUS.addListener(this::alertPlayerCastleIsWIP);
        NeoForge.EVENT_BUS.addListener(this::attachLeadToWroughtFence);
        NeoForge.EVENT_BUS.addListener(this::wipeOreMeterOnLeftClick);
        NeoForge.EVENT_BUS.addListener(this::entityHurts);
        NeoForge.EVENT_BUS.addListener(this::onCasketBreak);
        NeoForge.EVENT_BUS.addListener(this::reduceFrostedEffectIfOnFire);
        NeoForge.EVENT_BUS.addListener(this::onParryProjectile);
        NeoForge.EVENT_BUS.addListener(this::createSkullCandle);
        NeoForge.EVENT_BUS.addListener(this::addCloudJumpParticles);
        NeoForge.EVENT_BUS.addListener(this::structureSpecialSpawns);
        NeoForge.EVENT_BUS.addListener(this::removeCastleTextIfAttacked);
        NeoForge.EVENT_BUS.addListener(this::adjustEntityHealthInMultiplayerFights);
        NeoForge.EVENT_BUS.addListener(this::addQualifiedGroupPlayerIfNeeded);
        NeoForge.EVENT_BUS.addListener(this::grantGroupAdvancementIfNeeded);
        NeoForge.EVENT_BUS.addListener(this::lichBombsDontBlowUpItems);
        NeoForge.EVENT_BUS.addListener(this::handleQuestSyncing);
        NeoForge.EVENT_BUS.addListener(this::resetFlaskLogic);
        NeoForge.EVENT_BUS.addListener(this::handleLeashPathingOverrides);
        NeoForge.EVENT_BUS.addListener(this::stopEndermenFromGrabbingBlocksInTF);
    }

    private void ominousFireConversion(LivingDeathEvent event) {
        if (!event.isCanceled() && event.getSource().is(TFDamageTypes.OMINOUS_FIRE)) {
            EntityTransformation dataMap = (EntityTransformation)event.getEntity().getType().builtInRegistryHolder().getData(TFDataMaps.OMINOUS_FIRE);
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                Zombie zombie = (Zombie)EntityType.ZOMBIE.create(player.level());
                zombie.setData(TFDataAttachments.ZOMBIFIED_PLAYER, (Object)player.getGameProfile());
                zombie.copyPosition((Entity)player);
                zombie.setCanPickUpLoot(true);
                zombie.setBaby(false);
                EventHooks.finalizeMobSpawn((Mob)zombie, (ServerLevelAccessor)player.serverLevel(), (DifficultyInstance)player.level().getCurrentDifficultyAt(player.blockPosition()), (MobSpawnType)MobSpawnType.CONVERSION, null);
                player.level().addFreshEntity((Entity)zombie);
            } else if (dataMap != null && event.getEntity().level() instanceof ServerLevel) {
                EntityUtil.convertEntity(event.getEntity(), dataMap.result());
            }
        }
    }

    private void zombifiedPlayerAttacks(LivingIncomingDamageEvent event) {
        Zombie zombie;
        Entity entity;
        if (!(event.getSource() instanceof OminousFireDamageSource) && (entity = event.getSource().getEntity()) instanceof Zombie && (zombie = (Zombie)entity).hasData(TFDataAttachments.ZOMBIFIED_PLAYER)) {
            float amount = event.getAmount();
            event.setCanceled(true);
            event.getEntity().hurt((DamageSource)new OminousFireDamageSource(event.getSource()), amount);
        }
    }

    private void alertPlayerCastleIsWIP(AdvancementEvent.AdvancementEarnEvent event) {
        if (event.getAdvancement().id().equals((Object)TwilightForestMod.prefix("progression_end"))) {
            event.getEntity().sendSystemMessage((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"gui.twilightforest.progression_end.message", (Object[])new Object[]{net.minecraft.network.chat.Component.translatable((String)"gui.twilightforest.progression_end.discord").withStyle(style -> style.withColor(ChatFormatting.BLUE).applyFormat(ChatFormatting.UNDERLINE).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://discord.experiment115.com/")))}));
        }
    }

    private void attachLeadToWroughtFence(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        ItemStack stack = player.getItemInHand(event.getHand());
        if (stack.is(Items.LEAD)) {
            BlockPos pos = event.getPos();
            BlockState state = event.getLevel().getBlockState(pos);
            if (state.is(TFBlocks.WROUGHT_IRON_FENCE) && state.getValue(WroughtIronFenceBlock.POST) != WroughtIronFenceBlock.PostState.NONE && !event.getLevel().isClientSide()) {
                LeadItem.bindPlayerMobs((Player)player, (Level)event.getLevel(), (BlockPos)event.getPos());
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }
    }

    private void wipeOreMeterOnLeftClick(PlayerInteractEvent.LeftClickEmpty event) {
        ItemStack item = event.getItemStack();
        if (item.is((Item)TFItems.ORE_METER.get()) && (item.has(TFDataComponents.ORE_DATA) || item.has(TFDataComponents.ORE_FILTER))) {
            PacketDistributor.sendToServer((CustomPacketPayload)new WipeOreMeterPacket(event.getHand()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            item.remove(TFDataComponents.ORE_DATA);
            item.remove(TFDataComponents.ORE_FILTER);
            event.getLevel().playSound(event.getEntity(), event.getEntity().blockPosition(), (SoundEvent)TFSounds.ORE_METER_CLEAR.get(), SoundSource.PLAYERS, 1.25f, event.getLevel().getRandom().nextFloat() * 0.2f + 0.6f);
        }
    }

    private void entityHurts(LivingDamageEvent.Post event) {
        Player player;
        LivingEntity living = event.getEntity();
        DamageSource source = event.getSource();
        Entity trueSource = source.getEntity();
        if (source.getEntity() != null && trueSource != null && event.getOriginalDamage() > 0.0f) {
            int fireLevel = EntityEvents.getGearCoverage(living, false) * 5;
            int chillLevel = EntityEvents.getGearCoverage(living, true);
            if (fireLevel > 0 && living.getRandom().nextInt(25) < fireLevel && !trueSource.fireImmune()) {
                trueSource.igniteForSeconds((float)(fireLevel / 2));
            }
            if (trueSource instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)trueSource;
                ApplyFrostedEffect.doChillAuraEffect(target, chillLevel * 5 + 5, chillLevel, chillLevel > 0);
            }
        }
        if (source.getMsgId().equals("arrow") && trueSource instanceof Player && (player = (Player)trueSource).getItemInHand(player.getUsedItemHand()).is((Item)TFItems.TRIPLE_BOW.get())) {
            living.invulnerableTime = 0;
        }
    }

    private void onCasketBreak(BlockEvent.BreakEvent event) {
        BlockEntity te;
        Player player = event.getPlayer();
        if (event.getState().getBlock() instanceof SkullChestBlock && (te = event.getLevel().getBlockEntity(event.getPos())) instanceof SkullChestBlockEntity) {
            SkullChestBlockEntity casket = (SkullChestBlockEntity)te;
            ResolvableProfile checker = casket.owner;
            if (!(checker == null || casket.isEmpty() || player.hasPermissions(3) && player.getGameProfile().equals((Object)checker.gameProfile()))) {
                event.setCanceled(true);
            }
        }
    }

    private void reduceFrostedEffectIfOnFire(LivingIncomingDamageEvent event) {
        if (!event.isCanceled()) {
            LivingEntity living = event.getEntity();
            Optional.ofNullable(living.getEffect(TFMobEffects.FROSTY)).ifPresent(mobEffectInstance -> {
                DamageContainer container = event.getContainer();
                if (container.getSource().typeHolder().is(DamageTypes.FREEZE)) {
                    container.setNewDamage(container.getOriginalDamage() + (float)(mobEffectInstance.getAmplifier() / 2));
                } else if (container.getSource().typeHolder().is(DamageTypeTags.IS_FIRE)) {
                    living.removeEffect(TFMobEffects.FROSTY);
                    --mobEffectInstance.amplifier;
                    if (mobEffectInstance.amplifier >= 0) {
                        living.addEffect(mobEffectInstance);
                    }
                }
            });
        }
    }

    private void onParryProjectile(ProjectileImpactEvent event) {
        LivingEntity entityBlocking;
        EntityHitResult result;
        Entity entity;
        HitResult hitResult;
        Projectile projectile = event.getProjectile();
        if (!projectile.getCommandSenderWorld().isClientSide() && !SHIELD_PARRY_MOD_LOADED && (TFConfig.parryNonTwilightAttacks || projectile instanceof ITFProjectile) && (hitResult = event.getRayTraceResult()) instanceof EntityHitResult && (entity = (result = (EntityHitResult)hitResult).getEntity()) instanceof LivingEntity && (entityBlocking = (LivingEntity)entity).isBlocking() && entityBlocking.getUseItem().getUseDuration(entityBlocking) - entityBlocking.getUseItemRemainingTicks() <= TFConfig.shieldParryTicks) {
            projectile.deflect(ProjectileDeflection.AIM_DEFLECT, (Entity)entityBlocking, (Entity)entityBlocking, true);
            event.setCanceled(true);
        }
    }

    private void createSkullCandle(PlayerInteractEvent.RightClickBlock event) {
        Block block;
        ItemStack stack = event.getItemStack();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = level.getBlockState(pos);
        if (!TFConfig.disableSkullCandles && stack.is(ItemTags.CANDLES) && BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getNamespace().equals("minecraft") && !event.getEntity().isShiftKeyDown() && (block = state.getBlock()) instanceof AbstractSkullBlock) {
            AbstractSkullBlock skull = (AbstractSkullBlock)block;
            if (BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()).getNamespace().equals("minecraft")) {
                SkullBlock.Types type = (SkullBlock.Types)skull.getType();
                boolean wall = state.getBlock() instanceof WallSkullBlock;
                switch (type) {
                    case SKELETON: {
                        if (wall) {
                            EntityEvents.makeSkullCandle(event, (Block)TFBlocks.SKELETON_WALL_SKULL_CANDLE.get());
                            break;
                        }
                        EntityEvents.makeSkullCandle(event, (Block)TFBlocks.SKELETON_SKULL_CANDLE.get());
                        break;
                    }
                    case WITHER_SKELETON: {
                        if (wall) {
                            EntityEvents.makeSkullCandle(event, (Block)TFBlocks.WITHER_SKELE_WALL_SKULL_CANDLE.get());
                            break;
                        }
                        EntityEvents.makeSkullCandle(event, (Block)TFBlocks.WITHER_SKELE_SKULL_CANDLE.get());
                        break;
                    }
                    case PLAYER: {
                        if (wall) {
                            EntityEvents.makeSkullCandle(event, (Block)TFBlocks.PLAYER_WALL_SKULL_CANDLE.get());
                            break;
                        }
                        EntityEvents.makeSkullCandle(event, (Block)TFBlocks.PLAYER_SKULL_CANDLE.get());
                        break;
                    }
                    case ZOMBIE: {
                        if (wall) {
                            EntityEvents.makeSkullCandle(event, (Block)TFBlocks.ZOMBIE_WALL_SKULL_CANDLE.get());
                            break;
                        }
                        EntityEvents.makeSkullCandle(event, (Block)TFBlocks.ZOMBIE_SKULL_CANDLE.get());
                        break;
                    }
                    case CREEPER: {
                        if (wall) {
                            EntityEvents.makeSkullCandle(event, (Block)TFBlocks.CREEPER_WALL_SKULL_CANDLE.get());
                            break;
                        }
                        EntityEvents.makeSkullCandle(event, (Block)TFBlocks.CREEPER_SKULL_CANDLE.get());
                        break;
                    }
                    case PIGLIN: {
                        if (wall) {
                            EntityEvents.makeSkullCandle(event, (Block)TFBlocks.PIGLIN_WALL_SKULL_CANDLE.get());
                            break;
                        }
                        EntityEvents.makeSkullCandle(event, (Block)TFBlocks.PIGLIN_SKULL_CANDLE.get());
                        break;
                    }
                    default: {
                        return;
                    }
                }
                stack.consume(1, (LivingEntity)event.getEntity());
                event.getEntity().swing(event.getHand());
                if (event.getEntity() instanceof ServerPlayer) {
                    event.getEntity().awardStat((ResourceLocation)TFStats.SKULL_CANDLES_MADE.get());
                }
                event.setCanceled(true);
            }
        }
    }

    private static void makeSkullCandle(PlayerInteractEvent.RightClickBlock event, Block newBlock) {
        ResolvableProfile profile = null;
        Level level = event.getLevel();
        BlockEntity blockEntity = level.getBlockEntity(event.getPos());
        if (blockEntity instanceof SkullBlockEntity) {
            SkullBlockEntity skull = (SkullBlockEntity)blockEntity;
            profile = skull.getOwnerProfile();
        }
        level.playSound(null, event.getPos(), SoundEvents.CANDLE_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.setBlockAndUpdate(event.getPos(), (BlockState)newBlock.withPropertiesOf(level.getBlockState(event.getPos())).setValue((Property)AbstractSkullCandleBlock.LIGHTING, (Comparable)((Object)LightableBlock.Lighting.NONE)));
        level.setBlockEntity((BlockEntity)new SkullCandleBlockEntity(event.getPos(), (BlockState)newBlock.withPropertiesOf(level.getBlockState(event.getPos())).setValue((Property)AbstractSkullCandleBlock.LIGHTING, (Comparable)((Object)LightableBlock.Lighting.NONE)), AbstractSkullCandleBlock.candleToCandleColor(event.getItemStack().getItem()).getValue()));
        blockEntity = level.getBlockEntity(event.getPos());
        if (blockEntity instanceof SkullCandleBlockEntity) {
            SkullCandleBlockEntity sc = (SkullCandleBlockEntity)blockEntity;
            sc.setOwner(profile);
        }
    }

    public static int getGearCoverage(LivingEntity entity, boolean yeti) {
        int amount = 0;
        for (ItemStack armor : entity.getArmorSlots()) {
            if (armor.isEmpty() || !(yeti ? armor.getItem() instanceof YetiArmorItem : armor.getItem() instanceof FieryArmorItem)) continue;
            ++amount;
        }
        return amount;
    }

    private void addCloudJumpParticles(LivingEvent.LivingJumpEvent event) {
        LivingEntity living = event.getEntity();
        if (living.level().isClientSide() && !living.isSpectator() && living.level().getBlockState(living.getOnPos()).getBlock() instanceof CloudBlock) {
            for (int i = 0; i < 12; ++i) {
                CloudBlock.addEntityMovementParticles(living.level(), living.getOnPos(), (Entity)living, true);
            }
        }
    }

    private static int getSpawnListIndexAt(StructureStart start, BlockPos pos) {
        int highestFoundIndex = -1;
        for (StructurePiece component : start.getPieces()) {
            SpawnIndexProvider indexProvider;
            if (!component.getBoundingBox().isInside((Vec3i)pos) || !(component instanceof SpawnIndexProvider) || (indexProvider = (SpawnIndexProvider)component).getSpawnIndex() <= highestFoundIndex) continue;
            highestFoundIndex = indexProvider.getSpawnIndex();
        }
        return highestFoundIndex;
    }

    @Nullable
    public static List<MobSpawnSettings.SpawnerData> gatherPotentialSpawns(StructureManager structureManager, MobCategory classification, BlockPos pos) {
        List structureStarts = structureManager.startsForStructure(new ChunkPos(pos), s -> s instanceof ControlledSpawns);
        for (StructureStart start : structureStarts) {
            HollowHillStructure hollowHill;
            TFStructureStart s2;
            Structure structure = start.getStructure();
            if (!(structure instanceof ControlledSpawns)) continue;
            ControlledSpawns landmark = (ControlledSpawns)structure;
            if (!start.isValid()) continue;
            if (classification != MobCategory.MONSTER) {
                return landmark.getSpawnableList(classification);
            }
            if (start instanceof TFStructureStart && (s2 = (TFStructureStart)start).isConquered()) {
                return null;
            }
            if (landmark instanceof HollowHillStructure && !(hollowHill = (HollowHillStructure)landmark).canSpawnMob(pos, start.getBoundingBox())) {
                return null;
            }
            int index = EntityEvents.getSpawnListIndexAt(start, pos);
            if (index < 0) {
                return null;
            }
            return landmark.getSpawnableMonsterList(index);
        }
        return null;
    }

    private void structureSpecialSpawns(LevelEvent.PotentialSpawns event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)levelAccessor;
        List<MobSpawnSettings.SpawnerData> potentialStructureSpawns = EntityEvents.gatherPotentialSpawns(serverLevel.structureManager(), event.getMobCategory(), event.getPos());
        if (potentialStructureSpawns != null) {
            List.copyOf(event.getSpawnerDataList()).forEach(arg_0 -> ((LevelEvent.PotentialSpawns)event).removeSpawnerData(arg_0));
            potentialStructureSpawns.forEach(arg_0 -> ((LevelEvent.PotentialSpawns)event).addSpawnerData(arg_0));
        }
    }

    private void removeCastleTextIfAttacked(AttackEntityEvent event) {
        Level level = event.getTarget().level();
        if (level instanceof ServerLevel) {
            Interaction interaction;
            ServerLevel level2 = (ServerLevel)level;
            level = event.getTarget();
            if (level instanceof Interaction && (interaction = (Interaction)level).getTags().contains("final_castle_wip")) {
                AABB bounds = interaction.getBoundingBox();
                level2.getEntities((Entity)interaction, bounds, e -> e instanceof Display).forEach(Entity::discard);
                interaction.discard();
            }
        }
    }

    private void adjustEntityHealthInMultiplayerFights(FinalizeSpawnEvent event) {
        List nearbyPlayers;
        if (event.getEntity().getType().is(EntityTagGenerator.MULTIPLAYER_INCLUSIVE_ENTITIES) && TFConfig.multiplayerFightAdjuster.adjustsHealth() && (nearbyPlayers = event.getLevel().getEntitiesOfClass(ServerPlayer.class, event.getEntity().getBoundingBox().inflate(32.0, 10.0, 32.0), player -> EntitySelector.NO_CREATIVE_OR_SPECTATOR.and(EntitySelector.ENTITY_STILL_ALIVE).test((ServerPlayer)player))).size() > 1 && event.getEntity().getAttribute(Attributes.MAX_HEALTH) != null) {
            event.getEntity().getAttribute(Attributes.MAX_HEALTH).addPermanentModifier(new AttributeModifier(TwilightForestMod.prefix("group_health_boost"), EntityEvents.getHealthBasedOnDifficulty(event.getDifficulty().getDifficulty()) * (double)(nearbyPlayers.size() - 1), AttributeModifier.Operation.ADD_VALUE));
        }
    }

    private static double getHealthBasedOnDifficulty(Difficulty difficulty) {
        return switch (difficulty) {
            case Difficulty.EASY -> 20.0;
            case Difficulty.NORMAL -> 40.0;
            case Difficulty.HARD -> 60.0;
            default -> 0.0;
        };
    }

    private void addQualifiedGroupPlayerIfNeeded(LivingDamageEvent.Post event) {
        if (event.getEntity().getType().is(EntityTagGenerator.MULTIPLAYER_INCLUSIVE_ENTITIES)) {
            MultiplayerInclusivityAttachment data = (MultiplayerInclusivityAttachment)event.getEntity().getData(TFDataAttachments.MULTIPLAYER_FIGHT);
            if (event.getSource().getEntity() != null) {
                data.maybeAddQualifiedPlayer(event.getSource().getEntity());
            }
        }
    }

    private void grantGroupAdvancementIfNeeded(LivingDeathEvent event) {
        if (!event.isCanceled() && event.getEntity().hasData(TFDataAttachments.MULTIPLAYER_FIGHT)) {
            ((MultiplayerInclusivityAttachment)event.getEntity().getData(TFDataAttachments.MULTIPLAYER_FIGHT)).grantGroupAdvancement(event.getEntity());
        }
    }

    private void lichBombsDontBlowUpItems(ExplosionEvent.Detonate event) {
        if (event.getExplosion().getDirectSourceEntity() instanceof LichBomb) {
            event.getAffectedEntities().removeIf(entity -> entity instanceof ItemEntity || entity instanceof LichBomb);
        }
    }

    private void handleQuestSyncing(OnDatapackSyncEvent event) {
        if (event.getPlayer() != null) {
            PacketDistributor.sendToPlayer((ServerPlayer)event.getPlayer(), (CustomPacketPayload)new SyncQuestsPacket(this.questingRamCurrentContext.getContext()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            event.getPlayerList().getPlayers().forEach(player -> PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncQuestsPacket(this.questingRamCurrentContext.getContext()), (CustomPacketPayload[])new CustomPacketPayload[0]));
        }
    }

    private void resetFlaskLogic(AdvancementEvent.AdvancementEarnEvent event) {
        for (Map.Entry criteria : event.getAdvancement().value().criteria().entrySet()) {
            if (!(((Criterion)criteria.getValue()).trigger() instanceof DrinkFromFlaskTrigger)) continue;
            ((PotionFlaskTrackingAttachment)event.getEntity().getData(TFDataAttachments.FLASK_DOSES)).resetDoses();
            break;
        }
    }

    private void handleLeashPathingOverrides(EntityJoinLevelEvent event) {
        PathfinderMob mob;
        Entity entity = event.getEntity();
        if (!(entity instanceof PathfinderMob) || !(mob = (PathfinderMob)entity).hasData(TFDataAttachments.LEASH_PATHFINDER_OVERRIDE)) {
            return;
        }
        if (!mob.mayBeLeashed()) {
            mob.removeData(TFDataAttachments.LEASH_PATHFINDER_OVERRIDE);
        }
    }

    private void stopEndermenFromGrabbingBlocksInTF(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof EnderMan) {
            EnderMan enderMan = (EnderMan)entity;
            enderMan.goalSelector.getAvailableGoals().stream().filter(g -> g.getGoal() instanceof EnderMan.EndermanTakeBlockGoal).findAny().ifPresent(g -> {
                enderMan.goalSelector.removeGoal(g.getGoal());
                enderMan.goalSelector.addGoal(g.getPriority(), (Goal)new ExtendedEndermanTakeBlockGoal((EnderMan.EndermanTakeBlockGoal)g.getGoal(), enderMan));
            });
        }
    }

    static class ExtendedEndermanTakeBlockGoal
    extends EnderMan.EndermanTakeBlockGoal {
        private final EnderMan.EndermanTakeBlockGoal delegate;
        private final EnderMan enderman;

        public ExtendedEndermanTakeBlockGoal(EnderMan.EndermanTakeBlockGoal delegate, EnderMan enderman) {
            super(enderman);
            this.delegate = delegate;
            this.enderman = enderman;
        }

        public boolean canUse() {
            return this.delegate.canUse() && !this.enderman.level().dimensionTypeRegistration().is(TFDimensionData.TWILIGHT_DIM_TYPE);
        }

        public void tick() {
            this.delegate.tick();
        }
    }
}

