/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.passive.quest.ram;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootTable;
import twilightforest.loot.TFLootTables;

public record QuestingRamContext(Map<DyeColor, Ingredient> questItems, ResourceKey<LootTable> lootTable) {
    public static final QuestingRamContext FALLBACK = new QuestingRamContext((Map<DyeColor, Ingredient>)ImmutableMap.builder().put((Object)DyeColor.WHITE, (Object)Ingredient.of((ItemLike[])new ItemLike[]{Items.WHITE_WOOL})).put((Object)DyeColor.LIGHT_GRAY, (Object)Ingredient.of((ItemLike[])new ItemLike[]{Items.LIGHT_GRAY_WOOL})).put((Object)DyeColor.GRAY, (Object)Ingredient.of((ItemLike[])new ItemLike[]{Items.GRAY_WOOL})).put((Object)DyeColor.BLACK, (Object)Ingredient.of((ItemLike[])new ItemLike[]{Items.BLACK_WOOL})).put((Object)DyeColor.RED, (Object)Ingredient.of((ItemLike[])new ItemLike[]{Items.RED_WOOL})).put((Object)DyeColor.ORANGE, (Object)Ingredient.of((ItemLike[])new ItemLike[]{Items.ORANGE_WOOL})).put((Object)DyeColor.YELLOW, (Object)Ingredient.of((ItemLike[])new ItemLike[]{Items.YELLOW_WOOL})).put((Object)DyeColor.GREEN, (Object)Ingredient.of((ItemLike[])new ItemLike[]{Items.GREEN_WOOL})).put((Object)DyeColor.LIME, (Object)Ingredient.of((ItemLike[])new ItemLike[]{Items.LIME_WOOL})).put((Object)DyeColor.BLUE, (Object)Ingredient.of((ItemLike[])new ItemLike[]{Items.BLUE_WOOL})).put((Object)DyeColor.CYAN, (Object)Ingredient.of((ItemLike[])new ItemLike[]{Items.CYAN_WOOL})).put((Object)DyeColor.LIGHT_BLUE, (Object)Ingredient.of((ItemLike[])new ItemLike[]{Items.LIGHT_BLUE_WOOL})).put((Object)DyeColor.PURPLE, (Object)Ingredient.of((ItemLike[])new ItemLike[]{Items.PURPLE_WOOL})).put((Object)DyeColor.MAGENTA, (Object)Ingredient.of((ItemLike[])new ItemLike[]{Items.MAGENTA_WOOL})).put((Object)DyeColor.PINK, (Object)Ingredient.of((ItemLike[])new ItemLike[]{Items.PINK_WOOL})).put((Object)DyeColor.BROWN, (Object)Ingredient.of((ItemLike[])new ItemLike[]{Items.BROWN_WOOL})).build(), TFLootTables.QUESTING_RAM_REWARDS);
    public static final Codec<QuestingRamContext> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)DyeColor.CODEC, (Codec)Ingredient.CODEC_NONEMPTY).validate(QuestingRamContext::validate).fieldOf("items").forGetter(QuestingRamContext::questItems), (App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).fieldOf("reward").forGetter(QuestingRamContext::lootTable)).apply((Applicative)instance, QuestingRamContext::new));

    private static DataResult<Map<DyeColor, Ingredient>> validate(Map<DyeColor, Ingredient> map) {
        int colorFlags = 0;
        for (DyeColor color : map.keySet()) {
            colorFlags |= 1 << color.getId();
        }
        if (Integer.bitCount(colorFlags) == 16) {
            return DataResult.success(map);
        }
        return DataResult.error(() -> "Questing Ram quest must contain all 16 dye colors");
    }
}

