/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import twilightforest.data.tags.EntityTagGenerator;
import twilightforest.entity.IHostileMount;
import twilightforest.entity.ai.goal.ChargeAttackGoal;
import twilightforest.init.TFDamageTypes;
import twilightforest.init.TFSounds;
import twilightforest.util.entities.EntityUtil;

public class PinchBeetle
extends Monster
implements IHostileMount {
    public PinchBeetle(EntityType<? extends PinchBeetle> type, Level world) {
        super(type, world);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new ChargeAttackGoal((PathfinderMob)this, 1.5f, false));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.MOVEMENT_SPEED, 0.23).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.ARMOR, 2.0);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)TFSounds.PINCH_BEETLE_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)TFSounds.PINCH_BEETLE_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)TFSounds.PINCH_BEETLE_DEATH.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound((SoundEvent)TFSounds.PINCH_BEETLE_STEP.get(), 0.15f, 1.0f);
    }

    public void aiStep() {
        super.aiStep();
        this.dimensions = this.getDimensions(this.getPose());
        if (!this.getPassengers().isEmpty()) {
            Entity passenger = (Entity)this.getPassengers().getFirst();
            if (passenger.getVehicle() != this) {
                this.removePassenger(passenger);
                return;
            }
            this.getLookControl().setLookAt(passenger, 100.0f, 100.0f);
            if (passenger instanceof LivingEntity) {
                LivingEntity entity = (LivingEntity)passenger;
                this.setTarget(entity);
            }
            if (passenger instanceof Player) {
                Player player = (Player)passenger;
                if (player.getAbilities().invulnerable) {
                    player.stopRiding();
                    this.setTarget(null);
                }
            }
        }
    }

    public void die(DamageSource source) {
        if (!this.getPassengers().isEmpty()) {
            this.getPassengers().forEach(Entity::stopRiding);
        }
        super.die(source);
    }

    public void knockback(double x, double y, double z) {
        if (this.getPassengers().isEmpty()) {
            super.knockback(x, y, z);
        }
    }

    public boolean doHurtTarget(Entity entity) {
        Entity v;
        if (this.getPassengers().isEmpty() && ((v = entity.getVehicle()) == null || !v.getType().is(EntityTagGenerator.RIDES_OBSTRUCT_SNATCHING))) {
            entity.stopRiding();
            entity.startRiding((Entity)this, true);
        }
        return EntityUtil.properlyApplyCustomDamageSource((Mob)this, entity, TFDamageTypes.getEntityDamageSource(this.level(), TFDamageTypes.CLAMPED, (Entity)this, new EntityType[0]), null);
    }

    public boolean startRiding(Entity entity, boolean force) {
        if (entity instanceof Boat) {
            Boat boat = (Boat)entity;
            boat.kill();
            if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                for (int i = 0; i < 3; ++i) {
                    this.spawnAtLocation((ItemLike)boat.getVariant().getPlanks());
                }
                for (int j = 0; j < 2; ++j) {
                    this.spawnAtLocation((ItemLike)Items.STICK);
                }
            }
            this.playSound(SoundEvents.ZOMBIE_BREAK_WOODEN_DOOR);
            return false;
        }
        return super.startRiding(entity, force);
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float yRot) {
        return new Vec3(0.0, (double)this.getEyeHeight(), 0.75);
    }

    public boolean canRiderInteract() {
        return true;
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        if (!this.getPassengers().isEmpty()) {
            return EntityDimensions.scalable((float)2.2f, (float)1.6f);
        }
        return super.getDefaultDimensions(pose);
    }
}

