/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import twilightforest.entity.SpikeBlock;
import twilightforest.entity.TFPart;
import twilightforest.entity.ai.goal.AvoidAnyEntityGoal;
import twilightforest.entity.ai.goal.ThrowSpikeBlockGoal;
import twilightforest.init.TFDamageTypes;
import twilightforest.init.TFSounds;
import twilightforest.util.entities.EntityUtil;

public class BlockChainGoblin
extends Monster {
    private static final float CHAIN_SPEED = 16.0f;
    private static final EntityDataAccessor<Byte> DATA_CHAINLENGTH = SynchedEntityData.defineId(BlockChainGoblin.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Byte> DATA_CHAINPOS = SynchedEntityData.defineId(BlockChainGoblin.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Boolean> IS_THROWING = SynchedEntityData.defineId(BlockChainGoblin.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private int recoilCounter;
    private float chainAngle;
    private float chainMoveLength;
    public final SpikeBlock block = new SpikeBlock((Entity)this);
    private final MultipartGenericsAreDumb[] partsArray = new MultipartGenericsAreDumb[]{this.block};

    public BlockChainGoblin(EntityType<? extends BlockChainGoblin> type, Level level) {
        super(type, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, new AvoidAnyEntityGoal<PrimedTnt>((PathfinderMob)this, PrimedTnt.class, 2.0f, 1.0, 2.0));
        this.goalSelector.addGoal(4, (Goal)new ThrowSpikeBlockGoal(this, this.block));
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_CHAINLENGTH, (Object)0);
        builder.define(DATA_CHAINPOS, (Object)0);
        builder.define(IS_THROWING, (Object)false);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.28).add(Attributes.ATTACK_DAMAGE, 8.0).add(Attributes.ARMOR, 11.0);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)TFSounds.BLOCKCHAIN_GOBLIN_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)TFSounds.BLOCKCHAIN_GOBLIN_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)TFSounds.BLOCKCHAIN_GOBLIN_DEATH.get();
    }

    public double getChainYOffset() {
        return 1.5 - (double)this.getChainLength() / 4.0;
    }

    public Vec3 getChainPosition() {
        return this.getChainPosition(this.getChainAngle(), this.getChainLength());
    }

    public Vec3 getChainPosition(float angle, float distance) {
        double dx = Math.cos((double)angle * Math.PI / 180.0) * (double)distance;
        double dz = Math.sin((double)angle * Math.PI / 180.0) * (double)distance;
        return new Vec3(this.getX() + dx, this.getY() + this.getChainYOffset(), this.getZ() + dz);
    }

    public boolean isSwingingChain() {
        return this.swinging || this.getTarget() != null && this.recoilCounter == 0;
    }

    public boolean doHurtTarget(Entity entity) {
        return EntityUtil.properlyApplyCustomDamageSource((Mob)this, entity, TFDamageTypes.getIndirectEntityDamageSource(this.level(), TFDamageTypes.SPIKED, (Entity)this, (Entity)this.block, new EntityType[0]), null);
    }

    public void tick() {
        super.tick();
        this.block.tick();
        if (this.recoilCounter > 0) {
            --this.recoilCounter;
        }
        this.chainAngle += 16.0f;
        this.chainAngle %= 360.0f;
        if (!this.level().isClientSide()) {
            this.getEntityData().set(DATA_CHAINLENGTH, (Object)((byte)Math.floor(this.getChainLength() * 127.0f)));
            this.getEntityData().set(DATA_CHAINPOS, (Object)((byte)Math.floor(this.getChainAngle() / 360.0f * 255.0f)));
        } else if (Math.abs(this.chainAngle - this.getChainAngle()) > 32.0f) {
            this.chainAngle = this.getChainAngle();
        }
        if (this.isAlive()) {
            if (this.chainMoveLength > 0.0f) {
                Vec3 blockPos = this.getThrowPos();
                double sx2 = this.getX();
                double sy2 = this.getY() + (double)this.getBbHeight() - 0.1;
                double sz2 = this.getZ();
                double ox2 = sx2 - blockPos.x();
                double oy2 = sy2 - blockPos.y() - 0.25;
                double oz2 = sz2 - blockPos.z();
                if (this.chainMoveLength >= 6.0f || !this.isAlive()) {
                    this.setThrowing(false);
                }
                this.block.setPos(sx2 - ox2, sy2 - oy2, sz2 - oz2);
            } else {
                Vec3 blockPos = this.getChainPosition();
                this.block.setPos(blockPos.x(), blockPos.y(), blockPos.z());
            }
            this.block.setYRot(this.getChainAngle());
        }
        if (!this.level().isClientSide() && this.isAlive() && (this.isThrowing() || this.isSwingingChain())) {
            this.applyBlockCollisions((Entity)this.block);
        }
        this.chainMove();
    }

    private Vec3 getThrowPos() {
        Vec3 vec3d = this.getViewVector(1.0f);
        return new Vec3(this.getX() + vec3d.x() * (double)this.chainMoveLength, this.getY() + (double)this.getEyeHeight(), this.getZ() + vec3d.z() * (double)this.chainMoveLength);
    }

    private void chainMove() {
        this.chainMoveLength = this.isThrowing() ? Mth.clamp((float)(this.chainMoveLength + 0.5f), (float)0.0f, (float)6.0f) : Mth.clamp((float)(this.chainMoveLength - 1.5f), (float)0.0f, (float)6.0f);
    }

    public float getChainMoveLength() {
        return this.chainMoveLength;
    }

    protected void applyBlockCollisions(Entity collider) {
        List list = this.level().getEntities(collider, collider.getBoundingBox().inflate(0.2, 0.0, 0.2));
        for (Entity entity : list) {
            if (!entity.isPushable()) continue;
            this.applyBlockCollision(collider, entity);
        }
        if (this.isThrowing() && collider.isInWall()) {
            this.setThrowing(false);
            collider.playSound((SoundEvent)TFSounds.BLOCK_AND_CHAIN_COLLIDE.get(), 0.65f, 0.75f);
            this.gameEvent((Holder)GameEvent.HIT_GROUND);
        }
    }

    protected void applyBlockCollision(Entity collider, Entity collided) {
        if (collided != this) {
            collided.push(collider);
            if (collided instanceof LivingEntity && super.doHurtTarget(collided)) {
                collided.push(0.0, 0.4, 0.0);
                this.playSound((SoundEvent)TFSounds.BLOCK_AND_CHAIN_HIT.get(), 1.0f, 1.0f);
                this.gameEvent((Holder)GameEvent.PROJECTILE_LAND);
                this.recoilCounter = 40;
                if (this.isThrowing()) {
                    this.setThrowing(false);
                }
            }
        }
    }

    public boolean isThrowing() {
        return (Boolean)this.getEntityData().get(IS_THROWING);
    }

    public void setThrowing(boolean isThrowing) {
        this.getEntityData().set(IS_THROWING, (Object)isThrowing);
    }

    private float getChainAngle() {
        if (!this.level().isClientSide()) {
            return this.chainAngle;
        }
        return (float)((Byte)this.getEntityData().get(DATA_CHAINPOS) & 0xFF) / 255.0f * 360.0f;
    }

    private float getChainLength() {
        if (!this.level().isClientSide()) {
            if (this.isSwingingChain()) {
                return 0.9f;
            }
            return 0.3f;
        }
        return (float)((Byte)this.getEntityData().get(DATA_CHAINLENGTH) & 0xFF) / 127.0f;
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        TFPart.assignPartIDs((Entity)this);
    }

    public MultipartGenericsAreDumb[] getParts() {
        return this.partsArray;
    }

    public static abstract class MultipartGenericsAreDumb
    extends TFPart<Entity> {
        public MultipartGenericsAreDumb(Entity parent) {
            super(parent);
        }
    }
}

