/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import twilightforest.entity.boss.Hydra;
import twilightforest.entity.boss.HydraHead;
import twilightforest.entity.boss.HydraMortar;
import twilightforest.entity.boss.HydraNeck;
import twilightforest.entity.boss.HydraPart;
import twilightforest.init.TFDamageTypes;
import twilightforest.init.TFEntities;
import twilightforest.init.TFParticleType;
import twilightforest.init.TFSounds;
import twilightforest.network.MovePlayerPacket;

public class HydraHeadContainer {
    private static final int FLAME_BURN_FACTOR = 3;
    private static final int FLAME_DAMAGE = 19;
    private static final int BITE_DAMAGE = 48;
    private static double FLAME_BREATH_TRACKING_SPEED = 0.04;
    @Nullable
    private static final State NEXT_AUTOMATIC = null;
    public final HydraHead headEntity;
    public final HydraNeck necka;
    public final HydraNeck neckb;
    public final HydraNeck neckc;
    public final HydraNeck neckd;
    public final HydraNeck necke;
    @Nullable
    public Entity targetEntity;
    private double targetX;
    private double targetY;
    private double targetZ;
    @Nullable
    private State prevState;
    private State currentState;
    @Nullable
    private State nextState;
    public boolean isSecondaryAttacking;
    private int ticksNeeded;
    private int ticksProgress;
    private final int headNum;
    private int damageTaken;
    private int respawnCounter;
    private int deathTime;
    private final Hydra hydra;
    private final Map<State, Float>[] stateNeckLength;
    private final Map<State, Float>[] stateXRotations;
    private final Map<State, Float>[] stateYRotations;
    private final Map<State, Float>[] stateMouthOpen;

    public HydraHeadContainer(Hydra hydra, int number, boolean startActive) {
        this.headNum = number;
        this.hydra = hydra;
        this.damageTaken = 0;
        this.respawnCounter = -1;
        this.headEntity = new HydraHead(hydra);
        this.headEntity.setPos(hydra.getX(), hydra.getY(), hydra.getZ());
        this.necka = new HydraNeck(this.headEntity);
        this.neckb = new HydraNeck(this.headEntity);
        this.neckc = new HydraNeck(this.headEntity);
        this.neckd = new HydraNeck(this.headEntity);
        this.necke = new HydraNeck(this.headEntity);
        this.stateNeckLength = new Map[7];
        this.stateXRotations = new Map[7];
        this.stateYRotations = new Map[7];
        this.stateMouthOpen = new Map[7];
        for (int i = 0; i < 7; ++i) {
            this.stateNeckLength[i] = new EnumMap<State, Float>(State.class);
            this.stateXRotations[i] = new EnumMap<State, Float>(State.class);
            this.stateYRotations[i] = new EnumMap<State, Float>(State.class);
            this.stateMouthOpen[i] = new EnumMap<State, Float>(State.class);
        }
        this.setupStateRotations();
        if (startActive) {
            this.prevState = State.IDLE;
            this.currentState = State.IDLE;
            this.nextState = NEXT_AUTOMATIC;
            this.ticksNeeded = 60;
            this.ticksProgress = 60;
        } else {
            this.prevState = State.DEAD;
            this.currentState = State.DEAD;
            this.nextState = NEXT_AUTOMATIC;
            this.ticksNeeded = 20;
            this.ticksProgress = 20;
        }
        this.setHeadPosition();
        this.setNeckPosition();
    }

    protected void setupStateRotations() {
        this.setAnimation(0, State.IDLE, 60.0f, 0.0f, 7.0f, 0.0f);
        this.setAnimation(1, State.IDLE, 10.0f, 60.0f, 9.0f, 0.0f);
        this.setAnimation(2, State.IDLE, 10.0f, -60.0f, 9.0f, 0.0f);
        this.setAnimation(3, State.IDLE, 50.0f, 90.0f, 8.0f, 0.0f);
        this.setAnimation(4, State.IDLE, 50.0f, -90.0f, 8.0f, 0.0f);
        this.setAnimation(5, State.IDLE, -10.0f, 90.0f, 9.0f, 0.0f);
        this.setAnimation(6, State.IDLE, -10.0f, -90.0f, 9.0f, 0.0f);
        this.setAnimation(0, State.ATTACK_COOLDOWN, 60.0f, 0.0f, 7.0f, 0.0f);
        this.setAnimation(1, State.ATTACK_COOLDOWN, 10.0f, 60.0f, 9.0f, 0.0f);
        this.setAnimation(2, State.ATTACK_COOLDOWN, 10.0f, -60.0f, 9.0f, 0.0f);
        this.setAnimation(3, State.ATTACK_COOLDOWN, 50.0f, 90.0f, 8.0f, 0.0f);
        this.setAnimation(4, State.ATTACK_COOLDOWN, 50.0f, -90.0f, 8.0f, 0.0f);
        this.setAnimation(5, State.ATTACK_COOLDOWN, -10.0f, 90.0f, 9.0f, 0.0f);
        this.setAnimation(6, State.ATTACK_COOLDOWN, -10.0f, -90.0f, 9.0f, 0.0f);
        this.setAnimation(0, State.FLAME_BEGINNING, 50.0f, 0.0f, 8.0f, 0.75f);
        this.setAnimation(1, State.FLAME_BEGINNING, 30.0f, 45.0f, 9.0f, 0.75f);
        this.setAnimation(2, State.FLAME_BEGINNING, 30.0f, -45.0f, 9.0f, 0.75f);
        this.setAnimation(3, State.FLAME_BEGINNING, 50.0f, 90.0f, 8.0f, 0.75f);
        this.setAnimation(4, State.FLAME_BEGINNING, 50.0f, -90.0f, 8.0f, 0.75f);
        this.setAnimation(5, State.FLAME_BEGINNING, -10.0f, 90.0f, 9.0f, 0.75f);
        this.setAnimation(6, State.FLAME_BEGINNING, -10.0f, -90.0f, 9.0f, 0.75f);
        this.setAnimation(0, State.FLAMING, 45.0f, 0.0f, 8.0f, 1.0f);
        this.setAnimation(1, State.FLAMING, 30.0f, 60.0f, 9.0f, 1.0f);
        this.setAnimation(2, State.FLAMING, 30.0f, -60.0f, 9.0f, 1.0f);
        this.setAnimation(3, State.FLAMING, 50.0f, 90.0f, 8.0f, 1.0f);
        this.setAnimation(4, State.FLAMING, 50.0f, -90.0f, 8.0f, 1.0f);
        this.setAnimation(5, State.FLAMING, -10.0f, 90.0f, 9.0f, 1.0f);
        this.setAnimation(6, State.FLAMING, -10.0f, -90.0f, 9.0f, 1.0f);
        this.setAnimation(0, State.FLAME_ENDING, 60.0f, 0.0f, 7.0f, 0.0f);
        this.setAnimation(1, State.FLAME_ENDING, 10.0f, 45.0f, 9.0f, 0.0f);
        this.setAnimation(2, State.FLAME_ENDING, 10.0f, -45.0f, 9.0f, 0.0f);
        this.setAnimation(3, State.FLAME_ENDING, 50.0f, 90.0f, 8.0f, 0.0f);
        this.setAnimation(4, State.FLAME_ENDING, 50.0f, -90.0f, 8.0f, 0.0f);
        this.setAnimation(5, State.FLAME_ENDING, -10.0f, 90.0f, 9.0f, 0.0f);
        this.setAnimation(6, State.FLAME_ENDING, -10.0f, -90.0f, 9.0f, 0.0f);
        this.setAnimation(0, State.BITE_BEGINNING, -5.0f, 60.0f, 5.0f, 0.25f);
        this.setAnimation(1, State.BITE_BEGINNING, -10.0f, 60.0f, 9.0f, 0.25f);
        this.setAnimation(2, State.BITE_BEGINNING, -10.0f, -60.0f, 9.0f, 0.25f);
        this.setAnimation(0, State.BITE_READY, -5.0f, 60.0f, 5.0f, 1.0f);
        this.setAnimation(1, State.BITE_READY, -10.0f, 60.0f, 9.0f, 1.0f);
        this.setAnimation(2, State.BITE_READY, -10.0f, -60.0f, 9.0f, 1.0f);
        this.setAnimation(0, State.BITING, -5.0f, -30.0f, 5.0f, 0.2f);
        this.setAnimation(1, State.BITING, -10.0f, -30.0f, 5.0f, 0.2f);
        this.setAnimation(2, State.BITING, -10.0f, 30.0f, 5.0f, 0.2f);
        this.setAnimation(0, State.BITE_ENDING, 60.0f, 0.0f, 7.0f, 0.0f);
        this.setAnimation(1, State.BITE_ENDING, -10.0f, 60.0f, 9.0f, 0.0f);
        this.setAnimation(2, State.BITE_ENDING, -10.0f, -60.0f, 9.0f, 0.0f);
        this.setAnimation(0, State.MORTAR_BEGINNING, 50.0f, 0.0f, 8.0f, 0.75f);
        this.setAnimation(1, State.MORTAR_BEGINNING, 30.0f, 45.0f, 9.0f, 0.75f);
        this.setAnimation(2, State.MORTAR_BEGINNING, 30.0f, -45.0f, 9.0f, 0.75f);
        this.setAnimation(3, State.MORTAR_BEGINNING, 50.0f, 90.0f, 8.0f, 0.75f);
        this.setAnimation(4, State.MORTAR_BEGINNING, 50.0f, -90.0f, 8.0f, 0.75f);
        this.setAnimation(5, State.MORTAR_BEGINNING, -10.0f, 90.0f, 9.0f, 0.75f);
        this.setAnimation(6, State.MORTAR_BEGINNING, -10.0f, -90.0f, 9.0f, 0.75f);
        this.setAnimation(0, State.MORTAR_SHOOTING, 45.0f, 0.0f, 8.0f, 1.0f);
        this.setAnimation(1, State.MORTAR_SHOOTING, 30.0f, 60.0f, 9.0f, 1.0f);
        this.setAnimation(2, State.MORTAR_SHOOTING, 30.0f, -60.0f, 9.0f, 1.0f);
        this.setAnimation(3, State.MORTAR_SHOOTING, 50.0f, 90.0f, 8.0f, 1.0f);
        this.setAnimation(4, State.MORTAR_SHOOTING, 50.0f, -90.0f, 8.0f, 1.0f);
        this.setAnimation(5, State.MORTAR_SHOOTING, -10.0f, 90.0f, 9.0f, 1.0f);
        this.setAnimation(6, State.MORTAR_SHOOTING, -10.0f, -90.0f, 9.0f, 1.0f);
        this.setAnimation(0, State.MORTAR_ENDING, 60.0f, 0.0f, 7.0f, 0.0f);
        this.setAnimation(1, State.MORTAR_ENDING, 10.0f, 45.0f, 9.0f, 0.0f);
        this.setAnimation(2, State.MORTAR_ENDING, 10.0f, -45.0f, 9.0f, 0.0f);
        this.setAnimation(3, State.MORTAR_ENDING, 50.0f, 90.0f, 8.0f, 0.0f);
        this.setAnimation(4, State.MORTAR_ENDING, 50.0f, -90.0f, 8.0f, 0.0f);
        this.setAnimation(5, State.MORTAR_ENDING, -10.0f, 90.0f, 9.0f, 0.0f);
        this.setAnimation(6, State.MORTAR_ENDING, -10.0f, -90.0f, 9.0f, 0.0f);
        this.setAnimation(0, State.DYING, -20.0f, 0.0f, 7.0f, 0.0f);
        this.setAnimation(1, State.DYING, -20.0f, 60.0f, 9.0f, 0.0f);
        this.setAnimation(2, State.DYING, -20.0f, -60.0f, 9.0f, 0.0f);
        this.setAnimation(3, State.DYING, -20.0f, 90.0f, 8.0f, 0.0f);
        this.setAnimation(4, State.DYING, -20.0f, -90.0f, 8.0f, 0.0f);
        this.setAnimation(5, State.DYING, -10.0f, 90.0f, 9.0f, 0.0f);
        this.setAnimation(6, State.DYING, -10.0f, -90.0f, 9.0f, 0.0f);
        this.setAnimation(0, State.DEAD, 0.0f, 179.0f, 4.0f, 0.0f);
        this.setAnimation(1, State.DEAD, 0.0f, 179.0f, 4.0f, 0.0f);
        this.setAnimation(2, State.DEAD, 0.0f, -180.0f, 4.0f, 0.0f);
        this.setAnimation(3, State.DEAD, 0.0f, 179.0f, 4.0f, 0.0f);
        this.setAnimation(4, State.DEAD, 0.0f, -180.0f, 4.0f, 0.0f);
        this.setAnimation(5, State.DEAD, 0.0f, 179.0f, 4.0f, 0.0f);
        this.setAnimation(6, State.DEAD, 0.0f, -180.0f, 4.0f, 0.0f);
        this.setAnimation(0, State.BORN, 60.0f, 0.0f, 7.0f, 0.0f);
        this.setAnimation(1, State.BORN, 10.0f, 60.0f, 9.0f, 0.0f);
        this.setAnimation(2, State.BORN, 10.0f, -60.0f, 9.0f, 0.0f);
        this.setAnimation(3, State.BORN, 50.0f, 90.0f, 8.0f, 0.0f);
        this.setAnimation(4, State.BORN, 50.0f, -90.0f, 8.0f, 0.0f);
        this.setAnimation(5, State.BORN, -10.0f, 90.0f, 9.0f, 0.0f);
        this.setAnimation(6, State.BORN, -10.0f, -90.0f, 9.0f, 0.0f);
        this.setAnimation(0, State.ROAR_START, 60.0f, 0.0f, 7.0f, 0.25f);
        this.setAnimation(1, State.ROAR_START, 10.0f, 60.0f, 9.0f, 0.25f);
        this.setAnimation(2, State.ROAR_START, 10.0f, -60.0f, 9.0f, 0.25f);
        this.setAnimation(3, State.ROAR_START, 50.0f, 90.0f, 8.0f, 0.25f);
        this.setAnimation(4, State.ROAR_START, 50.0f, -90.0f, 8.0f, 0.25f);
        this.setAnimation(5, State.ROAR_START, -10.0f, 90.0f, 9.0f, 0.25f);
        this.setAnimation(6, State.ROAR_START, -10.0f, -90.0f, 9.0f, 0.25f);
        this.setAnimation(0, State.ROAR_RAWR, 60.0f, 0.0f, 9.0f, 1.0f);
        this.setAnimation(1, State.ROAR_RAWR, 10.0f, 60.0f, 11.0f, 1.0f);
        this.setAnimation(2, State.ROAR_RAWR, 10.0f, -60.0f, 11.0f, 1.0f);
        this.setAnimation(3, State.ROAR_RAWR, 50.0f, 90.0f, 10.0f, 1.0f);
        this.setAnimation(4, State.ROAR_RAWR, 50.0f, -90.0f, 10.0f, 1.0f);
        this.setAnimation(5, State.ROAR_RAWR, -10.0f, 90.0f, 11.0f, 1.0f);
        this.setAnimation(6, State.ROAR_RAWR, -10.0f, -90.0f, 11.0f, 1.0f);
    }

    private void setAnimation(int head, State state, float xRotation, float yRotation, float neckLength, float mouthOpen) {
        this.stateXRotations[head].put(state, Float.valueOf(xRotation));
        this.stateYRotations[head].put(state, Float.valueOf(yRotation));
        this.stateNeckLength[head].put(state, Float.valueOf(neckLength));
        this.stateMouthOpen[head].put(state, Float.valueOf(mouthOpen));
    }

    public HydraNeck[] getNeckArray() {
        return new HydraNeck[]{this.necka, this.neckb, this.neckc, this.neckd, this.necke};
    }

    public void performOnAllNecks(Consumer<HydraNeck> consumer) {
        for (int i = 0; i < this.getNeckArray().length; ++i) {
            consumer.accept(this.getNeckArray()[i]);
        }
    }

    public void tick() {
        this.headEntity.tick();
        this.performOnAllNecks(HydraPart::tick);
        this.setDifficultyVariables();
        if (!this.hydra.level().isClientSide()) {
            if (!this.isDead() && this.headEntity.dimensions.width() == 0.0f) {
                this.headEntity.activate();
                this.performOnAllNecks(HydraPart::activate);
            } else if (!this.isActive() && this.headEntity.dimensions.width() > 0.0f) {
                this.headEntity.deactivate();
                this.performOnAllNecks(HydraPart::deactivate);
            }
            this.advanceRespawnCounter();
            this.advanceHeadState();
            this.setHeadPosition();
            this.setHeadFacing();
            this.executeAttacks();
            this.playSounds();
        } else {
            this.addMouthParticles();
        }
        this.animateHeadDeath();
        this.setNeckPosition();
    }

    public boolean canRespawn() {
        return this.currentState == State.DEAD && this.respawnCounter == -1;
    }

    private void advanceRespawnCounter() {
        if (this.currentState == State.DEAD && this.respawnCounter > -1 && --this.respawnCounter <= 0) {
            this.setNextState(State.BORN);
            this.damageTaken = 0;
            this.endCurrentAction();
            this.respawnCounter = -1;
        }
    }

    private void animateHeadDeath() {
        if (this.headEntity.getState() == State.DYING) {
            ++this.deathTime;
            if (this.deathTime == 1) {
                this.headEntity.markedDead = true;
                this.hydra.setHeadNameFor(this.headNum, "");
                this.headEntity.setCustomName((Component)Component.literal((String)""));
            } else if (this.deathTime == 10) {
                this.getNeckArray()[0].markedDead = true;
            } else if (this.deathTime == 20) {
                this.getNeckArray()[1].markedDead = true;
            } else if (this.deathTime == 30) {
                this.getNeckArray()[2].markedDead = true;
            } else if (this.deathTime == 40) {
                this.getNeckArray()[3].markedDead = true;
            } else if (this.deathTime == 50) {
                this.getNeckArray()[4].markedDead = true;
            }
            this.headEntity.hurtTime = 20;
            this.performOnAllNecks(neck -> {
                neck.hurtTime = 20;
            });
        } else {
            this.deathTime = 0;
        }
    }

    private void advanceHeadState() {
        if (++this.ticksProgress >= this.ticksNeeded) {
            State myNext;
            if (this.nextState == NEXT_AUTOMATIC) {
                myNext = State.NEXT_STATE.get((Object)this.currentState);
                if (myNext != this.currentState && this.isSecondaryAttacking && myNext == State.ATTACK_COOLDOWN) {
                    this.isSecondaryAttacking = false;
                    myNext = State.IDLE;
                }
            } else {
                myNext = this.nextState;
                this.nextState = NEXT_AUTOMATIC;
            }
            this.ticksNeeded = myNext.duration;
            this.ticksProgress = 0;
            this.prevState = this.currentState;
            this.currentState = myNext;
        }
        if (this.headEntity.getState() != this.currentState) {
            this.headEntity.setState(this.currentState);
        }
    }

    private void setHeadFacing() {
        if (this.currentState == State.BITE_READY) {
            float yawOffOffset;
            this.faceEntity(this.targetEntity, 5.0f, this.hydra.getMaxHeadXRot());
            float biteMaxYaw = -60.0f;
            float biteMinYaw = -90.0f;
            if (this.headNum == 2) {
                biteMaxYaw = 60.0f;
                biteMinYaw = 90.0f;
            }
            if ((yawOffOffset = Mth.wrapDegrees((float)(this.headEntity.getYRot() - this.hydra.yBodyRot))) > biteMaxYaw) {
                this.headEntity.setYRot(this.hydra.yBodyRot + biteMaxYaw);
            }
            if (yawOffOffset < biteMinYaw) {
                this.headEntity.setYRot(this.hydra.yBodyRot + biteMinYaw);
            }
            Vec3 look = this.headEntity.getLookAngle();
            double distance = 16.0;
            this.targetX = this.headEntity.getX() + look.x() * distance;
            this.targetY = this.headEntity.getY() + 1.5 + look.y() * distance;
            this.targetZ = this.headEntity.getZ() + look.z() * distance;
        } else if (this.currentState == State.BITING || this.currentState == State.BITE_ENDING) {
            this.faceEntity(this.targetEntity, 5.0f, this.hydra.getMaxHeadXRot());
            this.headEntity.setXRot((float)((double)this.headEntity.getXRot() + 0.7853981633974483));
        } else if (this.currentState == State.ROAR_RAWR) {
            this.faceVec(this.targetX, this.targetY, this.targetZ, 10.0f, this.hydra.getMaxHeadXRot());
        } else if (this.currentState == State.FLAMING || this.currentState == State.FLAME_BEGINNING) {
            this.moveTargetCoordsTowardsTargetEntity(FLAME_BREATH_TRACKING_SPEED);
            this.faceVec(this.targetX, this.targetY, this.targetZ, 5.0f, this.hydra.getMaxHeadXRot());
        } else if (!this.isDead()) {
            if (this.targetEntity != null) {
                this.faceEntity(this.targetEntity, 5.0f, this.hydra.getMaxHeadXRot());
            } else {
                this.faceIdle(1.5f, this.hydra.getMaxHeadXRot());
            }
        }
    }

    private void moveTargetCoordsTowardsTargetEntity(double distance) {
        if (this.targetEntity != null) {
            Vec3 vect = new Vec3(this.targetEntity.getX() - this.targetX, this.targetEntity.getY() - this.targetY, this.targetEntity.getZ() - this.targetZ);
            vect = vect.normalize();
            this.targetX += vect.x() * distance;
            this.targetY += vect.y() * distance;
            this.targetZ += vect.z() * distance;
        }
    }

    private void addMouthParticles() {
        Vec3 vector = this.headEntity.getLookAngle();
        double dist = 3.5;
        double px = this.headEntity.getX() + vector.x() * dist;
        double py = this.headEntity.getY() + 1.0 + vector.y() * dist;
        double pz = this.headEntity.getZ() + vector.z() * dist;
        if (this.headEntity.getState() == State.FLAME_BEGINNING) {
            this.headEntity.level().addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.FLAME, px + this.headEntity.level().getRandom().nextDouble() - 0.5, py + this.headEntity.level().getRandom().nextDouble() - 0.5, pz + this.headEntity.level().getRandom().nextDouble() - 0.5, 0.0, 0.0, 0.0);
            this.headEntity.level().addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.SMOKE, px + this.headEntity.level().getRandom().nextDouble() - 0.5, py + this.headEntity.level().getRandom().nextDouble() - 0.5, pz + this.headEntity.level().getRandom().nextDouble() - 0.5, 0.0, 0.0, 0.0);
        }
        if (this.headEntity.getState() == State.FLAMING) {
            Vec3 look = this.headEntity.getLookAngle();
            for (int i = 0; i < 5; ++i) {
                double dx = look.x();
                double dy = look.y();
                double dz = look.z();
                double spread = 5.0 + this.headEntity.level().getRandom().nextDouble() * 2.5;
                double velocity = 1.0 + this.headEntity.level().getRandom().nextDouble();
                dx += this.headEntity.level().getRandom().nextGaussian() * 0.0075 * spread;
                dy += this.headEntity.level().getRandom().nextGaussian() * 0.0075 * spread;
                dz += this.headEntity.level().getRandom().nextGaussian() * 0.0075 * spread;
                this.headEntity.level().addAlwaysVisibleParticle((ParticleOptions)TFParticleType.LARGE_FLAME.get(), px, py, pz, dx *= velocity, dy *= velocity, dz *= velocity);
            }
        }
        if (this.headEntity.getState() == State.BITE_BEGINNING || this.headEntity.getState() == State.BITE_READY) {
            this.headEntity.level().addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.SPLASH, px + this.headEntity.level().getRandom().nextDouble() - 0.5, py + this.headEntity.level().getRandom().nextDouble() - 0.5, pz + this.headEntity.level().getRandom().nextDouble() - 0.5, 0.0, 0.0, 0.0);
        }
        if (this.headEntity.getState() == State.MORTAR_BEGINNING) {
            this.headEntity.level().addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, px + this.headEntity.level().getRandom().nextDouble() - 0.5, py + this.headEntity.level().getRandom().nextDouble() - 0.5, pz + this.headEntity.level().getRandom().nextDouble() - 0.5, 0.0, 0.0, 0.0);
        }
    }

    private void playSounds() {
        if (this.headEntity.getState() == State.FLAMING && this.headEntity.tickCount % 5 == 0) {
            this.headEntity.playSound((SoundEvent)TFSounds.HYDRA_SHOOT_FIRE.get(), 0.5f + this.headEntity.level().getRandom().nextFloat(), this.headEntity.level().getRandom().nextFloat() * 0.7f + 0.3f);
            this.headEntity.gameEvent((Holder)GameEvent.PROJECTILE_SHOOT);
        }
        if (this.headEntity.getState() == State.ROAR_RAWR) {
            this.headEntity.playSound((SoundEvent)TFSounds.HYDRA_ROAR.get(), 1.25f, this.headEntity.level().getRandom().nextFloat() * 0.3f + 0.7f);
            this.headEntity.gameEvent((Holder)GameEvent.ENTITY_ACTION);
        }
        if (this.headEntity.getState() == State.BITE_READY && this.ticksProgress == 60) {
            this.headEntity.playSound((SoundEvent)TFSounds.HYDRA_WARN.get(), 2.0f, this.headEntity.level().getRandom().nextFloat() * 0.3f + 0.7f);
        }
    }

    protected void setNeckPosition() {
        Vec3 vector = null;
        float neckRotation = 0.0f;
        if (this.headNum == 0) {
            vector = new Vec3(0.0, 3.0, -1.0);
            neckRotation = 0.0f;
        }
        if (this.headNum == 1) {
            vector = new Vec3(-1.0, 3.0, 3.0);
            neckRotation = 90.0f;
        }
        if (this.headNum == 2) {
            vector = new Vec3(1.0, 3.0, 3.0);
            neckRotation = -90.0f;
        }
        if (this.headNum == 3) {
            vector = new Vec3(-1.0, 2.5, 3.0);
            neckRotation = 135.0f;
        }
        if (this.headNum == 4) {
            vector = new Vec3(1.0, 2.5, 3.0);
            neckRotation = -135.0f;
        }
        if (this.headNum == 5) {
            vector = new Vec3(-1.0, 2.0, 5.0);
            neckRotation = 135.0f;
        }
        if (this.headNum == 6) {
            vector = new Vec3(1.0, 2.0, 5.0);
            neckRotation = -135.0f;
        }
        vector = vector.yRot(-(this.hydra.yBodyRot + neckRotation) * (float)Math.PI / 180.0f);
        this.setNeckPosition(this.hydra.getX() + vector.x(), this.hydra.getY() + vector.y(), this.hydra.getZ() + vector.z(), this.hydra.yBodyRot);
    }

    protected void setHeadPosition() {
        float periodX;
        float neckLength = this.getCurrentNeckLength();
        float xRotation = this.getCurrentHeadXRotation();
        float yRotation = this.getCurrentHeadYRotation();
        float f = this.headNum == 0 || this.headNum == 3 ? 20.0f : (periodX = this.headNum == 1 || this.headNum == 4 ? 5.0f : 7.0f);
        float periodY = this.headNum == 0 || this.headNum == 4 ? 10.0f : (this.headNum == 1 || this.headNum == 6 ? 6.0f : 5.0f);
        float xSwing = Mth.sin((float)((float)this.hydra.tickCount / periodX)) * 3.0f;
        float ySwing = Mth.sin((float)((float)this.hydra.tickCount / periodY)) * 5.0f;
        if (this.isDead()) {
            ySwing = 0.0f;
            xSwing = 0.0f;
        }
        Vec3 vector = new Vec3(0.0, 0.0, (double)neckLength);
        vector = vector.xRot((xRotation * (float)Math.PI + xSwing) / 180.0f);
        vector = vector.yRot(-(this.hydra.yBodyRot + yRotation + ySwing) * (float)Math.PI / 180.0f);
        double dx = this.hydra.getX() + vector.x();
        double dy = this.hydra.getY() + vector.y() + 3.0;
        double dz = this.hydra.getZ() + vector.z();
        this.headEntity.setPos(dx, dy, dz);
        this.headEntity.setMouthOpen(this.getCurrentMouthOpen());
    }

    private void executeAttacks() {
        Entity target;
        if (this.currentState == State.MORTAR_SHOOTING && this.ticksProgress % 10 == 0) {
            HydraMortar mortar = new HydraMortar((EntityType<? extends HydraMortar>)((EntityType)TFEntities.HYDRA_MORTAR.get()), this.headEntity.level(), this.headEntity);
            if (this.targetEntity != null && !this.headEntity.canEntityBeSeen(this.targetEntity)) {
                mortar.setToBlasting();
            }
            this.headEntity.playSound((SoundEvent)TFSounds.HYDRA_SHOOT.get(), 10.0f, (this.headEntity.level().getRandom().nextFloat() - this.headEntity.level().getRandom().nextFloat()) * 0.2f + 1.0f);
            this.headEntity.level().addFreshEntity((Entity)mortar);
        }
        if (this.headEntity.getState() == State.BITING) {
            List nearbyList = this.headEntity.level().getEntities((Entity)this.headEntity, this.headEntity.getBoundingBox().inflate(0.0, 1.0, 0.0));
            for (Entity nearby : nearbyList) {
                Player player;
                if (!(nearby instanceof LivingEntity)) continue;
                LivingEntity living = (LivingEntity)nearby;
                if (nearby == this.hydra) continue;
                if (nearby instanceof Player && (player = (Player)nearby).isBlocking()) {
                    if (!player.getCooldowns().isOnCooldown(player.getUseItem().getItem())) {
                        this.headEntity.level().playSound(null, player.blockPosition(), player.getUseItem().is(Items.SHIELD) ? (SoundEvent)TFSounds.WOOD_SHIELD_SHATTERS.get() : (SoundEvent)TFSounds.METAL_SHIELD_SHATTERS.get(), SoundSource.PLAYERS, 1.0f, player.getVoicePitch());
                        player.getUseItem().hurtAndBreak(112, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
                    }
                    player.getCooldowns().addCooldown(player.getUseItem().getItem(), 200);
                    player.stopUsingItem();
                    PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new MovePlayerPacket((float)(-this.headEntity.getDirection().getStepX()) * 0.5f, 0.15f, (float)(-this.headEntity.getDirection().getStepZ()) * 0.5f), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                nearby.hurt(TFDamageTypes.getEntityDamageSource(living.level(), TFDamageTypes.HYDRA_BITE, (Entity)this.hydra, (EntityType)TFEntities.HYDRA.get()), 48.0f);
                if (living instanceof Player) {
                    player = (Player)living;
                    PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new MovePlayerPacket((float)(-this.headEntity.getDirection().getStepX()) * 0.5f, 0.1f, (float)(-this.headEntity.getDirection().getStepZ()) * 0.5f), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    continue;
                }
                living.knockback((double)(-this.headEntity.getDirection().getStepX()), (double)0.1f, (double)(-this.headEntity.getDirection().getStepZ()));
            }
        }
        if (!(this.headEntity.getState() != State.FLAMING || (target = this.getHeadLookTarget()) == null || target == this.headEntity.getParent() || target instanceof HydraPart && ((HydraPart)target).getParent() == this.headEntity.getParent() || target.fireImmune() || !target.hurt(TFDamageTypes.getEntityDamageSource(target.level(), TFDamageTypes.HYDRA_FIRE, (Entity)this.hydra, (EntityType)TFEntities.HYDRA.get()), 19.0f))) {
            target.igniteForSeconds(3.0f);
        }
    }

    private void setDifficultyVariables() {
        FLAME_BREATH_TRACKING_SPEED = this.hydra.level().getDifficulty() != Difficulty.HARD ? 0.04 : 0.1;
    }

    @Nullable
    private Entity getHeadLookTarget() {
        Entity pointedEntity = null;
        double range = 30.0;
        Vec3 srcVec = new Vec3(this.headEntity.getX(), this.headEntity.getY() + 1.0, this.headEntity.getZ());
        Vec3 lookVec = this.headEntity.getViewVector(1.0f);
        BlockHitResult raytrace = this.headEntity.level().clip(new ClipContext(srcVec, srcVec.add(lookVec.x() * range, lookVec.y() * range, lookVec.z() * range), ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, (Entity)this.headEntity));
        BlockPos hitpos = raytrace != null ? raytrace.getBlockPos() : null;
        double rx = hitpos == null ? range : Math.min(range, Math.abs(this.headEntity.getX() - (double)hitpos.getX()));
        double ry = hitpos == null ? range : Math.min(range, Math.abs(this.headEntity.getY() - (double)hitpos.getY()));
        double rz = hitpos == null ? range : Math.min(range, Math.abs(this.headEntity.getZ() - (double)hitpos.getZ()));
        Vec3 destVec = srcVec.add(lookVec.x() * range, lookVec.y() * range, lookVec.z() * range);
        float var9 = 3.0f;
        List possibleList = this.headEntity.level().getEntities((Entity)this.headEntity, this.headEntity.getBoundingBox().move(lookVec.x() * rx, lookVec.y() * ry, lookVec.z() * rz).inflate((double)var9, (double)var9, (double)var9));
        double hitDist = 0.0;
        for (Entity possibleEntity : possibleList) {
            double possibleDist;
            if (!possibleEntity.isPickable() || possibleEntity == this.headEntity || possibleEntity == this.necka || possibleEntity == this.neckb || possibleEntity == this.neckc) continue;
            float borderSize = possibleEntity.getPickRadius();
            AABB collisionBB = possibleEntity.getBoundingBox().inflate((double)borderSize, (double)borderSize, (double)borderSize);
            Optional interceptPos = collisionBB.clip(srcVec, destVec);
            if (collisionBB.contains(srcVec)) {
                if (!(0.0 < hitDist) && hitDist != 0.0) continue;
                pointedEntity = possibleEntity;
                hitDist = 0.0;
                continue;
            }
            if (!interceptPos.isPresent() || !((possibleDist = srcVec.distanceTo((Vec3)interceptPos.get())) < hitDist) && hitDist != 0.0) continue;
            pointedEntity = possibleEntity;
            hitDist = possibleDist;
        }
        return pointedEntity;
    }

    public void setNextState(State next) {
        this.nextState = next;
    }

    public void endCurrentAction() {
        this.ticksProgress = this.ticksNeeded;
    }

    private float getCurrentNeckLength() {
        float prevLength = this.stateNeckLength[this.headNum].get((Object)this.prevState).floatValue();
        float curLength = this.stateNeckLength[this.headNum].get((Object)this.currentState).floatValue();
        float progress = (float)this.ticksProgress / (float)this.ticksNeeded;
        return Mth.clampedLerp((float)prevLength, (float)curLength, (float)progress);
    }

    private float getCurrentHeadXRotation() {
        float prevRotation = this.stateXRotations[this.headNum].get((Object)this.prevState).floatValue();
        float currentRotation = this.stateXRotations[this.headNum].get((Object)this.currentState).floatValue();
        float progress = (float)this.ticksProgress / (float)this.ticksNeeded;
        return Mth.clampedLerp((float)prevRotation, (float)currentRotation, (float)progress);
    }

    private float getCurrentHeadYRotation() {
        float prevRotation = this.stateYRotations[this.headNum].get((Object)this.prevState).floatValue();
        float currentRotation = this.stateYRotations[this.headNum].get((Object)this.currentState).floatValue();
        float progress = (float)this.ticksProgress / (float)this.ticksNeeded;
        return Mth.clampedLerp((float)prevRotation, (float)currentRotation, (float)progress);
    }

    protected float getCurrentMouthOpen() {
        float prevOpen = this.stateMouthOpen[this.headNum].get((Object)this.prevState).floatValue();
        float curOpen = this.stateMouthOpen[this.headNum].get((Object)this.currentState).floatValue();
        float progress = (float)this.ticksProgress / (float)this.ticksNeeded;
        return Mth.clampedLerp((float)prevOpen, (float)curOpen, (float)progress);
    }

    protected void setNeckPosition(double startX, double startY, double startZ, float startYaw) {
        double endX = this.headEntity.getX();
        double endY = this.headEntity.getY() - 0.5;
        double endZ = this.headEntity.getZ();
        float endYaw = this.headEntity.getYRot();
        float endPitch = this.headEntity.getXRot();
        while (startYaw - endYaw < -180.0f) {
            endYaw -= 360.0f;
        }
        while (startYaw - endYaw >= 180.0f) {
            endYaw += 360.0f;
        }
        while (0.0f - endPitch < -180.0f) {
            endPitch -= 360.0f;
        }
        while (0.0f - endPitch >= 180.0f) {
            endPitch += 360.0f;
        }
        if (endPitch > 0.0f) {
            vector = new Vec3(0.0, 0.0, -1.8).yRot(-endYaw * 3.141593f / 180.0f);
            endX += vector.x();
            endY += vector.y();
            endZ += vector.z();
        } else {
            vector = this.headEntity.getLookAngle();
            float dist = 1.0f;
            endX -= vector.x() * (double)dist;
            endY -= vector.y() * (double)dist;
            endZ -= vector.z() * (double)dist;
        }
        float factor = 0.0f;
        this.necka.setPos(endX + (startX - endX) * (double)factor, endY + (startY - endY) * (double)factor, endZ + (startZ - endZ) * (double)factor);
        this.necka.setYRot(endYaw + (startYaw - endYaw) * factor);
        this.necka.setXRot(endPitch + (0.0f - endPitch) * factor);
        factor = 0.25f;
        this.neckb.setPos(endX + (startX - endX) * (double)factor, endY + (startY - endY) * (double)factor, endZ + (startZ - endZ) * (double)factor);
        this.neckb.setYRot(endYaw + (startYaw - endYaw) * factor);
        this.neckb.setXRot(endPitch + (0.0f - endPitch) * factor);
        factor = 0.5f;
        this.neckc.setPos(endX + (startX - endX) * (double)factor, endY + (startY - endY) * (double)factor, endZ + (startZ - endZ) * (double)factor);
        this.neckc.setYRot(endYaw + (startYaw - endYaw) * factor);
        this.neckc.setXRot(endPitch + (0.0f - endPitch) * factor);
        factor = 0.75f;
        this.neckd.setPos(endX + (startX - endX) * (double)factor, endY + (startY - endY) * (double)factor, endZ + (startZ - endZ) * (double)factor);
        this.neckd.setYRot(endYaw + (startYaw - endYaw) * factor);
        this.neckd.setXRot(endPitch + (0.0f - endPitch) * factor);
        factor = 1.0f;
        this.necke.setPos(endX + (startX - endX) * (double)factor, endY + (startY - endY) * (double)factor, endZ + (startZ - endZ) * (double)factor);
        this.necke.setYRot(endYaw + (startYaw - endYaw) * factor);
        this.necke.setXRot(endPitch + (0.0f - endPitch) * factor);
    }

    private void faceIdle(float yawConstraint, float pitchConstraint) {
        float angle = this.hydra.getYRot() * 3.141593f / 180.0f;
        float distance = 30.0f;
        double dx = this.hydra.getX() - (double)(Mth.sin((float)angle) * distance);
        double dy = this.hydra.getY() + 3.0;
        double dz = this.hydra.getZ() + (double)(Mth.cos((float)angle) * distance);
        this.faceVec(dx, dy, dz, yawConstraint, pitchConstraint);
    }

    public void faceEntity(@Nullable Entity entity, float yawConstraint, float pitchConstraint) {
        double yTarget;
        if (entity instanceof LivingEntity) {
            LivingEntity entityliving = (LivingEntity)entity;
            yTarget = entityliving.getY() + (double)entityliving.getEyeHeight();
        } else {
            yTarget = (entity.getBoundingBox().minY + entity.getBoundingBox().maxY) / 2.0;
        }
        this.faceVec(entity.getX(), yTarget, entity.getZ(), yawConstraint, pitchConstraint);
        this.targetX = entity.getX();
        this.targetY = entity.getY();
        this.targetZ = entity.getZ();
    }

    private void faceVec(double x, double y, double z, float yawConstraint, float pitchConstraint) {
        double xOffset = x - this.headEntity.getX();
        double zOffset = z - this.headEntity.getZ();
        double yOffset = this.headEntity.getY() + 1.0 - y;
        double distance = Mth.sqrt((float)((float)(xOffset * xOffset + zOffset * zOffset)));
        float xyAngle = (float)(Math.atan2(zOffset, xOffset) * 180.0 / Math.PI) - 90.0f;
        float zdAngle = (float)(-(Math.atan2(yOffset, distance) * 180.0 / Math.PI));
        this.headEntity.setXRot(-this.updateRotation(this.headEntity.getXRot(), zdAngle, pitchConstraint));
        this.headEntity.setYRot(this.updateRotation(this.headEntity.getYRot(), xyAngle, yawConstraint));
    }

    private float updateRotation(float current, float intended, float increment) {
        float delta = Mth.wrapDegrees((float)(intended - current));
        if (delta > increment) {
            delta = increment;
        }
        if (delta < -increment) {
            delta = -increment;
        }
        return Mth.wrapDegrees((float)(current + delta));
    }

    public void setTargetEntity(@Nullable Entity targetEntity) {
        this.targetEntity = targetEntity;
    }

    public void setHurtTime(int hurtTime) {
        if (this.headEntity != null) {
            this.headEntity.hurtTime = hurtTime;
        }
        this.performOnAllNecks(neck -> {
            neck.hurtTime = hurtTime;
        });
    }

    public boolean isActive() {
        return this.currentState != State.DEAD;
    }

    public boolean isDead() {
        return this.currentState == State.DYING || this.currentState == State.DEAD;
    }

    public boolean isIdle() {
        return this.currentState == State.IDLE && (this.nextState == NEXT_AUTOMATIC || this.nextState == State.IDLE);
    }

    public boolean isAttacking() {
        return this.currentState == State.BITE_BEGINNING || this.currentState == State.BITE_READY || this.currentState == State.BITING || this.currentState == State.FLAME_BEGINNING || this.currentState == State.FLAMING || this.currentState == State.MORTAR_BEGINNING || this.currentState == State.MORTAR_SHOOTING;
    }

    public boolean isBiting() {
        return this.currentState == State.BITE_BEGINNING || this.currentState == State.BITE_READY || this.currentState == State.BITING || this.nextState == State.BITE_BEGINNING;
    }

    public void addDamage(float damageAmount) {
        this.damageTaken += (int)damageAmount;
    }

    public int getDamageTaken() {
        return this.damageTaken;
    }

    public void setRespawnCounter(int count) {
        this.respawnCounter = count;
    }

    static enum State {
        IDLE(10),
        BITE_BEGINNING(40),
        BITE_READY(80),
        BITING(7),
        BITE_ENDING(40),
        FLAME_BEGINNING(40),
        FLAMING(100),
        FLAME_ENDING(30),
        MORTAR_BEGINNING(40),
        MORTAR_SHOOTING(25),
        MORTAR_ENDING(30),
        DYING(70),
        DEAD(20),
        ATTACK_COOLDOWN(80),
        BORN(20),
        ROAR_START(10),
        ROAR_RAWR(50);

        private static final Map<State, State> NEXT_STATE;
        public final int duration;

        private State(int duration) {
            this.duration = duration;
        }

        static {
            EnumMap<State, State> b = new EnumMap<State, State>(State.class);
            b.put(IDLE, IDLE);
            b.put(BITE_BEGINNING, BITE_READY);
            b.put(BITE_READY, BITING);
            b.put(BITING, BITE_ENDING);
            b.put(BITE_ENDING, ATTACK_COOLDOWN);
            b.put(FLAME_BEGINNING, FLAMING);
            b.put(FLAMING, FLAME_ENDING);
            b.put(FLAME_ENDING, ATTACK_COOLDOWN);
            b.put(MORTAR_BEGINNING, MORTAR_SHOOTING);
            b.put(MORTAR_SHOOTING, MORTAR_ENDING);
            b.put(MORTAR_ENDING, ATTACK_COOLDOWN);
            b.put(ATTACK_COOLDOWN, IDLE);
            b.put(DYING, DEAD);
            b.put(DEAD, DEAD);
            b.put(BORN, ROAR_START);
            b.put(ROAR_START, ROAR_RAWR);
            b.put(ROAR_RAWR, IDLE);
            NEXT_STATE = ImmutableMap.copyOf(b);
        }
    }
}

