/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import twilightforest.entity.ai.goal.RedcapBaseGoal;
import twilightforest.entity.monster.Redcap;

public class RedcapLightTNTGoal
extends RedcapBaseGoal {
    private final float pursueSpeed;
    private int delay;
    private BlockPos tntPos = null;

    public RedcapLightTNTGoal(Redcap hostEntity, float speed) {
        super(hostEntity);
        this.pursueSpeed = speed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (!EventHooks.canEntityGrief((Level)this.redcap.level(), (Entity)this.redcap)) {
            return false;
        }
        if (this.delay > 0) {
            --this.delay;
            return false;
        }
        BlockPos nearbyTNT = this.findBlockTNTNearby(8);
        if (nearbyTNT != null) {
            this.tntPos = nearbyTNT;
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.redcap.level().getBlockState(this.tntPos).is(Blocks.TNT);
    }

    public void start() {
        this.redcap.setItemSlot(EquipmentSlot.MAINHAND, this.redcap.heldFlint);
    }

    public void stop() {
        this.redcap.getNavigation().stop();
        this.redcap.setItemSlot(EquipmentSlot.MAINHAND, this.redcap.heldPick);
        this.delay = 20;
        this.tntPos = null;
    }

    public void tick() {
        this.redcap.getLookControl().setLookAt((double)this.tntPos.getX(), (double)this.tntPos.getY(), (double)this.tntPos.getZ(), 30.0f, (float)this.redcap.getMaxHeadXRot());
        if (this.redcap.distanceToSqr(Vec3.atLowerCornerOf((Vec3i)this.tntPos)) < 5.76) {
            this.redcap.playAmbientSound();
            Blocks.TNT.onCaughtFire(Blocks.TNT.defaultBlockState(), this.redcap.level(), this.tntPos, Direction.UP, (LivingEntity)this.redcap);
            this.redcap.swing(InteractionHand.MAIN_HAND);
            this.redcap.level().setBlock(this.tntPos, Blocks.AIR.defaultBlockState(), 2);
            this.redcap.gameEvent((Holder)GameEvent.PRIME_FUSE);
            this.redcap.getNavigation().stop();
        } else {
            this.redcap.getNavigation().moveTo((double)this.tntPos.getX(), (double)this.tntPos.getY(), (double)this.tntPos.getZ(), (double)this.pursueSpeed);
        }
    }
}

